package jp.sourceforge.sos.gunmetry.main;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.Enumeration;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

import jp.sourceforge.sos.gunmetry.common.Operation;


@SuppressWarnings("serial")
public class PanelButtons extends JPanel{

	private ButtonGroup		buttonGroup			= new ButtonGroup();

	private AbstractButton[] buttons;
	/**
	 * This method initializes
	 * 
	 */
	public PanelButtons() {
		super();
		initialize();

		setupKeyInput();
	}

	public void add(Component comp, Object cons) {
		super.add(comp, cons);
		if (comp instanceof Operation) {
			buttonGroup.add(((JToggleButton)comp));
		}
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this.setLayout(new GridBagLayout());
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Operation", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
				javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(51, 51, 51)));
	}

	private void setupKeyInput() {
		// setup for key inputs
		KeyboardFocusManager keyboardManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
		keyboardManager.addKeyEventPostProcessor(new KeyEventPostProcessor() {
			public boolean postProcessKeyEvent(KeyEvent evt) {
				if (evt.getID()==KeyEvent.KEY_PRESSED&&evt.getKeyCode()==KeyEvent.VK_X) {
					switchButton();
				}
				return false;
			}
		});
	}

	private void switchButton() {
		if (buttons == null){
			createButtonsArray();
		}
		int index = 0;
		for (int i=0; i<buttons.length; i++){
			if (buttons[i].isSelected()){
				index = (i+1)%buttons.length;
				break;
			}
		}
		buttons[index].doClick();
	}

	/**
	 * 
	 */
	private void createButtonsArray() {
		int n = buttonGroup.getButtonCount();
		buttons = new AbstractButton[n];
		Enumeration<AbstractButton> e = buttonGroup.getElements();
		int i = 0;
		while (e.hasMoreElements()){
			buttons[i++] = e.nextElement();
		}
	}

}
