/*
 * RegionSet.java
 *
 * Created on 2005/06/05, 16:49
 *
 */

package jp.sourceforge.sos.gunmetry.main;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;

import jp.sourceforge.sos.gunmetry.marker.MarkerSet;
import jp.sourceforge.sos.lib.image.ImageInfo;

/**
 * @author Scientific Open Source Project (Gaku Tanaka)
 */
public class RegionSet {
	/**
	 * @uml.property name="regions"
	 * @uml.associationEnd multiplicity="(0 -1)"
	 */
	private Region[]	regions;

	private int[]		contour;

	private Point[]		contourPoints;

	private String		name;

	/** Creates a new instance of RegionSet */
	public RegionSet(String name) {
		this.name = name;
	}

	public String toString() {
		return name;
	}

	public void clear() {
		regions = null;
		contour = null;
		contourPoints = null;
	}

	public int size() {
		return (regions==null) ? 0:regions.length;
	}

	public Point2D.Double getCentroid(int index) {
		return regions[index].getCentroid();
	}

	public void initMinDistance() {
		for (int i = 0; i<regions.length; i++) {
			setMinDistance(i, Integer.MAX_VALUE);
		}
	}

	public int getMinDistance(int index) {
		return regions[index].getMinDistance();
	}

	public void setMinDistance(int index, int value) {
		regions[index].setMinDistance(value);
	}

	public Region getNearestNeighbor(int index) {
		return regions[index].getNearestNeighbor();
	}

	public void setNearestNeighbor(int index, int indexNeighbor) {
		Region neighbor = regions[indexNeighbor];
		regions[index].setNearestNeighbor(neighbor);
	}

	public Region[] getRegion() {
		return regions;
	}

	public void setRegion(MarkerSet markers, ImageInfo imi, int backgroundIndex) {
		int FIRST_LABEL = backgroundIndex+1;

		regions = new Region[markers.size()];
		for (int i = 0; i<regions.length; i++) {
			regions[i] = new Region();
		}

		// makeRegions(imi, markers, FIRST_LABEL);
		addPoints(imi, FIRST_LABEL);
		setRegionUnmask(imi, FIRST_LABEL);
		removeZerosizedRegion();
	}

	/**
	 * @param imi
	 * @param FIRST_LABEL
	 */
	private void addPoints(ImageInfo imi, int FIRST_LABEL) {
		int offset;
		int index;
		for (int y = 0; y<imi.getHeight(); y++) {
			offset = y*imi.getWidth();
			for (int x = 0; x<imi.getWidth(); x++) {
				index = imi.getPixelsLabel(x+offset)-FIRST_LABEL;
				if (0<=index) {
					regions[index].expandRegion(x, y);
				}
			}
		}
	}

	/**
	 * 
	 */
	private void removeZerosizedRegion() {
		ArrayList<Region> regionList = new ArrayList<Region>();
		for (int i = 0; i<regions.length; i++) {
			if (0<regions[i].getSize()) {
				regionList.add(regions[i]);
			}
		}
		regions = regionList.toArray(new Region[0]);
	}

	/**
	 * @param imi
	 * @param FIRST_LABEL
	 */
	private void setRegionUnmask(ImageInfo imi, int FIRST_LABEL) {
		int offset;
		for (int n = 0; n<regions.length; n++) {
			regions[n].initUnmask();
			Rectangle bounds = regions[n].getBounds();
			if (bounds!=null) {
				for (int y = 0; y<bounds.height; y++) {
					offset = bounds.x+ (y+bounds.y)*imi.getWidth();
					for (int x = 0; x<bounds.width; x++) {
						if (imi.getPixelsLabel(x+offset)-FIRST_LABEL==n) {
							regions[n].setUnmask(x, y);
						}
					}
				}
			}
		}
	}

	public int[] getContour() {
		return contour;
	}

	public void setContour(int[] contour) {
		this.contour = contour;
	}

	public Point[] getContourPoints() {
		return contourPoints;
	}

	public void setContourPoints(Point[] contourPoints) {
		this.contourPoints = contourPoints;
	}

}
