package jp.sourceforge.sos.gunmetry.main;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.HeadlessException;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;

@SuppressWarnings("serial")
public class ViewDialogResult extends JDialog implements IPresentation {

	private JPanel		jContentPane	= null;

	private JScrollPane	jScrollPane		= null;

	private JTable		jTableAnalysis	= null;

	private JButton		jButtonOK		= null;

	private JButton		jButtonCancel	= null;

	protected ModelMain	model;

	private JPanel		jPanel			= null;

	public ViewDialogResult(Frame owner) throws HeadlessException {
		super(owner);
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this.setTitle("RESULT");
		this.setContentPane(getJContentPane());
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane==null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJScrollPane(), java.awt.BorderLayout.CENTER);
			jContentPane.add(getJPanel(), java.awt.BorderLayout.SOUTH);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jScrollPane
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane==null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setPreferredSize(new java.awt.Dimension(250, 200));
			jScrollPane.setViewportView(getJTableAnalysis());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jTable
	 * 
	 * @return javax.swing.JTable
	 */
	private JTable getJTableAnalysis() {
		if (jTableAnalysis==null) {
			jTableAnalysis = new JTable();
			jTableAnalysis.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_NEXT_COLUMN);
		}
		return jTableAnalysis;
	}

	/**
	 * This method initializes jButtonOK
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButtonOK() {
		if (jButtonOK==null) {
			jButtonOK = new JButton();
			jButtonOK.setText("OK");
			jButtonOK.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					model.saveResult();
					setVisible(false);
				}
			});
		}
		return jButtonOK;
	}

	/**
	 * This method initializes jButtonCancel
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButtonCancel() {
		if (jButtonCancel==null) {
			jButtonCancel = new JButton();
			jButtonCancel.setText("CANCEL");
			jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					setVisible(false);
				}
			});
		}
		return jButtonCancel;
	}

	public void setAbstraction(IAbstraction abstraction) {
		model = (ModelMain)abstraction;
		jTableAnalysis.setModel(model.getTableModel());
		DefaultTableColumnModel columnModel = (DefaultTableColumnModel)jTableAnalysis.getColumnModel();
		columnModel.getColumn(0).setPreferredWidth(200);
		pack();
	}

	/**
	 * This method initializes jPanel
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel() {
		if (jPanel==null) {
			jPanel = new JPanel();
			jPanel.add(getJButtonOK(), null);
			jPanel.add(getJButtonCancel(), null);
		}
		return jPanel;
	}

} // @jve:decl-index=0:visual-constraint="212,10"
