package jp.sourceforge.sos.gunmetry.main;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;

@SuppressWarnings("serial")
public class ViewPanel extends JPanel implements IPresentation {

	private JLabel				jLabel			= null;

	private JSlider				jSliderAlpha	= null;

	private ModelMain			model;

	public ViewPanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints1.gridx = 1;
		gridBagConstraints1.gridy = 0;
		gridBagConstraints1.weightx = 1.0;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridx = 0;
		this.setLayout(new GridBagLayout());
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Result image", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(51,51,51)));
		this.add(getJLabel(), gridBagConstraints);
		this.add(getJSliderAlpha(), gridBagConstraints1);
	}

	public void setAbstraction(IAbstraction abstraction) {
		model = (ModelMain)abstraction;
	}

	/**
	 * This method initializes jLabel
	 * 
	 * @return javax.swing.JLabel
	 */
	private JLabel getJLabel() {
		if (jLabel==null) {
			jLabel = new JLabel();
			jLabel.setText("alpha:");
		}
		return jLabel;
	}

	/**
	 * This method initializes jSlider
	 * 
	 * @return javax.swing.JSlider
	 */
	private JSlider getJSliderAlpha() {
		if (jSliderAlpha==null) {
			jSliderAlpha = new JSlider();
			jSliderAlpha.setPreferredSize(new java.awt.Dimension(100, 24));
			jSliderAlpha.setMinorTickSpacing(10);
			jSliderAlpha.setPaintTicks(true);
			jSliderAlpha.setMajorTickSpacing(50);
			jSliderAlpha.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent e) {
					float value = jSliderAlpha.getValue()/100F;
					model.setAlpha(value);
				}
			});
		}
		return jSliderAlpha;
	}

}
