package jp.sourceforge.sos.gunmetry.marker;

import java.awt.GridBagConstraints;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import jp.sourceforge.sos.framework.AbstractPACControl;
import jp.sourceforge.sos.gunmetry.common.AbstractGunmetryControl;

public class ControlMarker extends AbstractGunmetryControl {

	public ControlMarker(AbstractPACControl parent) {
		super(parent);
	}

	@Override
	protected void setPresentations() {
		set(MainContainers.jPanelMain, new ViewPanel(),0);
		//linkToTopView(MainContainers.jLayeredCanvas, ((ModelMarker)model).getCanvas(),0);

		setButton("/jp/sourceforge/sos/gunmetry/resources/opBtn1.gif",((ModelMarker)model).getObject(),0);
		setButton("/jp/sourceforge/sos/gunmetry/resources/opBtn2.gif",((ModelMarker)model).getBackground(),1);
		
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
		set(MainContainers.jPanelOperation, new ViewButtonAnalysis(), gridBagConstraints);
		
		ViewMenu menu = new ViewMenu();
		set(MainContainers.jMenuBarMain, menu, 1);
		new DecoratorLoad(menu);
		new DecoratorPostAnalysis(menu);
		
		new Pref(model);
	}

	/**
	 * 
	 */
	private void setButton(String path, MarkerSet marker, int x) {
		Icon iconBackground = new ImageIcon(getClass().getResource(path));
		ViewButton bt = new ViewButton(model,marker);
		bt.setIcon(iconBackground);
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridx = x;
		linkToTopView(MainContainers.jPanelOperation, bt, gridBagConstraints);
	}

}
