package jp.sourceforge.sos.gunmetry.marker;

import java.awt.BorderLayout;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import jp.sourceforge.sos.gunmetry.common.ExtractMarkerPlugin;
import jp.sourceforge.sos.gunmetry.common.JDialogColorPicker;
import jp.sourceforge.sos.lib.io.Extension;
import jp.sourceforge.sos.lib.io.PluginClassLoader;
import jp.sourceforge.sos.lib.morphology.connection.Neighbor;
import jp.sourceforge.sos.lib.morphology.connection.NeighborSimple;
import jp.sourceforge.sos.lib.morphology.data.DataBinary;
import jp.sourceforge.sos.lib.morphology.data.Elements;

@SuppressWarnings("serial")
public class MarkerColorPicker extends JDialogColorPicker {

	static private final String	pathExtractMarker	= "plugins/extractMarker";

	private JPanel				jPanelObject		= null;  //  @jve:decl-index=0:visual-constraint="19,194"

	private JPanel				jPanelObjAlgorithm	= null;

	private JLabel				jLabel				= null;

	private JComboBox			jComboObj			= null;

	private JPanel				jPanelBackground	= null;  //  @jve:decl-index=0:visual-constraint="18,263"

	private JPanel				jPanelBackAlgorithm	= null;

	private JLabel				jLabel1				= null;

	private JComboBox			jComboBack			= null;

	public MarkerColorPicker(){
		super();
		initialize();
		
		getJContentPane().add(getJPanelObject(), 1);
		getJContentPane().add(getJPanelBackground(), 2);

		loadExtractMarkerPlugin();
		
		pack();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this.setTitle("Set MarkerSet");
	}

	/**
	 * This method initializes jPanel1
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelObject() {
		if (jPanelObject==null) {
			jPanelObject = new JPanel();
			jPanelObject.setLayout(new BorderLayout());
			jPanelObject.setBorder(new TitledBorder("Object"));
			jPanelObject.add(getJPanelObjAlgorithm(), java.awt.BorderLayout.NORTH);
		}
		return jPanelObject;
	}

	/**
	 * This method initializes jPanel2
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelObjAlgorithm() {
		if (jPanelObjAlgorithm==null) {
			jLabel = new JLabel();
			jLabel.setText("algorithm: ");
			jPanelObjAlgorithm = new JPanel();
			jPanelObjAlgorithm.add(jLabel, jLabel.getName());
			jPanelObjAlgorithm.add(getJComboObj(), getJComboObj().getName());
		}
		return jPanelObjAlgorithm;
	}

	/**
	 * This method initializes jComboBox
	 * 
	 * @return javax.swing.JComboBox
	 */
	private JComboBox getJComboObj() {
		if (jComboObj==null) {
			jComboObj = new JComboBox();
			jComboObj.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					setOption(jPanelObject, (ExtractMarkerPlugin)jComboObj.getSelectedItem());
				}
			});
		}
		return jComboObj;
	}

	/**
	 * This method initializes jPanel3
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelBackground() {
		if (jPanelBackground==null) {
			jPanelBackground = new JPanel();
			jPanelBackground.setLayout(new BorderLayout());
			jPanelBackground.setBorder(new TitledBorder("Background"));
			jPanelBackground.add(getJPanelBackAlgorithm(), java.awt.BorderLayout.NORTH);
		}
		return jPanelBackground;
	}

	/**
	 * This method initializes jPanel4
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelBackAlgorithm() {
		if (jPanelBackAlgorithm==null) {
			jLabel1 = new JLabel();
			jLabel1.setText("algorithm: ");
			jPanelBackAlgorithm = new JPanel();
			jPanelBackAlgorithm.add(jLabel1, jLabel1.getName());
			jPanelBackAlgorithm.add(getJComboBack(), getJComboBack().getName());
		}
		return jPanelBackAlgorithm;
	}

	/**
	 * This method initializes jComboBox1
	 * 
	 * @return javax.swing.JComboBox
	 */
	private JComboBox getJComboBack() {
		if (jComboBack==null) {
			jComboBack = new JComboBox();
			jComboBack.addItemListener(new java.awt.event.ItemListener() {
				public void itemStateChanged(java.awt.event.ItemEvent e) {
					setOption(jPanelBackground, (ExtractMarkerPlugin)jComboBack.getSelectedItem());
				}
			});
		}
		return jComboBack;
	}

	private void loadExtractMarkerPlugin() {
		File file = new File(pathExtractMarker);
		File[] fileList = file.listFiles();
		if (fileList!=null) {
			PluginClassLoader loader = new PluginClassLoader(pathExtractMarker);
			for (int i = 0; i<fileList.length; i++) {
				String algorithmName = Extension.remove(fileList[i].getName());
				jComboObj.addItem(getPlugin(loader, algorithmName));
				jComboBack.addItem(getPlugin(loader, algorithmName));
			}
			jComboObj.setSelectedIndex(1);
			jComboBack.setSelectedIndex(1);
		}
	}

	private ExtractMarkerPlugin getPlugin(PluginClassLoader loader, String algorithmName) {
		ExtractMarkerPlugin plugin = null;
		try {
			plugin = (ExtractMarkerPlugin)loader.loadClass(algorithmName).newInstance();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return plugin;
	}

	/**
	 * @param panel
	 * @param plugin
	 */
	private void setOption(JPanel panel, ExtractMarkerPlugin plugin) {
		if (plugin!=null) {
			JPanel optionPanel = plugin.getOptionPanel();
			removeOldOptionPanel(panel);
			if (optionPanel!=null) {
				panel.add(optionPanel, BorderLayout.CENTER);
			}
			pack();
		}
	}

	/**
	 * @param panel
	 */
	private void removeOldOptionPanel(JPanel panel) {
		if (1<panel.getComponentCount()) {
			panel.remove(1);
		}
	}

	private ArrayList<Point> extractMarker(ExtractMarkerPlugin plugin, Neighbor neighbor, boolean[] binaryMap) {
		return plugin.extractMarker(new Elements(neighbor,new DataBinary(binaryMap)));
	}

	public ArrayList<Point> extractMarkerObj(int w, int h, boolean[] binaryMap) {
		ExtractMarkerPlugin plugin = (ExtractMarkerPlugin)jComboObj.getSelectedItem();
		return extractMarker(plugin, new NeighborSimple(w, h), binaryMap);
	}

	public ArrayList<Point> extractMarkerBack(int w, int h, boolean[] binaryMap) {
		ExtractMarkerPlugin plugin = (ExtractMarkerPlugin)jComboBack.getSelectedItem();
		return extractMarker(plugin, new NeighborSimple(w, h), binaryMap);
	}
}
