package jp.sourceforge.sos.gunmetry.marker;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.graphics.IGraphics;
import jp.sourceforge.sos.lib.graphics.PointRect;


/**
 * @author  Gaku Tanaka
 */
@SuppressWarnings("serial")
public class MarkerSet implements IGraphics{
	private ArrayList<Point> pointList = new ArrayList<Point>();
	private PointRect pointRect;
	private HashSet<Point> selectedMarker = new HashSet<Point>();
	private boolean visible = true;
	private ColorModel colorModel = new ColorModel();
	
	private String name;
	
	/** Creates a new instance of MarkerSet */
	public MarkerSet() {
	}
	
	public MarkerSet(String string) {
		name = string;
	}

	public String toString(){
		if (name==null){
			return super.toString();
		}
		return name;
	}
	
	public void draw(java.awt.Graphics g) {
		if (visible){
			drawSelected(g);
			drawPoints(g);
		}
	}

	/**
	 * @param g
	 */
	private void drawPoints(java.awt.Graphics g) {
		if (0<pointList.size()){
			g.setColor(getColor());
			for (int i=0; i<pointList.size(); i++){
				Point p = pointList.get(i);
				pointRect.setLocation(p.x,p.y);
				pointRect.draw(g);
			}
		}
	}

	/**
	 * @param g
	 */
	private void drawSelected(java.awt.Graphics g) {
		pointRect.setFillRect(true);
		if (0<selectedMarker.size()){
			g.setColor(Color.white);
			for (Point p: selectedMarker){
				pointRect.setLocation(p.x, p.y);
				pointRect.draw(g);
			}
		}
		pointRect.setFillRect(false);
	}
	
	public void setAll(ArrayList<Point> points){
		pointList.clear();
		pointList.addAll(points);
	}
	
	/**
	 * @param visible  The visible to set.
	 * @uml.property  name="visible"
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}
	
	/**
	 * @param color  The color to set.
	 * @uml.property  name="color"
	 */
	public void setColor(Color color) {
		colorModel.setColor(color);
	}
	
	/**
	 * @param pointRect  The pointRect to set.
	 * @uml.property  name="pointRect"
	 */
	public void setPointRect(PointRect pointRect){
		this.pointRect = pointRect;
	}
	
	public Point get(Point2D point){
		for (int i=0; i<pointList.size(); i++){
			Point p = pointList.get(i);
			pointRect.setLocation(p.x,p.y);
			if (pointRect.contains(point)){
				return p;
			}
		}
		return null;
	}
	
	public void add(String strPoint, double ratioX, double ratioY){
		String[] location = strPoint.split(",");
		int x = (int)(Integer.valueOf(location[0])*ratioX);
		int y = (int)(Integer.valueOf(location[1])*ratioY);
		Point p = new Point(x,y);
		pointList.add(p);
	}
	
	public void select(Shape shape){
		Rectangle rect = shape.getBounds();
		for (int i=0; i<pointList.size(); i++){
			Point p = pointList.get(i);
			if (rect.contains(p)){
				selectedMarker.add(p);
			}
		}
	}
	
	public void select(Point p){
		int index = pointList.indexOf(p);
		if (-1<index){
			selectedMarker.add(pointList.get(index));
		}
	}
	
	public void clearSelection(){
		selectedMarker.clear();
	}
	
	public void removeSelected(){
		pointList.removeAll(selectedMarker);
		clearSelection();
	}
	
	public void translateSelected(int dx, int dy){
		for (Point p: selectedMarker){
			p.translate(dx,dy);
		}
	}

	public boolean add(Point o) {
		return pointList.add(o);
	}

	public void clear() {
		pointList.clear();
	}

	public Point get(int index) {
		return pointList.get(index);
	}

	public Iterator<Point> iterator() {
		return pointList.iterator();
	}

	public Point remove(int index) {
		return pointList.remove(index);
	}

	public boolean remove(Object o) {
		return pointList.remove(o);
	}

	public boolean removeAll(Collection<?> c) {
		return pointList.removeAll(c);
	}

	public int size() {
		return pointList.size();
	}

	public ColorModel getColorModel() {
		return colorModel;
	}

	public Color getColor() {
		return colorModel.getColor();
	}

	public void addAll(Collection<Point> points) {
		pointList.addAll(points);
	}

}
