package jp.sourceforge.sos.gunmetry.marker;

import java.awt.Point;
import java.util.ArrayList;

public class Memento {

	private ArrayList<Point> pointsObject = new ArrayList<Point>();
	private ArrayList<Point> pointsBackground = new ArrayList<Point>();

	public Memento(MarkerSet object, MarkerSet background) {
		takeSnapshot(object, pointsObject);
		takeSnapshot(background, pointsBackground);
	}

	private void takeSnapshot(MarkerSet markers, ArrayList<Point> points) {
		for (int i=0; i<markers.size(); i++){
			Point p = markers.get(i);
			points.add(new Point(p.x, p.y));
		}
	}

	public void restore(MarkerSet object, MarkerSet background) {
		revertFromSnapshot(object, pointsObject);
		revertFromSnapshot(background, pointsBackground);
	}

	private void revertFromSnapshot(MarkerSet markers, ArrayList<Point> points) {
		markers.clear();
		markers.addAll(points);
	}

}
