package jp.sourceforge.sos.gunmetry.marker;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.gunmetry.common.AbstractPref;

class Pref extends AbstractPref{
	
	MarkerSet object;
	MarkerSet background;
	
	Pref(IAbstraction model) {
		super(model);	
	}
	
	@Override
	protected void setModel(IAbstraction model) {
		ModelMarker modelMarker = (ModelMarker)model;
		object = modelMarker.getObject();
		background = modelMarker.getBackground();
	}
	
	@Override
	protected void init() {
		init(object);
		init(background);
	}		
	
	private void init(MarkerSet set){
		set.setColor(getColor(set.toString(),set.getColor()));
	}
	
	public void update(Boolean obj) {
		prefs.putInt(object.toString(), object.getColor().getRGB());
		prefs.putInt(background.toString(), background.getColor().getRGB());
	}

}
