package jp.sourceforge.sos.gunmetry.marker;

import javax.swing.JMenu;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IPresentation;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

@SuppressWarnings("serial")
public class ViewMenu extends JMenu implements IPresentation{

	private ModelMarker modelMarker;
	JMenuItem jMenuItemOpen = null;
	JMenuItem jMenuItemSave = null;
	JMenuItem jMenuItemUndo = null;
	private JSeparator jSeparator = null;
	
	public ViewMenu() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setText("Marker");
        this.add(getJMenuItemOpen());
        this.add(getJMenuItem());
        this.add(getJSeparator());
        this.add(getJMenuItem2());
			
	}

	public void setAbstraction(IAbstraction abstraction) {
		modelMarker = (ModelMarker)abstraction;
	}

	/**
	 * This method initializes jMenuItemOpen	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItemOpen() {
		if (jMenuItemOpen==null) {
			jMenuItemOpen = new JMenuItem();
			jMenuItemOpen.setText("Open file...");
			jMenuItemOpen.setEnabled(false);
			jMenuItemOpen.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
	        		modelMarker.openMarker();
				}
			});
		}
		return jMenuItemOpen;
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItem() {
		if (jMenuItemSave==null) {
			jMenuItemSave = new JMenuItem();
			jMenuItemSave.setText("Save file...");
			jMenuItemSave.setEnabled(false);
			jMenuItemSave.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
	        		modelMarker.saveMarkers();
				}
			});
		}
		return jMenuItemSave;
	}

	/**
	 * This method initializes jSeparator	
	 * 	
	 * @return javax.swing.JSeparator	
	 */
	private JSeparator getJSeparator() {
		if (jSeparator==null) {
			jSeparator = new JSeparator();
		}
		return jSeparator;
	}

	/**
	 * This method initializes jMenuItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getJMenuItem2() {
		if (jMenuItemUndo==null) {
			jMenuItemUndo = new JMenuItem();
			jMenuItemUndo.setText("Undo");
			jMenuItemUndo.setEnabled(false);
			jMenuItemUndo.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
	        		modelMarker.restoreMemento();
	        	}
			});
		}
		return jMenuItemUndo;
	}

}
