package jp.sourceforge.sos.gunmetry.mask;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;

import jp.sourceforge.sos.framework.IAbstraction;
import jp.sourceforge.sos.framework.IModel;
import jp.sourceforge.sos.gunmetry.common.JDialogColorPicker;
import jp.sourceforge.sos.gunmetry.main.ViewFrameMain;
import jp.sourceforge.sos.gunmetry.marker.ModelMarker;
import jp.sourceforge.sos.lib.canvas.IGraphicsContainer;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.graphics.GraphicsImage;
import jp.sourceforge.sos.lib.image.ImageInfo;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.morphology.connection.Neighbor;
import jp.sourceforge.sos.lib.morphology.connection.NeighborMasked;
import jp.sourceforge.sos.lib.morphology.connection.NeighborSimple;
import jp.sourceforge.sos.lib.util.SOSArrays;

public class ModelMask implements IModel {

	static private final int[]		COLOR_TRANSPARENT	= { 0, 0, 0, 0 };

	private ModelMarker				modelMarker;

	private boolean[]				analyzeMask;

	private SOSImageIO				imageFileIO			= new SOSImageIO();

	private ColorModel				colorModel			= new ColorModel();

	private JDialogColorPicker	colorPicker			= new JDialogColorPicker();

	private JObjectCanvas			canvas;

	private GraphicsImage			graphicsImage;

	private BufferedImage			img;

	public ModelMask() {}

	boolean createMask() {
		analyzeMask = null;
		
		imageFileIO.resetChoosableFileFilters();
		imageFileIO.setFileFilter(ViewFrameMain.filterGifPng);
		File fileMask = imageFileIO.getOpenFile("Select a GIF file for mask...");
		if (fileMask==null) {
			return false;
		}

		BufferedImage img = SOSImageIO.readImage(fileMask);
		ImageInfo imiMask = new ImageInfo(img);
		colorPicker.setColorTable(imiMask.getPixels(), imiMask.getPixelsLabel());

		// after dialog operation
		analyzeMask = SOSArrays.toBoolean(colorPicker.getFlag(), imiMask.getPixelsLabel());
		if (analyzeMask==null){
			return false;
		}
		createMaskImage();

		return true;
	}

	/**
	 * 
	 */
	void createMaskImage() {
		int[][] result = new int[analyzeMask.length][];

		int[] rgb = colorModel.getColorArray();
		int[] colorMask = new int[4];
		System.arraycopy(rgb, 0, colorMask, 0, 3);
		colorMask[3] = 255;
		for (int i = 0; i<analyzeMask.length; i++) {
			if (analyzeMask[i]) {
				result[i] = colorMask;
			} else {
				result[i] = COLOR_TRANSPARENT;
			}
		}
		img = ImagePixelMediator.toAlphaImage(result, modelMarker.getImageWidth(), modelMarker.getImageHeight());
		graphicsImage.setImage(img);
	}

	void setMask(boolean setMask) {

		ImageInfo imageInfo = modelMarker.getImageInfo();
		Neighbor neighbor = null;
		if (setMask) {
			if (analyzeMask==null) {
				createMask();
			}
			graphicsImage.setImage(img);
			
			neighbor = new NeighborMasked(imageInfo.getWidth(), imageInfo.getHeight());
			neighbor.setMask(analyzeMask);
		} else {
			graphicsImage.setImage(null);
			
			neighbor = new NeighborSimple(imageInfo.getWidth(), imageInfo.getHeight());
		}

		imageInfo.setNeighbor(neighbor);
		repaint();
	}

	void repaint() {
		canvas.repaint();
	}

	ColorModel getColorModel() {
		return colorModel;
	}

	public void setAbstraction(IAbstraction abstraction) {
		modelMarker = (ModelMarker)abstraction;

		canvas = modelMarker.getCanvas();
		graphicsImage = new GraphicsImage();
		canvas.addGraphicObject(2, graphicsImage);
	}

	IGraphicsContainer getCanvas() {
		return canvas;
	}

	Color getColor() {
		return colorModel.getColor();
	}

	void setColor(Color color) {
		colorModel.setColor(color);
	}

}
