<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * ƥ饹
 *
 * @since 1.0.0
 * @author saitoh-y
 */
class deleteCategoryAction extends ActionAbstract {

    /**
     * ƥꥹ
     *
     * @access private
     * @var Array
     */
    private $categoryList = array();
	
    /**
     * ƥμ¹ԥ᥽å
     *
     */
    function execute() {
        $root =& XCube_Root::getSingleton();
        $acl =& new Acl();

        /* 桼å */
        if (!$acl->isAdmin()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        $category = new Category();

        /* ͼ */
        $categoryCd = $root->mContext->mRequest->getRequest('category_cd');

        /* ͥå */
        $validate =& new validateDeleteCategoryFormAction();
        $validate->prepare();
        $validate->fetch();
        $validate->validate();
        if ($validate->hasError()) {
            $this->errFg = true;
            $this->actionForm = $validate;
            /* ƥꥹȤμ */
            $this->categoryList = $category->getAllList();
            return;
        }

        /* ƥ򥻥å */
        $category->setDataList($categoryCd, 'category_cd', _SB_MODULE_DB_SET_INTEGER, true);

        /* ƥ */
        if (!$category->delete()) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_FAILE_DELETE;
        }
    }

    /**
     * ƥ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $root->mController->executeRedirect(_SB_MODULE_URL . "admin/index.php?action=viewCategory",
            _SB_MODULE_REDIRECT_TIME, _MD_SB_SUCCESS_DELETE);
    }

    /**
     * ͥ顼ɽ
     *
     */
    function errorView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();

        $render->setTemplateName(_SB_MODULE_PATH . 'templates/admin_viewCategory.html');
        $render->setAttribute('moduleName', $root->mContext->mModule->mXoopsModule->getVar('name'));
        $render->setAttribute('categoryList', $this->categoryList);
        $render->setAttribute('actionForm', $this->actionForm);
    }
}
?>