<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/actions/ActionAbstract.php";

/**
 * Խɽ饹
 *
 * @since 0.0.4
 * @author saitoh-y
 */
class editGameAction extends ActionAbstract {

    /**
     * 
     *
     * @access private
     * @var Array
     */
    private $detailGame = array();
    
    /**
     * ƥꥹ
     *
     * @access private
     * @var Array
     */
    private $categoryList = array();

    /**
     * Խɽμ¹ԥ᥽å
     *
     */
    function execute() {
        /* 󥹥󥹤 */
        $game =& new Game();
        $acl =& new Acl();

        /* ͼ */
        $root =& XCube_Root::getSingleton();
        $gameCd = $root->mContext->mRequest->getRequest('game_cd');

        /* ̾μ */
        $game->setGameCd($gameCd);
        $gameResult = $game->getGame();

        /* 桼å */
        $acl->setTeamCd($gameResult['top_team_cd']);
        $topEditFg = $acl->isEditGame();
        $acl->setTeamCd($gameResult['bottom_team_cd']);
        $bottomEditFg = $acl->isEditGame();
        $editFg = false;
        if ($topEditFg || $bottomEditFg) {
            $editFg = true;
        }
        if (!$editFg) {
            $this->errFg = true;
            $this->errMsg = _MD_SB_NOACCSESS;
            return;
        }

        setGameScore($gameResult);
        $this->detailGame = $gameResult;
        for ($i = 1; $i <= _SB_MODULE_MAXINING; $i++) {
            $this->detailGame['topList'][$i] = $gameResult['top_' . $i];
            $this->detailGame['bottomList'][$i] = $gameResult['bottom_' . $i];
        }

        /* ꥹȤμ */
        $team =& new Team();
        $this->teamList = $team->getAllList();

        $teamList = array_set_key($this->teamList, 'team_cd');

        /* ̾åܥå */
        if (empty($teamList[$this->detailGame['top_team_cd']]) || $teamList[$this->detailGame[
            'top_team_cd']]['team_name'] != $this->detailGame['top_team_name']) {
            $this->detailGame['top_team_select_check'] = true;
        }
        else {
            $this->detailGame['top_team_select_check'] = false;
        }

        if (empty($teamList[$this->detailGame['bottom_team_cd']]) || $teamList[$this->detailGame[
            'bottom_team_cd']]['team_name'] != $this->detailGame['bottom_team_name']) {
            $this->detailGame['bottom_team_select_check'] = true;
        }
        else {
            $this->detailGame['bottom_team_select_check'] = false;
        }
        
        /* ƥꥹȤμ */
        $category =& new Category();
        $category->setCategoryCd($this->detailGame['category_cd']);
        $this->categoryList = $category->getListWithoutDelfgOrCategoryCd();
    }

    /**
     * Խ̤ɽ
     *
     */
    function executeView() {
        $root =& XCube_Root::getSingleton();
        $render =& $root->mContext->mModule->getRenderTarget();
        $actionForm =& new validateUpdateGameFormAction();

        $render->setTemplateName('sb_edit_game.html');
        $render->setAttribute('action', 'updateGame');
        $render->setAttribute('detailGame', $this->detailGame);
        $render->setAttribute('teamList', $this->teamList);
        $render->setAttribute('categoryList', $this->categoryList);
        $render->setAttribute('actionForm', $actionForm);

        $render->setAttribute('title', _MD_SB_TITLE_EDIT_GAME);
    }
}
?>