<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once XOOPS_MODULE_PATH . '/legacy/kernel/Legacy_ActionForm.class.php';
require_once XOOPS_MODULE_PATH . '/legacy/class/Legacy_Validator.class.php';

/**
 * (Ǽ)󹹿ͥå饹
 *
 * @since 0.0.1
 * @author saitoh-y
 */
class validateRegiPlayerResultHitterFormAction extends Legacy_ActionForm {

    /**
     * 󥹥ȥ饯
     *
     * @return object validateRegiPlayerResultHitterFormAction
     */
    function validateRegiPlayerResultHitterFormAction() {
        parent::Legacy_ActionForm();
    }

    /**
     * ȡ̾
     *
     * @return String
     */
    function getTokenName() {
        return 'modules.' . _SB_DIRNAME . '.regiPlayerResultHitterForm.TOKEN';
    }

    /**
     * ͥå¹ԥ᥽å
     *
     */
    function prepare() {
        /* ǡϥåϿ */
        $this->mFormProperties['batting_order'] =& new XCube_StringArrayProperty('batting_order');
        $this->mFormProperties['game_position'] =& new XCube_StringArrayProperty('game_position');
    }

    /**
     * ǽΥå
     *
     */
    function validateBatting_order() {
        $dataList = $this->get('batting_order');
        /* ͥå */
        if (!$this->isNumeric_batting_order()) {
            $this->addErrorMessage(_MD_SB_COLUMN_PALYER_RESULT_BATTING_ORDER
                . _MD_SB_CHECK_NUMERIC);

        }

        /* ˡå */
        if (!$this->isUnique_batting_order()) {
            $this->addErrorMessage(_MD_SB_COLUMN_PALYER_RESULT_BATTING_ORDER
                . _MD_SB_CHECK_UNIQUE);
        }

    }

    /**
     * ǽοͥå
     *
     * @return boolean
     */
    private function isNumeric_batting_order() {
        $dataList = $this->get('batting_order');
        /* ǽ礬ϤƤǽοͥåԤ */
        foreach ($dataList as $data) {
            if (!empty($data) && !is_numeric($data)) {
                return false;

            }
        }
        return true;
    }

    /**
     * ǽΥˡå
     *
     * @return boolean
     */
    private function isUnique_batting_order() {
        $dataList = $this->get('batting_order');
        $comparList = array();
        foreach ($dataList as $data) {
            if (array_intersect(array($data), $comparList) && !empty($data)) {
                return false;
            }
            $comparList[] = $data;
        }
        return true;
    }

    /**
     * ݥΥå
     *
     */
    function validateGame_position() {
        $orderList = $this->get('batting_order');
        $positionList = $this->get('game_position');
        /* ǽ礬ϤƤ˳ƥåԤ */

        /* NULLå */
        if (!$this->isNotNull_game_position()) {
            $this->addErrorMessage(_MD_SB_COLUMN_PALYER_RESULT_BATTING_POSITION
                . _MD_SB_CHECK_NULL);
        }

        /* å */
        if (!$this->isMatch_game_position()) {
            $this->addErrorMessage(_MD_SB_COLUMN_PALYER_RESULT_BATTING_POSITION
                . _MD_SB_CHECK_BADDATA);
        }
    }

    /**
     * ǽNULLå
     *
     * @return boolean
     */
    private function isNotNull_game_position() {
        $orderList = $this->get('batting_order');
        $positionList = $this->get('game_position');
        /* ǽ礬ϤƤ˥åԤ */
        for ($i = 0; $i < count($orderList); $i++) {
            if (!empty($orderList[$i]) && empty($positionList[$i])) {
                return false;
            }
        }
        return true;
    }

    /**
     * ǽηå
     *
     * @return boolean
     */
    private function isMatch_game_position() {
        $orderList = $this->get('batting_order');
        $positionList = $this->get('game_position');
        /* ǽ礬ϤƤ˥åԤ */
        for ($i = 0; $i < count($orderList); $i++) {
            if (!empty($orderList[$i]) && !empty($positionList[$i])) {
                $positionArr = explode(",", $positionList[$i]);
                foreach ($positionArr as $position) {
                    if ((!is_numeric($position) || strlen($position) != 1) && $position !=
                        _SB_MODULE_VALI_MATCH_PINCHHITTER && $position !=
                        _SB_MODULE_VALI_MATCH_PINCHRUNNER && $position !=
                        _SB_MODULE_VALI_MATCH_DESIGNATED_HITTER) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

}
?>