<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once XOOPS_MODULE_PATH . '/legacy/kernel/Legacy_ActionForm.class.php';
require_once XOOPS_MODULE_PATH . '/legacy/class/Legacy_Validator.class.php';

/**
 * (Ǽ)󹹿ͥå饹
 *
 * @since 0.0.1
 * @author saitoh-y
 */
class validateRegiPlayerResultPitcherFormAction extends Legacy_ActionForm {

    /**
     * 󥹥ȥ饯
     *
     * @return object validateRegiPlayerResultPitcherFormAction
     */
    function validateRegiPlayerResultPitcherFormAction() {
        parent::Legacy_ActionForm();
    }

    /**
     * ȡ̾
     *
     * @return String
     */
    function getTokenName() {
        return 'modules.' . _SB_DIRNAME . '.regiPlayerResultPitcherForm.TOKEN';
    }

    /**
     * ͥå¹ԥ᥽å
     *
     */
    function prepare() {
        /* ǡϥåϿ */
        $this->mFormProperties['pitcher_order'] =& new XCube_StringArrayProperty('pitcher_order');
    }

    /**
     * Υå
     *
     */
    function validatePitcher_order() {
        /* ͥå */
        if (!$this->isNumeric_pitcher_order()) {
            $this->addErrorMessage(_MD_SB_COLUMN_PALYER_RESULT_PITCHER_ORDER
                . _MD_SB_CHECK_NUMERIC);
        }

        /* ˡå */
        if (!$this->isUnique_pitcher_order()) {
            $this->addErrorMessage(_MD_SB_COLUMN_PALYER_RESULT_PITCHER_ORDER
                . _MD_SB_CHECK_UNIQUE);
        }
    }

    /**
     * ǽοͥå
     *
     * @return boolean
     */
    private function isNumeric_pitcher_order() {
        $dataList = $this->get('pitcher_order');
        /* ǽ礬ϤƤǽοͥåԤ */
        foreach ($dataList as $data) {
            if (!empty($data) && !is_numeric($data)) {
                return false;

            }
        }
        return true;
    }

    /**
     * ǽΥˡå
     *
     * @return boolean
     */
    private function isUnique_pitcher_order() {
        $dataList = $this->get('pitcher_order');
        $comparList = array();
        foreach ($dataList as $data) {
            if (array_intersect(array($data), $comparList) && !empty($data)) {
                return false;
            }
            $comparList[] = $data;
        }
        return true;
    }
}
?>