<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once XOOPS_MODULE_PATH . '/legacy/kernel/Legacy_ActionForm.class.php';
require_once XOOPS_MODULE_PATH . '/legacy/class/Legacy_Validator.class.php';

/**
 * 󹹿ͥå饹
 *
 * @since 0.0.1
 * @author saitoh-y
 */
class validateUpdatePlayerFormAction extends Legacy_ActionForm {
    /**
     * 󥹥ȥ饯
     *
     * @return object validateUpdatePlayerFormAction
     */
    function validateUpdatePlayerFormAction() {
        parent::Legacy_ActionForm();
    }

    /**
     * ȡ̾
     *
     * @return String
     */
    function getTokenName() {
        return 'modules.' . _SB_DIRNAME . '.updatePlayerForm.TOKEN';
    }

    /**
     * ͥå¹ԥ᥽å
     *
     */
    function prepare() {
        /* ǡϥåϿ */
        $this->mFormProperties['player_name'] =& new XCube_StringProperty('player_name');
        $this->mFormProperties['backnum'] =& new XCube_StringProperty('backnum');
        $this->mFormProperties['position'] =& new XCube_StringProperty('position');
        $this->mFormProperties['image_path'] =& new XCube_FileProperty('image_path');

        /* ̾ */
        $this->mFieldProperties['player_name'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['player_name']->setDependsByArray(array('required', 'maxlength'));
        $this->mFieldProperties['player_name']->addVar('maxlength',
            _SB_MODULE_VALI_MAXLENGTH_VARCHAR);
        $this->mFieldProperties['player_name']->addMessage('required', _MD_SB_COLUMN_PLAYER_NAME
            . _MD_SB_CHECK_NULL);
        $this->mFieldProperties['player_name']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_PLAYER_NAME, _SB_MODULE_VALI_MAXLENGTH_VARCHAR);

        /* ֹ */
        $this->mFieldProperties['backnum'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['backnum']->setDependsByArray(array('maxlength'));
        $this->mFieldProperties['backnum']->addVar('maxlength', _SB_MODULE_VALI_MAXLENGTH_BACKNUM);
        $this->mFieldProperties['backnum']->addMessage('maxlength', _MD_SB_CHECK_MAXLENGTH,
            _MD_SB_COLUMN_PLAYER_BACKNUM, _SB_MODULE_VALI_MAXLENGTH_BACKNUM);

        /* ᡼ѥ */
        $this->mFieldProperties['image_path'] =& new XCube_FieldProperty($this);
        $this->mFieldProperties['image_path']->setDependsByArray(array('extension'));
        $this->mFieldProperties['image_path']->addVar('extension', _SB_MODULE_VALI_EXTENTION_IMAGE);
        $this->mFieldProperties['image_path']->addMessage('extension', _MD_SB_CHECK_EXTENTION,
            _MD_SB_COLUMN_IMAGE, _SB_MODULE_VALI_EXTENTION_IMAGE);
    }

    /**
     * ֹοͥå
     *
     */
    function validateBacknum() {
        $backnum = $this->get('backnum');
        if (!empty($backnum) && !is_numeric($backnum)) {
            $this->addErrorMessage(_MD_SB_COLUMN_PLAYER_BACKNUM
                . _MD_SB_CHECK_NUMERIC);
        }
    }
}
?>