<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/database/DatabaseScoreBookClass.php";

/**
 * sb_categoryơ֥륯饹
 *
 * @version 1.0.0
 * @author saitoh-y
 */
class Category extends DatabaseScoreBook {

    /**
     * ƥꥳ
     *
     * @access private
     * @var Integer
     */
    private $categoryCd=0;
    
    /**
     * ƥ̾
     *
     * @access private
     * @var String
     */
    private $categoryName = "";

    /**
     * ƥ
     *
     * @access private
     * @var String
     */
    private $categoryContent = "";

    /**
     * ֹ
     *
     * @access private
     * @var Integer
     */
    private $sort_num = 0;

    /**
     * ƥ֥ե饰
     *
     * @access private
     * @var Integer
     */
    private $act_fg = 0;

    /**
     * sb_categoryơ֥ƤΥ쥳ɤ
     *
     * @return Array
     */
    function getAllList() {
        $sql = "SELECT * FROM " . $this->tableNameCategory . " ORDER BY sort_num ASC";
        return $this->getList($sql);
    }

    /**
     * sb_categoryơ֥Υƥ֥ե饰ΩäƤ쥳ɤ
     *
     * @return Array
     */
    function getListWithoutDelfg() {
        $sql = "SELECT * FROM " . $this->tableNameCategory .
            " WHERE act_fg = 1 ORDER BY sort_num ASC";
        return $this->getList($sql);
    }

    /**
     * sb_categoryơ֥Υƥ֥ե饰ΩäƤ뤫륫ƥꥳɤĥ쥳ɤ
     *
     * @return Array
     */
    function getListWithoutDelfgOrCategoryCd() {
        $sql = "SELECT * FROM " . $this->tableNameCategory . " WHERE (act_fg = 1 OR category_cd = "
            . $this->categoryCd . ") ORDER BY sort_num ASC";
        return $this->getList($sql);
    }

    /**
     * sb_categoryơ֥1쥳ɤꤷƼ
     *
     * @return Array
     */
    function getCategory() {
        $sql = "SELECT * FROM " . $this->tableNameCategory . " WHERE category_cd = " . $this->
            categoryCd;
        $recordList = $this->getList($sql);
        return (!empty($recordList[0])) ? $recordList[0] : array();
    }

    /**
     * դι߽˥쥳ɤ
     *
     */
    function getLastCategory() {
        $sql = "SELECT * FROM " . $this->tableNameCategory . " as category ";
        $sql .= " ORDER BY category.category_date DESC";
        if ($this->limit) {
            $sql .= " LIMIT " . $this->limit;
        }

        return $this->getList($sql);
    }

    /**
     * sb_categoryơ֥ǺΥƥꥳɤ
     *
     * @param String $column ̾
     * @return Integer
     */
    function getMaxValue($column) {
        return parent::getMaxValue($this->tableNameCategory, $column);
    }

    /**
     * sb_categoryơ֥˥쥳ɤɲä
     *
     * @return boolean
     */
    function insert() {
        return parent::insert($this->tableNameCategory);
    }

    /**
     * sb_categoryơ֥Υ쥳ɤ򹹿
     *
     * @return boolean
     */
    function update() {
        return parent::update($this->tableNameCategory);
    }

    /**
     * sb_categoryơ֥Υ쥳ɤ
     *
     * @return boolean
     */
    function delete() {
        return parent::delete($this->tableNameCategory);
    }

    /**
     * 祳ɤΥå
     *
     * @param Integer $categoryCd
     */
    function setCategoryCd($categoryCd) {
        $this->categoryCd = addslashes(intval($categoryCd));
    }
}
?>