<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}

/**
 * ǡ١饹
 *
 * @since 0.0.8
 * @author saitoh-y
 */
class DatabaseScoreBook {
    /**
     * ǡ١֥
     *
     * @access protected
     * @var Object
     */
    protected $db = null;

    /**
     * ơ֥̾
     *
     * @access protected
     * @var String
     */
    protected $tableNameTeam = "";

    /**
     * ӥޥåץơ֥̾
     *
     * @access protected
     * @var String
     */
    protected $tableNameTeamResult = "";

    /**
     * ơ֥̾
     *
     * @access protected
     * @var String
     */
    protected $tableNameGame = "";

    /**
     * ơ֥̾
     *
     * @access protected
     * @var String
     */
    protected $tableNamePlayer = "";

    /**
     * (Ǽ)ơ֥̾
     *
     * @access protected
     * @var String
     */
    protected $tableNamePlayerResultHitter = "";

    /**
     * ()ơ֥̾
     *
     * @access protected
     * @var String
     */
    protected $tableNamePlayerResultPitcher = "";

    /**
     * ơ֥̾
     *
     * @access protected
     * @var String
     */
    protected $tableNameAccess = "";

    /**
     * ơ֥̾
     *
     * @access protected
     * @var String
     */
    protected $tableNameCategory = "";

    /**
     * 롼ץơ֥̾
     *
     * @access protected
     * @var String
     */
    protected $tableNameGroups = "";

    /**
     * Insert/Update/Deleteѥǡꥹ
     *
     * @access protected
     * @var Array
     */
    protected $dataList = array();

    /**
     * 󥹥ȥ饯
     *
     * @return DatabaseScoreBook
     */
    function DatabaseScoreBook() {
        /* XCLDB쥯饹 */
        $root =& XCube_Root::getSingleton();
        $this->db =& $root->mController->mDB;

        /* ơ֥̾ޤȤƥå */
        $this->tableNameTeam = $this->db->prefix(_SB_DIRNAME . _SB_MODULE_DB_NAME_TEAM);
        $this->tableNameTeamResult = $this->db->prefix(_SB_DIRNAME .
            _SB_MODULE_DB_NAME_TEAM_RESULT_MAP);
        $this->tableNameGame = $this->db->prefix(_SB_DIRNAME . _SB_MODULE_DB_NAME_GAME);
        $this->tableNamePlayer = $this->db->prefix(_SB_DIRNAME . _SB_MODULE_DB_NAME_PLAYER);
        $this->tableNamePlayerResultHitter = $this->db->prefix(_SB_DIRNAME .
            _SB_MODULE_DB_NAME_PLAYER_RESULT_HITTER);
        $this->tableNamePlayerResultPitcher = $this->db->prefix(_SB_DIRNAME .
            _SB_MODULE_DB_NAME_PLAYER_RESULT_PITCHER);
        $this->tableNameAccess = $this->db->prefix(_SB_DIRNAME . _SB_MODULE_DB_NAME_ACCESS);
        $this->tableNameCategory = $this->db->prefix(_SB_DIRNAME . _SB_MODULE_DB_NAME_CATEGORY);
        $this->tableNameGroups = $this->db->prefix("groups");
    }

    /**
     * 
     *
     * @param String $sql
     * @return resource/boolean
     */
    protected function execute($sql) {
        $result = $this->db->query($sql);
        if (_SB_MODULE_SQL_LOGGER && mysql_error()) {
            error_log(date("Y-m-d h:i:s") . "  : " . mysql_error()." : ".$sql . chr(10), 3, _SB_MODULE_SQL_LOG);
        }
        return $result;
    }

    /**
     * ǡ١ꥹȷǥǡ
     *
     * @param String $sql
     * @return Array
     */
    protected function getList($sql) {
        $result = $this->execute($sql);

        $list = array();
        while ($row = $this->db->fetchArray($result)) {
            $list[] = $row;
        }
        return $list;
    }

    /**
     * ǤդΥơ֥ǤդΥκͤ
     *
     * @param String $table ơ֥̾
     * @param String $column ̾
     */
    function getMaxValue($table, $column) {
        $sql = "SELECT MAX(" . $column . ") as '" . $column . "'FROM " . $table;
        $recordList = $this->getList($sql);
        return $recordList[0][$column];
    }

    /**
     * ǤդΥơ֥Υ쥳ɤ򹹿
     *
     * @param String $table ơ֥̾
     * @return boolean
     */
    function update($table) {
        $sql = "UPDATE " . $table . " SET";
        foreach ($this->dataList as $column => $data) {
            /* Ϲʤ */
            if ($data['key']) {
                $keyList[] = $column;
            }
            else {
                if (is_null($data['data'])) {
                    $sql .= " " . $column . " = NULL,";
                }
                else {
                    $sql .= " " . $column . " = '" . $data['data'] . "',";
                }
            }
        }

        $sql = substr($sql, 0, strlen($sql) - 1);
        $cnt = 0;
        foreach ($keyList as $column) {
            if ($cnt == 0) {
                $sql .= " WHERE " . $column . " = " . $this->dataList[$column]['data'];
            }
            else {
                $sql .= " AND " . $column . " = " . $this->dataList[$column]['data'];
            }
            $cnt++;
        }

        return $this->execute($sql);
    }

    /**
     * ǤդΥơ֥˥쥳ɤɲä
     *
     * @param String $table ơ֥̾
     * @return boolean
     */
    function insert($table) {
        foreach ($this->dataList as $key => $data) {
            $keyList[] = $key;
            $valueList[] = $data['data'];
        }
        $sql = "INSERT INTO " . $table;
        $sql .= " (" . implode(",", $keyList) . ")";
        $sql .= " VALUES ";

        $sql .= "(";

        $insertData = "";
        foreach ($valueList as $value) {
            if (is_null($value)) {
                $insertData .= ", NULL";
            }
            else {
                $insertData .= ", '" . $value . "'";
            }
        }
        $insertData = substr($insertData, 1);
        $sql .= $insertData . ")";

        return $this->execute($sql);
    }

    /**
     * ǤդΥơ֥Υ쥳ɤ
     *
     * @param String $table ơ֥̾
     * @return boolean
     */
    function delete($table) {
        if (!empty($this->dataList)) {
            foreach ($this->dataList as $column => $data) {
                if (array_key_exists('key', $data) && $data['key']) {
                    $keyList[] = $column;
                }
            }
        }

        $sql = "DELETE FROM " . $table;
        if (!empty($keyList)) {
            $cnt = 0;
            foreach ($keyList as $column) {
                if ($cnt == 0) {
                    $sql .= " WHERE " . $column . " = " . @$this->dataList[$column]['data'];
                }
                else {
                    $sql .= " AND " . $column . " = " . @$this->dataList[$column]['data'];
                }
                $cnt++;
            }
        }
        return $this->execute($sql);
    }

    /**
     * ˥åȤǡΥå
     *
     * @param mixed $data ǡ
     * @param String $column ̾
     * @param String $type ǡ
     * @param boolean $key ˤ뤫ɤ
     */
    function setDataList($data, $column, $type = null, $key = false) {
        if ($type == _SB_MODULE_DB_SET_INTEGER) {
            $this->dataList[$column]['data'] = addslashes(intval($data));
        }
        elseif ($type == _SB_MODULE_DB_SET_STRING) {
            $this->dataList[$column]['data'] = addslashes($data);
        }
        elseif ($type == _SB_MODULE_DB_SET_DATE) {
            $this->dataList[$column]['data'] = addslashes($data);
        }
        else {
            $this->dataList[$column]['data'] = NULL;
        }

        /* ʤե饰ΩƤ */
        if ($key) {
            $this->dataList[$column]['key'] = true;
        }
        else {
            $this->dataList[$column]['key'] = false;
        }
    }

    /**
     * ˥åȤǡ
     *
     */
    function destroyDataList() {
        unset($this->dataList);
    }
}
?>