<?php
if (!defined('XOOPS_ROOT_PATH')) {
    exit();
}
require_once _SB_MODULE_PATH . "class/database/DatabaseScoreBookClass.php";

/**
 * sb_gameơ֥륯饹
 *
 * @since 1.0.3
 * @author saitoh-y
 */
class Game extends DatabaseScoreBook {

    /**
     * 祳
     *
     * @access private
     * @var Integer
     */
    private $gameCd=0;

    /**
     * ॳ
     *
     * @accessprivate
     * @var Integer
     */
    private $teamCd=0;

    /**
     * ߥå
     *
     * @accessprivate
     * @var Integer
     */
    private $limit=0;

    /**
     * ƥꥳ
     *
     * @accessprivate
     * @var Integer
     */
    private $categoryCd = 0;

    /**
     * sb_gameơ֥ƤΥ쥳ɤ
     *
     * @return Array
     */
    function getAllList() {
        $sql = "SELECT * FROM " . $this->tableNameGame . " as game LEFT JOIN ";
        $sql .= $this->tableNameCategory . " as cat";
        $sql .= " ON game.category_cd = cat.category_cd ORDER BY game_date DESC";
        return $this->getList($sql);
    }

    /**
     * sb_gameơ֥1쥳ɤꤷƼ
     *
     * @return Array
     */
    function getGame() {
        $sql = "SELECT * FROM " . $this->tableNameGame . " as game LEFT JOIN ";
        $sql .= $this->tableNameCategory . " as cat";
        $sql .= " ON game.category_cd = cat.category_cd";
        $sql .= " WHERE game_cd = " . $this->gameCd;
        $recordList = $this->getList($sql);
        return (!empty($recordList[0])) ? $recordList[0] : array();
    }

    /**
     * դι߽˥쥳ɤ
     *
     */
    function getLastGame() {
        $sql = "SELECT * FROM " . $this->tableNameGame . " as game ";
        $sql .= "LEFT JOIN " . $this->tableNameCategory . " as cat ";
        $sql .= "ON game.category_cd = cat.category_cd ";
        $sql .= "ORDER BY game.game_date DESC";
        if ($this->limit) {
            $sql .= " LIMIT " . $this->limit;
        }

        return $this->getList($sql);
    }

    /**
     * sb_gameơ֥Ǻλ祳ɤ
     *
     * @param String $column ̾
     * @return Integer
     */
    function getMaxValue($column) {
        return parent::getMaxValue($this->tableNameGame, $column);
    }

    /**
     * sb_gameơ֥ǺǤŤǯ
     *
     * @return Integer
     */
    function getOldestYear() {
        $sql = "SELECT LEFT(MIN(game_date),4) as year FROM " . $this->tableNameGame;
        $recordList = $this->getList($sql);
        return $recordList[0]['year'];
    }

    /**
     * sb_gameơ֥ǺǤ⿷ǯ
     *
     * @return Integer
     */
    function getLastestYear() {
        $sql = "SELECT LEFT(MAX(game_date),4) as year FROM " . $this->tableNameGame;
        $recordList = $this->getList($sql);
        return $recordList[0]['year'];
    }

    /**
     * ऴȤλ
     *
     * @param mixed $year
     * @return Integer
     */
    function getGameCount($year = 'total') {
        $sql = "SELECT count(*) as game_count FROM " . $this->tableNameGame;
        $sql .= " WHERE (top_team_cd = " . $this->teamCd;
        $sql .= " OR bottom_team_cd = " . $this->teamCd . ")";
        if ($year != 'total') {
            $sql .= " AND game_date BETWEEN CAST('$year-01-01'as DATE)";
            $sql .= " AND CAST('$year-12-31'as DATE)";
        }
        if (!empty($this->categoryCd)) {
            $sql .= " AND category_cd = " . $this->categoryCd;
        }

        $recordList = $this->getList($sql);
        return $recordList[0]['game_count'];
    }

    /**
     * sb_gameơ֥˥쥳ɤɲä
     *
     * @return boolean
     */
    function insert() {
        return parent::insert($this->tableNameGame);
    }

    /**
     * sb_gameơ֥Υ쥳ɤ򹹿
     *
     * @return boolean
     */
    function update() {
        return parent::update($this->tableNameGame);
    }

    /**
     * sb_gameơ֥Υ쥳ɤ
     *
     * @return boolean
     */
    function delete() {
        return parent::delete($this->tableNameGame);
    }

    /**
     * 祳ɤΥå
     *
     * @param Integer $gameCd
     */
    function setGameCd($gameCd) {
        $this->gameCd = addslashes(intval($gameCd));
    }

    /**
     * ॳɤΥå
     *
     * @param Integer $teamCd
     */
    function setTeamCd($teamCd) {
        $this->teamCd = addslashes(intval($teamCd));
    }

    /**
     * ߥåȤΥå
     *
     * @param Integer $limit
     */
    function setLimit($limit) {
        $this->limit = addslashes(intval($limit));
    }

    /**
     * ƥꥳɤΥå
     *
     * @param Integer $categoryCd
     */
    function setCategoryCd($categoryCd) {
        $this->categoryCd = addslashes(intval($categoryCd));
    }
}
?>