package com.ozacc.springframework.mail.javamail;

import org.springframework.mail.MailException;

import com.ozacc.springframework.mail.VelocityMailMessage;

/**
 * VelocityMailMessage᥽åɤ󥿡ե
 * 
 * @author Tomohiro Otsuka
 * @version $Id: VelocityJavaMailSender.java,v 1.1 2004/08/02 20:39:06 otsuka Exp $
 */
public interface VelocityJavaMailSender extends IntlJavaMailSender {

	/**
	 * Send the given VelocityMailMessage.
	 * 
	 * @param velocityMailMessage VelocityMailMessage
	 * @throws MailException
	 */
	void send(VelocityMailMessage velocityMailMessage) throws MailException;

	/**
	 * Send the given VelocityMailMessages.
	 * 
	 * @param velocityMailMessages VelocityMailMessage
	 * @throws MailException
	 */
	void send(VelocityMailMessage[] velocityMailMessages) throws MailException;

}