package com.ozacc.springframework.mail.javamail;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;

import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.ui.velocity.VelocityEngineFactory;
import org.springframework.ui.velocity.VelocityEngineUtils;

import com.ozacc.springframework.mail.VelocityMailMessage;

/**
 * VelocityJavaMailSender󥿡եμ饹
 * 
 * VelocityEngine󥹥󥹤˰¸ޤΥ󥹥󥹤
 * åȤƤʤϡbeanƱVelocityEngine
 * ޤ
 * 
 * <pre>
 * <bean id="velocityEngine" class="org.springframework.ui.velocity.VelocityEngineFactoryBean">
 * 	<property name="overrideLogging"><value>true</value></property>
 * 	<property name="velocityProperties">
 * 		<props>
 * 			<prop key="resource.loader">class</prop>
 * 			<prop key="class.resource.loader.class">org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader</prop>
 * 			<prop key="input.encoding">UTF-8</prop>
 * 			<prop key="output.encoding">UTF-8</prop>
 * 			<prop key="velocimacro.library"/>
 * 		</props>
 * 	</property>
 * </bean>
 * </pre>
 * 
 * <p>
 * Υ饹VelocityEngine󥹥󥹤Ǥ硢Velocityƥץ졼Ȥ
 * UTF-8ǥ󥳡ɤƤ
 * <p>
 * <em>NOTE: ޤ¸ʳǤ</em>
 * 
 * @author Tomohiro Otsuka
 * @version $Id: VelocityJavaMailSenderImpl.java,v 1.1 2004/08/02 20:39:06 otsuka Exp $
 */
public class VelocityJavaMailSenderImpl extends IntlJavaMailSenderImpl implements VelocityJavaMailSender {

	private VelocityEngine velocityEngine;

	/**
	 * @see com.ozacc.springframework.mail.javamail.VelocityJavaMailSender#send(com.ozacc.springframework.mail.VelocityMailMessage)
	 */
	public void send(VelocityMailMessage velocityMailMessage) throws MailException {
		send(new VelocityMailMessage[] { velocityMailMessage });
	}

	/**
	 * @see com.ozacc.springframework.mail.javamail.VelocityJavaMailSender#send(com.ozacc.springframework.mail.VelocityMailMessage[])
	 */
	public void send(VelocityMailMessage[] velocityMailMessages) throws MailException {
		if (velocityEngine == null) {
			try {
				velocityEngine = createDefaultVelocityEngine();
			} catch (Exception e) {
				throw new MailParseException("Fails to create a velocity engine.", e);
			}
		}

		// ʸ
		try {
			setTextUsingVelocity(velocityMailMessages);
		} catch (VelocityException e) {
			throw new MailParseException("Fails to generate text using Velocity.", e);
		}

		super.send(velocityMailMessages);
	}

	/**
	 * velocityMailMessages˴ޤޤVelocityƥץ졼ȥѥContext
	 * VelocityEngineϤʸƥåȤޤ
	 * 
	 * @param velocityMailMessages
	 */
	private void setTextUsingVelocity(VelocityMailMessage[] velocityMailMessages)
																					throws VelocityException {
		for (int i = 0; i < velocityMailMessages.length; i++) {
			VelocityMailMessage msg = velocityMailMessages[i];
			if (validate(msg)) {
				String generatedText = VelocityEngineUtils.mergeTemplateIntoString(velocityEngine,
						msg.getTemplatePath(), msg.getContext());

				msg.setText(generatedText);
			} else {
				throw new MailParseException("Velocity template path and/or context is not set.");
			}
		}
	}

	/**
	 * @param velocityMailMessage
	 * @return ƥץ졼ȥѥȥƥȤåȤƤ true
	 */
	private boolean validate(VelocityMailMessage velocityMailMessage) {
		String templatePath = velocityMailMessage.getTemplatePath();
		Map context = velocityMailMessage.getContext();

		return templatePath != null && templatePath.length() > 0 && context != null;
	}

	/**
	 * beanƱVelocityEngine֤ޤ
	 * <pre>
	 * <bean id="velocityEngine" class="org.springframework.ui.velocity.VelocityEngineFactoryBean">
	 * 	<property name="overrideLogging"><value>true</value></property>
	 * 	<property name="velocityProperties">
	 * 		<props>
	 * 			<prop key="resource.loader">class</prop>
	 * 			<prop key="class.resource.loader.class">org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader</prop>
	 * 			<prop key="input.encoding">UTF-8</prop>
	 * 			<prop key="output.encoding">UTF-8</prop>
	 * 			<prop key="velocimacro.library"/>
	 * 		</props>
	 * 	</property>
	 * </bean>
	 * </pre>
	 * 
	 * @return VelocityEngine
	 */
	private VelocityEngine createDefaultVelocityEngine() throws IOException, VelocityException {
		VelocityEngineFactory factory = new VelocityEngineFactory();

		factory.setOverrideLogging(true);

		Properties props = new Properties();
		props.put("resource.loader", "class");
		props.put("class.resource.loader.class",
				"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
		props.put("input.encoding", "UTF-8");
		props.put("output.encoding", "UTF-8");
		props.put("velocimacro.library", "");
		factory.setVelocityProperties(props);

		return factory.createVelocityEngine();
	}

	/**
	 * @param engine 
	 */
	public void setVelocityEngine(VelocityEngine engine) {
		velocityEngine = engine;
	}

}