package com.ozacc.mail.spring;

import java.io.File;

import org.springframework.beans.factory.config.AbstractFactoryBean;

import com.ozacc.mail.Mail;
import com.ozacc.mail.MailBuildException;
import com.ozacc.mail.XMLMailBuilder;

/**
 * Springեǻꤵ줿XMLե뤫Mail󥹥󥹤FactoryBean
 * ǥեȤǤϡsingletonץѥƥfalseꤵޤ
 * 
 * @author Tomohiro Otsuka
 * @version $Id: XMLMailFactoryBean.java,v 1.1 2004/09/05 17:25:32 otsuka Exp $
 */
public class XMLMailFactoryBean extends AbstractFactoryBean {

	private String classPath;

	private String filePath;

	private XMLMailBuilder mailBuilder;

	/**
	 * 󥹥ȥ饯
	 */
	public XMLMailFactoryBean() {
		mailBuilder = XMLMailBuilder.getInstance();
		setSingleton(false);
	}

	/**
	 * @see org.springframework.beans.factory.config.AbstractFactoryBean#createInstance()
	 */
	protected Object createInstance() throws Exception {
		if (getClass() != null) {
			return mailBuilder.buildMail(getClassPath());
		}
		if (getFilePath() != null) {
			return mailBuilder.buildMail(new File(filePath));
		}

		throw new MailBuildException("Mail󥹥󥹤˼ԤޤXMLǡΥ󤬻ꤵƤޤ");
	}

	/**
	 * @see org.springframework.beans.factory.FactoryBean#getObjectType()
	 */
	public Class getObjectType() {
		return Mail.class;
	}

	/**
	 * @return Returns the classPath.
	 */
	public String getClassPath() {
		return classPath;
	}

	/**
	 * @param classPath The classPath to set.
	 */
	public void setClassPath(String classPath) {
		this.classPath = classPath;
	}

	/**
	 * @return Returns the filePath.
	 */
	public String getFilePath() {
		return filePath;
	}

	/**
	 * @param filePath The filePath to set.
	 */
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}
}