package com.ozacc.mail.xml.impl;

import java.io.File;
import java.util.Properties;

import javax.mail.internet.InternetAddress;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

import com.ozacc.mail.Mail;
import com.ozacc.mail.xml.XMLBuildException;
import com.ozacc.mail.xml.XMLBuilder;

/**
 * JDK 1.4ʹߤɸXML饤֥ѤƼ줿XMLBuilder
 * 
 * @author Tomohiro Otsuka
 * @version $Id: XMLBuilderImpl.java,v 1.2 2004/09/10 07:35:22 otsuka Exp $
 */
public class XMLBuilderImpl implements XMLBuilder {

	public static final String DOCTYPE_PUBLIC = "-//OZACC//DTD MAIL//EN";

	public static final String DOCTYPE_SYSTEM = "http://www.ozacc.com/library/dtd/ozacc-mail.dtd";

	private String charset = "UTF-8";

	/**
	 * 󥹥ȥ饯
	 */
	public XMLBuilderImpl() {}

	/**
	 * 󥹥ȥ饯
	 * XMLեʸɤꤷޤǥեȤUTF-8
	 * 
	 * @param charset XMLեʸ
	 */
	public XMLBuilderImpl(String charset) {
		super();
		this.charset = charset;
	}

	/**
	 * XMLեʸɤ֤ޤ
	 * 
	 * @return XMLեʸ
	 */
	public String getCharset() {
		return charset;
	}

	/**
	 * XMLեʸɤꤷޤǥեȤUTF-8
	 * 
	 * @param charset XMLեʸ
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * @see com.ozacc.mail.xml.XMLBuilder#buildDocument(com.ozacc.mail.Mail)
	 */
	public Document buildDocument(Mail mail) throws XMLBuildException {
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db;
		try {
			db = dbf.newDocumentBuilder();
		} catch (ParserConfigurationException e) {
			// never be thrown
			throw new XMLBuildException(e.getMessage());
		}
		Document doc = db.newDocument();

		DOMImplementation domImpl = doc.getImplementation();
		DocumentType docType = domImpl.createDocumentType("mail", DOCTYPE_PUBLIC, DOCTYPE_SYSTEM);
		doc.appendChild(docType);

		Element mailElem = doc.createElement("mail");

		// Return-Path
		if (mail.getReturnPath() != null) {
			InternetAddress returnPath = mail.getReturnPath();
			Element returnPathElem = convertInternetAddressIntoElement(returnPath, "returnPath",
					doc);
			mailElem.appendChild(returnPathElem);
		}

		// From
		if (mail.getFrom() != null) {
			InternetAddress from = mail.getFrom();
			Element fromElem = convertInternetAddressIntoElement(from, "from", doc);
			mailElem.appendChild(fromElem);
		}

		if (mail.getTo().length > 0 || mail.getCc().length > 0 || mail.getBcc().length > 0) {
			Element recipientsElem = doc.createElement("recipients");

			// To
			if (mail.getTo().length > 0) {
				for (int i = 0; i < mail.getTo().length; i++) {
					InternetAddress to = mail.getTo()[i];
					Element toElem = convertInternetAddressIntoElement(to, "to", doc);
					recipientsElem.appendChild(toElem);
				}
			}
			// Cc
			if (mail.getCc().length > 0) {
				for (int i = 0; i < mail.getCc().length; i++) {
					InternetAddress cc = mail.getCc()[i];
					Element ccElem = convertInternetAddressIntoElement(cc, "cc", doc);
					recipientsElem.appendChild(ccElem);
				}
			}
			// Bcc
			if (mail.getBcc().length > 0) {
				for (int i = 0; i < mail.getBcc().length; i++) {
					InternetAddress bcc = mail.getBcc()[i];
					Element bccElem = convertInternetAddressIntoElement(bcc, "bcc", doc);
					recipientsElem.appendChild(bccElem);
				}
			}
			mailElem.appendChild(recipientsElem);
		}

		// Reply-To
		if (mail.getReplyTo() != null) {
			InternetAddress replyTo = mail.getReplyTo();
			Element replyToElem = convertInternetAddressIntoElement(replyTo, "replyTo", doc);
			mailElem.appendChild(replyToElem);
		}

		// Subject
		if (mail.getSubject() != null) {
			Element subjectElem = doc.createElement("subject");
			subjectElem.appendChild(doc.createTextNode(mail.getSubject()));
			mailElem.appendChild(subjectElem);
		}

		// Body
		if (mail.getText() != null) {
			Element bodyElem = doc.createElement("body");
			bodyElem.appendChild(doc.createTextNode(mail.getText()));
			mailElem.appendChild(bodyElem);
		}

		doc.appendChild(mailElem);

		return doc;
	}

	private Element convertInternetAddressIntoElement(InternetAddress address, String elemName,
														Document doc) {
		Element element = doc.createElement(elemName);
		element.setAttribute("email", address.getAddress());
		if (address.getPersonal() != null) {
			element.setAttribute("name", address.getPersonal());
		}
		return element;
	}

	/**
	 * ꤵ줿Mail󥹥󥹤XMLɥȤ
	 * ꤵ줿ե¸ޤ
	 * 
	 * Υ᥽åǻѤTransformerFactoryåɥդǤϤʤᡢsynchronzed᥽åɤˤʤäƤޤ
	 * 
	 * @see com.ozacc.mail.xml.XMLBuilder#saveDocument(com.ozacc.mail.Mail, java.io.File)
	 * @see TransformerFactory
	 */
	public synchronized void saveDocument(Mail mail, File destFile) throws XMLBuildException {
		Document doc = buildDocument(mail);

		Transformer t;
		try {
			t = TransformerFactory.newInstance().newTransformer();
		} catch (Exception e) {
			// never be thrown
			throw new XMLBuildException(e.getMessage());
		}
		t.setOutputProperties(getOutputProperties());

		DOMSource source = new DOMSource(doc);
		StreamResult result = new StreamResult(destFile);
		try {
			t.transform(source, result);
		} catch (TransformerException e) {
			throw new XMLBuildException("XMLե¸˼Ԥޤ", e);
		}
	}

	/**
	 * ϥץѥƥ
	 * @return ϥץѥƥꤷProperties󥹥
	 */
	private Properties getOutputProperties() {
		Properties p = new Properties();
		p.put(OutputKeys.ENCODING, charset);
		p.put(OutputKeys.INDENT, "yes");
		p.put(OutputKeys.DOCTYPE_PUBLIC, DOCTYPE_PUBLIC);
		p.put(OutputKeys.DOCTYPE_SYSTEM, DOCTYPE_SYSTEM);
		return p;
	}

}