package com.ozacc.mail.mailet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ozacc.mail.fetch.ReceivedMail;

/**
 * Mailet󥹥󥹤Matcher󥹥󥹤ΥꥹȤMailetμ¹ñ̤Ȥʤ륯饹
 * 
 * @since 1.2
 * @author Tomohiro Otsuka
 * @version $Id: MailetWrapper.java,v 1.1.2.2 2005/01/23 06:47:01 otsuka Exp $
 */
public class MailetWrapper {

	private Mailet mailet;

	private List matcherList;

	/**
	 * 󥹥ȥ饯
	 */
	public MailetWrapper() {
		matcherList = new ArrayList();
	}

	/**
	 * 󥹥ȥ饯
	 * 
	 * @param mailet Mailet󥹥
	 * @param matcherList Matcher󥹥󥹤Υꥹ
	 */
	public MailetWrapper(Mailet mailet, List matcherList) {
		this();
		this.mailet = mailet;
		this.matcherList = matcherList;
	}

	/**
	 * ꥹȤƤMatcherξ򥯥ꥢMailet¹Ԥޤ
	 * 
	 * @param mail ᡼
	 */
	public void execute(ReceivedMail mail) {
		for (Iterator itr = matcherList.iterator(); itr.hasNext();) {
			Matcher m = (Matcher)itr.next();
			if (!m.match(mail)) {
				return;
			}
		}
		mailet.service(mail);
	}

	/**
	 * Mailet󥹥󥹤֤ޤ
	 * 
	 * @return Mailet󥹥
	 */
	public Mailet getMailet() {
		return mailet;
	}

	/**
	 * Mailet󥹥󥹤򥻥åȤޤ
	 * 
	 * @param mailet Mailet󥹥
	 */
	public void setMailet(Mailet mailet) {
		this.mailet = mailet;
	}

	/**
	 * Matcher󥹥󥹤ΥꥹȤ֤ޤ
	 * 
	 * @return Matcher󥹥󥹤Υꥹ
	 */
	public List getMatcherList() {
		return matcherList;
	}

	/**
	 * Matcher󥹥󥹤ΥꥹȤ򥻥åȤޤ
	 * 
	 * @param matcherList Matcher󥹥󥹤Υꥹ
	 */
	public void setMatcherList(List matcherList) {
		this.matcherList = matcherList;
	}
}