/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generator;

import org.sql.column.RegistColumn;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.AbstractConditionSql;
import org.sql.message.Message;
import org.sql.util.GeneratorUtil;

public class UpdateSql
extends AbstractConditionSql {
    public UpdateSql(String table) {
        super(table);
    }

    public UpdateSql(String table, RegistColumn column) {
        super(table);
        super.setColumn(column);
    }

    public UpdateSql(String table, RegistColumn column, Condition condition) {
        super(table, condition);
        super.setColumn(column);
    }

    protected String createSql(boolean bind) throws GeneratorException {
        StringBuffer result = new StringBuffer();
        if (super.getCondition() == null) {
            super.setCondition(new Condition());
        }
        if (!GeneratorUtil.isNaming(this.getFrom())) {
            throw new GeneratorException(Message.getInstance("SQL-001", this.getFrom()));
        }
        result.append("UPDATE ");
        result.append(this.getFrom());
        result.append(" SET ");
        if (bind) {
            result.append(this.getBindVariable());
            result.append(super.getCondition().getBindCondition());
        } else {
            result.append(super.getColumn().toColumnString());
            result.append(super.getCondition().getCondition());
        }
        return result.toString();
    }

    protected String getBindVariable() {
        StringBuffer result = new StringBuffer();
        Object[] key = super.getColumn().getMap().keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            Object value;
            if (result.length() > 0) {
                result.append(", ");
            }
            if (GeneratorUtil.isExclusion((value = super.getColumn().getMap().get(key[i])).toString())) {
                result.append(key[i] + " = " + GeneratorUtil.getExclusion(value.toString()));
                continue;
            }
            result.append(key[i] + " = ?");
        }
        return result.toString();
    }
}

