/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_Mem;
import org.sqlite.swig.SWIGTYPE_p_p_Mem;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_context;
import org.sqlite.swig.SWIGTYPE_p_void;

public class Context {
    private final SWIGTYPE_p_sqlite3_context ctx;
    private final int argc;
    private final SWIGTYPE_p_p_Mem value;

    public Context(long ctx) {
        this(ctx, 0, 0L);
    }

    public Context(long ctx, int argc, long value) {
        this(new SQLite3Context(ctx), argc, value != 0L ? new SQLite3ValuePtrPtr(value) : null);
    }

    public Context(SWIGTYPE_p_sqlite3_context ctx, int argc, SWIGTYPE_p_p_Mem value) {
        this.ctx = ctx;
        this.argc = argc;
        this.value = value;
    }

    public int getArgumentCount() {
        return this.argc;
    }

    public boolean hasValues() {
        return this.argc > 0 && this.value != null;
    }

    public void result(SWIGTYPE_p_void x, int bytes) {
        SQLite3.sqlite3_result_blob(this.ctx, x, bytes);
    }

    public void result(byte[] x) {
        this.result(x, x.length);
    }

    public void result(byte[] x, int len) {
        SQLite3.sqlite3_result_blob(this.ctx, x, len);
    }

    public void result(double x) {
        SQLite3.sqlite3_result_double(this.ctx, x);
    }

    public void result(int x) {
        SQLite3.sqlite3_result_int(this.ctx, x);
    }

    public void result(long x) {
        SQLite3.sqlite3_result_int64(this.ctx, x);
    }

    public void result(String x) {
        SQLite3.sqlite3_result_text(this.ctx, x);
    }

    public void result(SWIGTYPE_p_Mem x) {
        SQLite3.sqlite3_result_value(this.ctx, x);
    }

    public void result(Date x) {
        SQLite3.sqlite3_result_text(this.ctx, SQLite3.format(x));
    }

    public void result(Time x) {
        SQLite3.sqlite3_result_text(this.ctx, SQLite3.format(x));
    }

    public void result(Timestamp x) {
        SQLite3.sqlite3_result_text(this.ctx, SQLite3.format(x));
    }

    public void resultError(String x) {
        SQLite3.sqlite3_result_error(this.ctx, x);
    }

    public void resultNull() {
        SQLite3.sqlite3_result_null(this.ctx);
    }

    public SWIGTYPE_p_void getBlob(int parameterIndex) throws SQLException {
        return SQLite3.sqlite3_value_blob(this.getSQLite3ValuePtr(parameterIndex));
    }

    public int getByteLength(int parameterIndex) throws SQLException {
        return SQLite3.sqlite3_value_bytes(this.getSQLite3ValuePtr(parameterIndex));
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        return SQLite3.sqlite3_value_blob_by_bytes(this.getSQLite3ValuePtr(parameterIndex));
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return SQLite3.sqlite3_value_double(this.getSQLite3ValuePtr(parameterIndex));
    }

    public int getInt(int parameterIndex) throws SQLException {
        return SQLite3.sqlite3_value_int(this.getSQLite3ValuePtr(parameterIndex));
    }

    public long getLong(int parameterIndex) throws SQLException {
        return SQLite3.sqlite3_value_int64(this.getSQLite3ValuePtr(parameterIndex));
    }

    public String getString(int parameterIndex) throws SQLException {
        return SQLite3.sqlite3_value_text(this.getSQLite3ValuePtr(parameterIndex));
    }

    public Date getDate(int parameterIndex) throws SQLException {
        String val = SQLite3.sqlite3_value_text(this.getSQLite3ValuePtr(parameterIndex));
        Date ret = null;
        if (val != null) {
            ret = new Date(SQLite3.parseDate(val));
        }
        return ret;
    }

    public Time getTime(int parameterIndex) throws SQLException {
        String val = SQLite3.sqlite3_value_text(this.getSQLite3ValuePtr(parameterIndex));
        Time ret = null;
        if (val != null) {
            ret = new Time(SQLite3.parseTime(val));
        }
        return ret;
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        String val = SQLite3.sqlite3_value_text(this.getSQLite3ValuePtr(parameterIndex));
        Timestamp ret = null;
        if (val != null) {
            ret = new Timestamp(SQLite3.parseTimestamp(val));
        }
        return ret;
    }

    public int getValueType(int parameterIndex) throws SQLException {
        return SQLite3.sqlite3_value_type(this.getSQLite3ValuePtr(parameterIndex));
    }

    public int getValueNumericType(int parameterIndex) throws SQLException {
        return SQLite3.sqlite3_value_numeric_type(this.getSQLite3ValuePtr(parameterIndex));
    }

    protected void validateParamaeterIndexRange(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.argc) {
            throw new SQLException("Parameter index out of range.", "90J01");
        }
    }

    public SWIGTYPE_p_Mem getSQLite3ValuePtr(int parameterIndex) throws SQLException {
        if (this.value == null) {
            throw new NullPointerException("value is null");
        }
        this.validateParamaeterIndexRange(parameterIndex);
        return SQLite3.get_p_sqlite3_value(this.value, parameterIndex - 1);
    }

    private static class SQLite3ValuePtrPtr
    extends SWIGTYPE_p_p_Mem {
        private SQLite3ValuePtrPtr(long p) {
            super(p, false);
        }
    }

    private static class SQLite3Context
    extends SWIGTYPE_p_sqlite3_context {
        private SQLite3Context(long p) {
            super(p, false);
        }
    }
}

