/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.udf;

import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.Context;

public abstract class Function {
    protected final String name;
    protected final int argc;
    private volatile long pUserData;

    protected Function(String name) {
        this(name, -1);
    }

    protected Function(String name, int argc) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        this.argc = argc;
    }

    public String getName() {
        return this.name;
    }

    public int getArgumentCount() {
        return this.argc;
    }

    public boolean isRegistered() {
        return this.pUserData != 0L;
    }

    private void xFunc(long context, int argc, long value) {
        Context ctx = null;
        try {
            ctx = new Context(context, argc, value);
            this.xFunc(ctx);
        }
        catch (Throwable th) {
            if (ctx != null) {
                String msg = th.toString();
                ctx.resultError(msg != null ? msg : "unknown error.");
            }
            Logger.getLogger(Function.class.getName()).fine("Exception occurred: " + th.toString());
        }
    }

    protected abstract void xFunc(Context var1) throws SQLException;
}

