import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.profiler.Tracer;

public class TracerExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new tracer
            final Tracer tracer
                    = new Tracer() {
                            @Override
                            protected void xTrace(String sql) {
                                System.out.println("SQL: [" + sql + "]");
                            }
                        };
            // set tracer
            conn.setTracer(tracer);
            
            final Statement stmt = conn.createStatement();
            final String sql
                    = "SELECT VAL FROM ("
                        + "SELECT 1 AS VAL UNION ALL "
                        + "SELECT 2 AS VAL UNION ALL "
                        + "SELECT 3 AS VAL UNION ALL "
                        + "SELECT 4 AS VAL UNION ALL "
                        + "SELECT 5 AS VAL"
                    + ")";

            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.println("VAL: " + rs.getString(1));
            }
            stmt.close();

            // clear tracer
            conn.clearTracer();
            
        } finally {
            conn.close();
        }
    }
    
    public static void main(String[] args) throws Exception {
        new TracerExample().example();
    }
}
