/*
 * ********************************************************************
 * SQLC Release 0.2.1
 * ********************************************************************
 */
package clib.com;

import java.io.*;
import java.util.*;
import java.sql.*;
import java.text.*;
import java.net.*;
import java.lang.reflect.*;

/**
 * DriverLoader
 *
 * @version   1.0
 * @since     JDK1.1
 * @author    dynaworks
 */
public class DriverLoader
{
    Vector drivers;
    Vector loaded_drivers;
    final static String DEFAULT_DRIVER_NAME  = "sun.jdbc.odbc.JdbcOdbcDriver";

    /**
     * \z
     */
    public DriverLoader()
    {
        drivers = new Vector();
        loaded_drivers = new Vector();
    }

    /**
     * 
     */
    public void addDriver(String driver_name)
    {
        if( driver_name != null && !(driver_name.length() <= 0) && !drivers.contains(driver_name) )
            drivers.addElement(driver_name);
    }

    /**
     * hCo̐ݒ
     */
    public void cinput(CommCtx comm) throws IOException
    {
        String   driver_name;
        comm.out().print("JDBCDriver [" + DEFAULT_DRIVER_NAME + "]: "); comm.out().flush(); driver_name = comm.in().readLine();
        if( driver_name.length() <= 0 ) driver_name = DEFAULT_DRIVER_NAME;
        addDriver(driver_name);
    }

    /**
     * hCo̓Ǎ
     */
    public void cload(CommCtx comm) throws Exception
    {
        String driver_name;
        
        for(Enumeration i=drivers.elements();i.hasMoreElements();)
        {
            driver_name = (String)i.nextElement();
            if( !loaded_drivers.contains(driver_name) )
            {
                try
                {
                    Class.forName(driver_name);
                    comm.out().println( "Load JDBCDriver \"" + driver_name + "\"" );
                    loaded_drivers.addElement(driver_name);
                }
                catch(ClassNotFoundException e)
                {
                    comm.out().println( "JDBCDriver \"" + driver_name + "\" NotFound" );
                    System.out.println(e);
                    e.printStackTrace();
                }
            }
        }
    }
}
