/*
 * ********************************************************************
 * SQLC Release 0.2.1
 * ====================================================================
 * RELEASE,DATE,REMARK
 * --------------------------------------------------------------------
 * 0.1.0,2003/09/20
 * 0.2.0,2003/09/27
 * 0.2.1,2003/10/04
 * ********************************************************************
 */

import java.io.*;
import java.util.*;
import java.sql.*;
import java.text.*;

import clib.com.*;
import clib.cmd.*;

/**
 * sqlc
 *
 * @version   0.2.1
 * @since     JDK1.1
 * @author    dynaworks
 */
public class sqlc
{
    final static String LOGO = "SQLC Release Release 0.2.1";

    // *********************************
    // R}hCIvV
    // *********************************
    final static String OPTION_CONNECT_STR       = "CONN";
    final static String OPTION_DRIVER_STR        = "DRV";

    // hCo
    static DriverLoader drvman = new DriverLoader();

    static public void  main(String[] argv)
    {
        ConnectionCtx  conn = new ConnectionCtx();
        CommCtx        comm = null;

        try
        {
// ********************************************************************
// 
// ********************************************************************
            comm = new CommCtx( System.in,System.out );
            comm.out().println( LOGO );

            // **********************************
            // R}hC
            // **********************************
            CommandLineOptions opts = new CommandLineOptions(argv,'-',':');

            // **********************************
            // caڑ𓾂
            // **********************************
            // hCo
            String driver_name = opts.getOptionString(OPTION_DRIVER_STR);
            if( driver_name == null || driver_name.length() <= 0 )
                drvman.cinput(comm);
            else
                drvman.addDriver(driver_name);
            drvman.cload(comm);

            // ڑ
            String connect_info = opts.getOptionString(OPTION_CONNECT_STR);
            if( connect_info == null )
                conn.cinput(comm);
            else
                conn.setConnectionInfo(connect_info);

            conn.startup(comm);
// ********************************************************************
// R}h̎s
// ********************************************************************
            boolean fret = true;
            while( fret )
            {
                // ****************************************************
                // R}h
                // ****************************************************
                CommandBase cmd = CommandRequest.cinput(comm,"SQLC> ");
                if( cmd == null )
                    comm.out().println("No such command ");
                if( cmd.getExit() ) break;
                if( cmd.getNop() )  continue;

                // ****************************************************
                // R}hs
                // ****************************************************
                fret = cmd.execute(new ExecuteCtx(comm,conn));
            }
        }
        catch( Exception e )
        {
            System.out.println(e);
            e.printStackTrace();
        }
// ********************************************************************
// ㏈
// ********************************************************************
        finally
        {
            conn.shutdown();
            comm.out().println( "Good Bye!!" );
        }
        return;
    }
}
