/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.modules.panel;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.EditorUtil;
import net.sf.sqs_xml.editor.base.modules.panel.AbstractNodeEditorPanel;

public class SelectFormColsPanel
extends AbstractNodeEditorPanel {
    SpinnerNumberModel colsModel;
    int cols;

    public SelectFormColsPanel(AbstractNodeEditor editor) {
        super(editor);
        Box colsForm = new Box(0);
        colsForm.setBackground(this.getBackground());
        colsForm.setBorder(new TitledBorder(EditorUtil.LOWERED_BORDER, "\u30ec\u30a4\u30a2\u30a6\u30c8"));
        colsForm.add(this.createColsForm());
        this.add(colsForm);
        this.initSize();
    }

    private SpinnerNumberModel createColsModel() {
        this.cols = this.getEditor().intValueOf("@sqs:cols", 4);
        return new SpinnerNumberModel(this.cols, 1, 10, 1);
    }

    private JComponent createColsForm() {
        this.colsModel = this.createColsModel();
        JSpinner colsSpinner = new JSpinner(this.colsModel);
        Box colsForm = EditorUtil.createSpinnerForm("\u9078\u629e\u80a2\u3092\u6a2a\u306b\u4e26\u3079\u308b\u6570:", colsSpinner);
        colsForm.setPreferredSize(new Dimension(100, 16));
        colsSpinner.addChangeListener(this.getEditor().getUpdateListener());
        colsSpinner.addFocusListener(this.getEditor().getUpdateListener());
        if (this.getEditor().getSource().isReadOnly()) {
            colsSpinner.setEnabled(false);
        }
        return colsForm;
    }

    public int getPreferredHeight() {
        return 40;
    }

    public boolean updateNodeValue() {
        if (this.cols != (Integer)this.colsModel.getValue()) {
            this.getEditor().updateAttributeValue(".", "cols", "http://sqs.cmr.sfc.keio.ac.jp/2004/sqs", this.colsModel.getValue());
            return true;
        }
        return false;
    }
}

