/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import net.sf.sqs_xml.editor.sqs.source.SQSSource;
import net.sf.sqs_xml.editor.sqs.swing.SQSSourceEditorMediator;
import net.sf.sqs_xml.httpd.SourceEditorHttpd;
import net.sf.sqs_xml.swing.LoggerConsoleFrame;
import net.sf.sqs_xml.translator.logic.SQStoHTMLTranslator;
import net.sf.sqs_xml.translator.logic.SQStoPDFTranslator;
import net.sf.sqs_xml.translator.logic.SQStoPreviewTranslator;
import net.sf.sqs_xml.translator.logic.Translator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;
import net.sf.sqs_xml.util.BrowserLauncher;

public class ExportFileLogic {
    private SourceEditorMediator mediator;
    LoggerConsoleFrame logger;
    public static final int USER_SELECTION_MODE = -1;
    public static final int HTML_MODE = 0;
    public static final int HTML_PREVIEW_MODE = 1;
    public static final int PDF_MODE = 2;

    public ExportFileLogic(SourceEditorMediator mediator) {
        this.mediator = mediator;
    }

    private LoggerConsoleFrame createLogger() {
        final LoggerConsoleFrame logger = new LoggerConsoleFrame(String.valueOf(this.mediator.getTitle()) + " Log", "Cancel", "OK");
        logger.setFinished(false);
        logger.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                logger.setVisible(false);
                logger.setFinished(true);
            }
        });
        logger.info("start translation.");
        logger.setSize(400, 300);
        logger.setVisible(true);
        return logger;
    }

    public void export(BrowserLauncher launcher, int mode) throws TranslatorException, IOException {
        String suffix;
        File sourceFile = this.mediator.getCurrentTreePane().getSource().getFile();
        File tgtFile = null;
        if (mode == -1) {
            tgtFile = this.createSelectedFile(sourceFile, ".pdf");
        } else {
            suffix = this.getSuffix(mode);
            String tmpdir = System.getProperty("java.io.tmpdir");
            tgtFile = tmpdir != null && this.isBrowserAccessibleDirectory(tmpdir) ? this.createTemporaryFile(suffix) : this.createSelectedFile(sourceFile, suffix);
        }
        if (tgtFile != null) {
            mode = this.getMode(tgtFile);
            suffix = this.getSuffix(mode);
            String desc = this.getDescription(mode);
            this.export(launcher, this.createTranslator(mode), tgtFile, suffix, desc);
        }
    }

    private Translator createTranslator(int mode) throws TranslatorException {
        if (mode == 1) {
            return new SQStoPreviewTranslator();
        }
        if (mode == 0) {
            return new SQStoHTMLTranslator();
        }
        if (mode == 2) {
            return new SQStoPDFTranslator();
        }
        throw new RuntimeException("export mode error");
    }

    private int getMode(File file) {
        if (file.getName().endsWith("-preview.html")) {
            return 1;
        }
        if (file.getName().endsWith(".html")) {
            return 0;
        }
        if (file.getName().endsWith(".pdf")) {
            return 2;
        }
        throw new RuntimeException("export mode error");
    }

    private String getSuffix(int mode) {
        if (mode == 0) {
            return ".html";
        }
        if (mode == 1) {
            return "-preview.html";
        }
        if (mode == 2) {
            return ".pdf";
        }
        throw new RuntimeException("export mode error");
    }

    private String getDescription(int mode) {
        if (mode == 0) {
            return "HTML File";
        }
        if (mode == 1) {
            return "Preview HTML File";
        }
        if (mode == 2) {
            return "PDF File";
        }
        throw new RuntimeException("export mode error");
    }

    private boolean isBrowserAccessibleDirectory(String tmpdir) throws UnsupportedEncodingException {
        return URLEncoder.encode(tmpdir, "UTF-8").equals(URLEncoder.encode(tmpdir, "MS932"));
    }

    public synchronized void export(final BrowserLauncher launcher, final Translator translator, final File tgtFile, String suffix, String desc) throws TransformerFactoryConfigurationError {
        new Thread(){

            public void run() {
                try {
                    InputStream sqsInputStream = ExportFileLogic.this.createSQSInputStream();
                    BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tgtFile));
                    ExportFileLogic.this.translate(translator, outputStream, sqsInputStream, SQSSourceEditorMediator.BASEURI);
                    if (launcher != null && ExportFileLogic.this.isBrowserAccessibleDirectory(tgtFile.getAbsolutePath())) {
                        launcher.showDocument(SourceEditorHttpd.getSingleton().getURL(tgtFile));
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    ExportFileLogic.this.mediator.createSourceEditorMenuBarMediator().showError(ex, "\u30a8\u30e9\u30fc");
                }
                catch (TranslatorException ex) {
                    ex.printStackTrace();
                    ExportFileLogic.this.mediator.createSourceEditorMenuBarMediator().showError(ex, "\u30a8\u30e9\u30fc");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ExportFileLogic.this.mediator.createSourceEditorMenuBarMediator().showError(ex, "\u30a8\u30e9\u30fc");
                }
            }
        }.start();
    }

    private File createTemporaryFile(String suffix) throws IOException {
        File tgtFile = File.createTempFile("sqs-tmp-", suffix);
        tgtFile.deleteOnExit();
        return tgtFile;
    }

    private File createSelectedFile(File sourceFile, String suffix) {
        return this.mediator.getMenuBarMediator().exportFile(sourceFile, suffix);
    }

    private InputStream createSQSInputStream() throws IOException {
        return ((SQSSource)this.mediator.getSourceEditorTabbedPane().getCurrentEditingSource()).createInputStream();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void translate(Translator translator, OutputStream tmpOutputStream, InputStream sqsInputStream, String baseURI) throws TranslatorException {
        this.mediator.getToolBar().setEnabled(false);
        LoggerConsoleFrame logger = this.createLogger();
        try {
            try {
                translator.translate(sqsInputStream, new TranslatorResource(logger), tmpOutputStream, baseURI);
            }
            catch (TranslatorException ex) {
                if (!(ex.getCause() instanceof TransformerException)) throw ex;
                this.showTransformerException(logger, ex);
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.tearOffTranslation(tmpOutputStream, sqsInputStream, logger);
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.tearOffTranslation(tmpOutputStream, sqsInputStream, logger);
            return;
        }
    }

    private void tearOffTranslation(OutputStream tmpOutputStream, InputStream sqsInputStream, LoggerConsoleFrame logger) {
        this.mediator.getToolBar().setEnabled(true);
        logger.setFinished(true);
        if (!logger.hasError()) {
            logger.setVisible(false);
        }
        try {
            sqsInputStream.close();
            tmpOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void showTransformerException(LoggerConsoleFrame logger, TranslatorException ex) {
        TransformerException cause = (TransformerException)ex.getCause();
        logger.error(cause.getMessageAndLocation());
        JOptionPane.showMessageDialog(this.mediator.getFrame(), new Object[]{"\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u304c\u6b63\u3057\u304f\u306a\u3044\u305f\u3081\uff0c\u5909\u63db\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f:", "\u4f4d\u7f6e:" + cause.getLocationAsString(), "\u5185\u5bb9:" + cause.getLocalizedMessage()}, "File Error", 0);
    }
}

