/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import net.sf.sqs_xml.editor.base.source.Source;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMenuBarMediator;
import net.sf.sqs_xml.editor.base.swing.SuffixBasedFileChooser;
import net.sf.sqs_xml.editor.sqs.swing.ExportFileLogic;
import net.sf.sqs_xml.editor.sqs.swing.SQSFileChooser;
import net.sf.sqs_xml.editor.sqs.swing.SQSSourceEditorMediator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.util.FileUtil;

public class SQSSourceEditorMenuBarMediator
extends SourceEditorMenuBarMediator {
    static final String[] TEMPLATE_LABELS = new String[]{"\u70b9\u691c\u578b\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8", "\u8ab2\u984c\u767a\u898b\u578b\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8", "\u8ab2\u984c\u6539\u5584\u578b\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8", "\u901a\u5e38\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8"};
    static final String[][] TEMPLATE_ITEMS = new String[][]{{"[\u70b9\u691c\u6d3b\u52d5] \u5b9f\u73fe\u5ea6", "[\u70b9\u691c\u6d3b\u52d5] \u9069\u5408\u5ea6", "[\u70b9\u691c\u6d3b\u52d5] \u91cd\u8981\u5ea6", "[\u70b9\u691c\u6d3b\u52d5] \u6e80\u8db3\u5ea6"}, {"[\u8ab2\u984c\u767a\u898b\u6d3b\u52d5] \u91cd\u8981\u5ea6-\u6e80\u8db3\u5ea6", "[\u8ab2\u984c\u767a\u898b\u6d3b\u52d5] \u91cd\u8981\u5ea6-\u5b9f\u73fe\u5ea6"}, {"[\u8ab2\u984c\u6539\u5584\u6d3b\u52d5]\u3081\u3056\u305d\u3046\u5024-\u5206\u62c5\u5024"}};
    static final String[][] TEMPLATE_FILES = new String[][]{{"check-actualization.sqs", "check-agreement.sqs", "check-importance.sqs", "check-satisfaction.sqs"}, {"discover-importance-satisfaction.sqs", "discover-importance-actualization.sqs"}, {"simple.sqs"}, {"simple.sqs"}};
    static final boolean[][] TEMPLATE_READONLY = new boolean[][]{new boolean[4], new boolean[2], new boolean[1], new boolean[1]};
    static final boolean[][] TEMPLATE_ENABLED = new boolean[][]{{true, true, true, true}, {true, true}, new boolean[1], {true}};
    ExportFileLogic exportFileLogic = new ExportFileLogic(this.getMediator());
    JFileChooser exportFileChooser = SQSFileChooser.createExportFileChooser();

    public SQSSourceEditorMenuBarMediator(SQSSourceEditorMediator mediator) {
        super(mediator);
    }

    public ExportFileLogic getExportFileLogic() {
        return this.exportFileLogic;
    }

    public JMenu createNewMenuItem() {
        JMenu newMenu = new JMenu();
        newMenu.setText("\u65b0\u898f\u4f5c\u6210");
        newMenu.add(this.createNewMenu(0));
        newMenu.add(this.createNewMenu(1));
        newMenu.add(this.createNewMenu(2));
        newMenu.add(new JSeparator());
        newMenu.add(this.createNewMenuItem(3, -1));
        return newMenu;
    }

    public JMenuItem createExportMenuItem() {
        JMenuItem exportMenuItem = new JMenuItem();
        exportMenuItem.setText("\u66f8\u304d\u51fa\u3057\u2026");
        exportMenuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    try {
                        SQSSourceEditorMenuBarMediator.this.getMediator().getFrame().setCursor(Cursor.getPredefinedCursor(3));
                        SQSSourceEditorMenuBarMediator.this.exportFileLogic.export(null, -1);
                    }
                    catch (TranslatorException ex) {
                        SQSSourceEditorMenuBarMediator.this.showError(ex, "\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
                    }
                    catch (IOException ex) {
                        SQSSourceEditorMenuBarMediator.this.showError(ex, "\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    SQSSourceEditorMenuBarMediator.this.getMediator().getFrame().setCursor(Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                SQSSourceEditorMenuBarMediator.this.getMediator().getFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        return exportMenuItem;
    }

    public File exportFile(File sourceFile, String suffix) {
        File tgtFile;
        if (sourceFile != null) {
            if (this.exportFileChooser.getSelectedFile() == null || !this.exportFileChooser.getSelectedFile().getName().endsWith(suffix)) {
                tgtFile = new File(String.valueOf(FileUtil.getBasename(sourceFile)) + suffix);
                this.exportFileChooser.setSelectedFile(tgtFile);
            }
        } else {
            this.exportFileChooser.setSelectedFile(new File(this.exportFileChooser.getCurrentDirectory() + File.separator + "newfile" + suffix));
        }
        while (true) {
            String selectedName;
            int state;
            if ((state = this.exportFileChooser.showSaveDialog(this.getMediator().getFrame())) != 0) {
                return null;
            }
            tgtFile = this.exportFileChooser.getSelectedFile();
            if (tgtFile != null && ((selectedName = tgtFile.getName().toLowerCase()).endsWith(".pdf") || selectedName.endsWith(".html"))) break;
            JOptionPane.showMessageDialog(this.getMediator().getFrame(), new String[]{"\u30d5\u30a1\u30a4\u30eb\u306e\u62e1\u5f35\u5b50\u306f\u300c.pdf\u300d\u307e\u305f\u306f\u300c.html\u300d\u3067\u306a\u3051\u308c\u3070\u3044\u3051\u307e\u305b\u3093\uff0e", "\u73fe\u5728\u306e\u30d5\u30a1\u30a4\u30eb\u540d: " + tgtFile}, "\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u30a8\u30e9\u30fc", 0);
        }
        if (this.avoidOverwriteFile(tgtFile)) {
            return null;
        }
        return tgtFile;
    }

    public JMenu createNewMenu(int index) {
        JMenu newMenu = new JMenu();
        newMenu.setText(TEMPLATE_LABELS[index]);
        int i = 0;
        while (i < TEMPLATE_ITEMS[index].length) {
            newMenu.add(this.createNewMenuItem(index, i));
            ++i;
        }
        return newMenu;
    }

    public JMenuItem createNewMenuItem(int index, int i) {
        JMenuItem newMenuItem = new JMenuItem();
        String label = null;
        String filename = null;
        boolean readonly = false;
        boolean enabled = true;
        if (i >= 0) {
            label = TEMPLATE_ITEMS[index][i];
            filename = TEMPLATE_FILES[index][i];
            readonly = TEMPLATE_READONLY[index][i];
            enabled = TEMPLATE_ENABLED[index][i];
        } else {
            label = TEMPLATE_LABELS[index];
            filename = TEMPLATE_FILES[index][0];
            readonly = TEMPLATE_READONLY[index][0];
            enabled = TEMPLATE_ENABLED[index][0];
        }
        newMenuItem.setText(label);
        newMenuItem.setEnabled(enabled);
        this.addActionListener(newMenuItem, filename, readonly, label);
        return newMenuItem;
    }

    private void addActionListener(JMenuItem newMenuItem, final String filename, final boolean readonly, final String title) {
        newMenuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent ev) {
                try {
                    try {
                        SQSSourceEditorMenuBarMediator.this.getMediator().getFrame().setCursor(Cursor.getPredefinedCursor(3));
                        SQSSourceEditorMenuBarMediator.this.getMediator().getMenuBarMediator().open(new URL(String.valueOf(SQSSourceEditorMediator.BASEURI) + filename), readonly, title);
                        SQSSourceEditorMenuBarMediator.this.updateMenu();
                    }
                    catch (MalformedURLException ignore) {
                        ignore.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    SQSSourceEditorMenuBarMediator.this.getMediator().getFrame().setCursor(Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                SQSSourceEditorMenuBarMediator.this.getMediator().getFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public JMenuItem createAboutMenuItem() {
        JMenuItem aboutMenuItem = new JMenuItem();
        aboutMenuItem.setText("MarkReader\u306b\u3064\u3044\u3066");
        return aboutMenuItem;
    }

    public JFileChooser createSaveAsFileChoser(Source currentSource) {
        SuffixBasedFileChooser saveAsFileChooser = SQSFileChooser.createSaveSQSFileChooser(currentSource.getFile());
        return saveAsFileChooser;
    }

    public JFileChooser createOpenFileChooser(File defaultFolder) {
        SuffixBasedFileChooser openFileChooser = SQSFileChooser.createOpenSQSSourceChooser(defaultFolder);
        return openFileChooser;
    }
}

