/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TextOverlayImageIcon
extends ImageIcon {
    String label;
    Icon icon;
    Font font;
    int xoffset;

    public TextOverlayImageIcon(URL url, String label, int size, int xoffset) {
        super(url);
        this.label = label;
        if (label != null) {
            this.font = new Font("Serif", 0, size);
            this.xoffset = xoffset;
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        super.paintIcon(c, g, x, y);
        if (this.label != null) {
            FontMetrics fm = g.getFontMetrics();
            int offsetX = (this.getIconWidth() - fm.stringWidth(this.label)) / 2 + this.xoffset;
            int offsetY = (this.getIconHeight() - fm.getHeight()) / 2 - 2;
            g.setColor(Color.black);
            g.setFont(this.font);
            g.drawString(this.label, x + offsetX, y + offsetY + fm.getHeight());
        }
    }
}

