/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class LogFactory {
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    protected static Hashtable factories = new Hashtable();
    static /* synthetic */ Class class$org$apache$commons$logging$LogFactory;
    static /* synthetic */ Class class$java$lang$Thread;

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public static LogFactory getFactory() throws LogConfigurationException {
        String factoryClass2;
        Properties props;
        LogFactory factory;
        ClassLoader contextClassLoader;
        block20: {
            contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public final Object run() {
                    return LogFactory.getContextClassLoader();
                }
            });
            factory = LogFactory.getCachedFactory(contextClassLoader);
            if (factory != null) {
                return factory;
            }
            props = null;
            try {
                InputStream stream = LogFactory.getResourceAsStream(contextClassLoader, FACTORY_PROPERTIES);
                if (stream != null) {
                    props = new Properties();
                    props.load(stream);
                    stream.close();
                }
            }
            catch (IOException e) {
            }
            catch (SecurityException factoryClass2) {
                // empty catch block
            }
            try {
                factoryClass2 = System.getProperty(FACTORY_PROPERTY);
                if (factoryClass2 != null) {
                    factory = LogFactory.newFactory(factoryClass2, contextClassLoader);
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (factory == null) {
                try {
                    BufferedReader rd;
                    InputStream is = LogFactory.getResourceAsStream(contextClassLoader, SERVICE_ID);
                    if (is == null) break block20;
                    try {
                        rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        rd = new BufferedReader(new InputStreamReader(is));
                    }
                    String factoryClassName = rd.readLine();
                    rd.close();
                    if (factoryClassName != null && !"".equals(factoryClassName)) {
                        factory = LogFactory.newFactory(factoryClassName, contextClassLoader);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (factory == null && props != null && (factoryClass2 = props.getProperty(FACTORY_PROPERTY)) != null) {
            factory = LogFactory.newFactory(factoryClass2, contextClassLoader);
        }
        if (factory == null) {
            Class clazz = class$org$apache$commons$logging$LogFactory;
            if (clazz == null) {
                clazz = class$org$apache$commons$logging$LogFactory = LogFactory.class("[Lorg.apache.commons.logging.LogFactory;", false);
            }
            factory = LogFactory.newFactory(FACTORY_DEFAULT, clazz.getClassLoader());
        }
        if (factory != null) {
            LogFactory.cacheFactory(contextClassLoader, factory);
            if (props != null) {
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = props.getProperty(name);
                    factory.setAttribute(name, value);
                }
            }
        }
        return factory;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void release(ClassLoader classLoader) {
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            LogFactory factory = (LogFactory)factories.get(classLoader);
            if (factory != null) {
                factory.release();
                factories.remove(classLoader);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void releaseAll() {
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            Enumeration elements = factories.elements();
            while (true) {
                if (!elements.hasMoreElements()) {
                    factories.clear();
                    return;
                }
                LogFactory element = (LogFactory)elements.nextElement();
                element.release();
            }
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            Class clazz = class$java$lang$Thread;
            if (clazz == null) {
                clazz = class$java$lang$Thread = LogFactory.class("[Ljava.lang.Thread;", false);
            }
            Method method = clazz.getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException e) {
                throw new LogConfigurationException("Unexpected IllegalAccessException", e);
            }
            catch (InvocationTargetException e) {
                if (!(e.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException("Unexpected InvocationTargetException", e.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException e) {
            Class clazz = class$org$apache$commons$logging$LogFactory;
            if (clazz == null) {
                clazz = class$org$apache$commons$logging$LogFactory = LogFactory.class("[Lorg.apache.commons.logging.LogFactory;", false);
            }
            classLoader = clazz.getClassLoader();
        }
        return classLoader;
    }

    private static final LogFactory getCachedFactory(ClassLoader contextClassLoader) {
        LogFactory factory = null;
        if (contextClassLoader != null) {
            factory = (LogFactory)factories.get(contextClassLoader);
        }
        return factory;
    }

    private static final void cacheFactory(ClassLoader classLoader, LogFactory factory) {
        if (classLoader != null && factory != null) {
            factories.put(classLoader, factory);
        }
    }

    protected static LogFactory newFactory(final String factoryClass, final ClassLoader classLoader) throws LogConfigurationException {
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                Class<?> logFactoryClass = null;
                try {
                    block15: {
                        if (classLoader != null) {
                            try {
                                logFactoryClass = classLoader.loadClass(factoryClass);
                                return (LogFactory)logFactoryClass.newInstance();
                            }
                            catch (ClassNotFoundException ex) {
                                Class clazz = class$org$apache$commons$logging$LogFactory;
                                if (clazz == null) {
                                    clazz = class$org$apache$commons$logging$LogFactory = LogFactory.class("[Lorg.apache.commons.logging.LogFactory;", false);
                                }
                                if (classLoader == clazz.getClassLoader()) {
                                    throw ex;
                                }
                            }
                            catch (NoClassDefFoundError e) {
                                Class clazz = class$org$apache$commons$logging$LogFactory;
                                if (clazz == null) {
                                    clazz = class$org$apache$commons$logging$LogFactory = LogFactory.class("[Lorg.apache.commons.logging.LogFactory;", false);
                                }
                                if (classLoader == clazz.getClassLoader()) {
                                    throw e;
                                }
                            }
                            catch (ClassCastException e) {
                                Class clazz = class$org$apache$commons$logging$LogFactory;
                                if (clazz == null) {
                                    clazz = class$org$apache$commons$logging$LogFactory = LogFactory.class("[Lorg.apache.commons.logging.LogFactory;", false);
                                }
                                if (classLoader != clazz.getClassLoader()) break block15;
                                throw e;
                            }
                        }
                    }
                    logFactoryClass = Class.forName(factoryClass);
                    return (LogFactory)logFactoryClass.newInstance();
                }
                catch (Exception e) {
                    if (logFactoryClass != null) {
                        Class clazz = class$org$apache$commons$logging$LogFactory;
                        if (clazz == null) {
                            clazz = class$org$apache$commons$logging$LogFactory = LogFactory.class("[Lorg.apache.commons.logging.LogFactory;", false);
                        }
                        if (!clazz.isAssignableFrom(logFactoryClass)) {
                            return new LogConfigurationException("The chosen LogFactory implementation does not extend LogFactory. Please check your configuration.", e);
                        }
                    }
                    return new LogConfigurationException(e);
                }
            }
        });
        if (result instanceof LogConfigurationException) {
            throw (LogConfigurationException)result;
        }
        return (LogFactory)result;
    }

    private static final InputStream getResourceAsStream(final ClassLoader loader, final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                if (loader != null) {
                    return loader.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected LogFactory() {
    }
}

