/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.TTFDirTabEntry;
import org.apache.fop.fonts.TTFFile;
import org.apache.fop.messaging.MessageHandler;

public class TTFSubSetFile
extends TTFFile {
    byte[] output = null;
    int realSize = 0;
    int currentPos = 0;
    int cvtDirOffset = 0;
    int fpgmDirOffset = 0;
    int glyfDirOffset = 0;
    int headDirOffset = 0;
    int hheaDirOffset = 0;
    int hmtxDirOffset = 0;
    int locaDirOffset = 0;
    int maxpDirOffset = 0;
    int prepDirOffset = 0;
    int checkSumAdjustmentOffset = 0;
    int locaOffset = 0;

    private void init(int size) {
        this.output = new byte[size];
        this.realSize = 0;
        this.currentPos = 0;
    }

    private void createDirectory() {
        int numTables = 9;
        this.writeByte((byte)0);
        this.writeByte((byte)1);
        this.writeByte((byte)0);
        this.writeByte((byte)0);
        this.realSize += 4;
        this.writeUShort(numTables);
        this.realSize += 2;
        int maxPow = this.maxPow2(numTables);
        int searchRange = maxPow * 16;
        this.writeUShort(searchRange);
        this.realSize += 2;
        this.writeUShort(maxPow);
        this.realSize += 2;
        this.writeUShort(numTables * 16 - searchRange);
        this.realSize += 2;
        this.writeString("cvt ");
        this.cvtDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        if (this.hasFpgm()) {
            this.writeString("fpgm");
            this.fpgmDirOffset = this.currentPos;
            this.currentPos += 12;
            this.realSize += 16;
        }
        this.writeString("glyf");
        this.glyfDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("head");
        this.headDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("hhea");
        this.hheaDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("hmtx");
        this.hmtxDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("loca");
        this.locaDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("maxp");
        this.maxpDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
        this.writeString("prep");
        this.prepDirOffset = this.currentPos;
        this.currentPos += 12;
        this.realSize += 16;
    }

    private void createCvt(FontFileReader in) throws IOException {
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get("cvt ");
        if (entry != null) {
            this.pad4();
            this.seek_tab(in, "cvt ", 0L);
            System.arraycopy(in.getBytes((int)entry.offset, (int)entry.length), 0, this.output, this.currentPos, (int)entry.length);
            int checksum = this.getCheckSum(this.currentPos, (int)entry.length);
            this.writeULong(this.cvtDirOffset, checksum);
            this.writeULong(this.cvtDirOffset + 4, this.currentPos);
            this.writeULong(this.cvtDirOffset + 8, (int)entry.length);
            this.currentPos += (int)entry.length;
            this.realSize += (int)entry.length;
        } else {
            throw new IOException("Can't find cvt table");
        }
    }

    private boolean hasFpgm() {
        return this.dirTabs.get("fpgm") != null;
    }

    private void createFpgm(FontFileReader in) throws IOException {
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get("fpgm");
        if (entry != null) {
            this.pad4();
            this.seek_tab(in, "fpgm", 0L);
            System.arraycopy(in.getBytes((int)entry.offset, (int)entry.length), 0, this.output, this.currentPos, (int)entry.length);
            int checksum = this.getCheckSum(this.currentPos, (int)entry.length);
            this.writeULong(this.fpgmDirOffset, checksum);
            this.writeULong(this.fpgmDirOffset + 4, this.currentPos);
            this.writeULong(this.fpgmDirOffset + 8, (int)entry.length);
            this.currentPos += (int)entry.length;
            this.realSize += (int)entry.length;
        }
    }

    private void createLoca(int size) throws IOException {
        this.pad4();
        this.locaOffset = this.currentPos;
        this.writeULong(this.locaDirOffset + 4, this.currentPos);
        this.writeULong(this.locaDirOffset + 8, size * 4 + 4);
        this.currentPos += size * 4 + 4;
        this.realSize += size * 4 + 4;
    }

    private void createMaxp(FontFileReader in, int size) throws IOException {
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get("maxp");
        if (entry != null) {
            this.pad4();
            this.seek_tab(in, "maxp", 0L);
            System.arraycopy(in.getBytes((int)entry.offset, (int)entry.length), 0, this.output, this.currentPos, (int)entry.length);
            this.writeUShort(this.currentPos + 4, size);
            int checksum = this.getCheckSum(this.currentPos, (int)entry.length);
            this.writeULong(this.maxpDirOffset, checksum);
            this.writeULong(this.maxpDirOffset + 4, this.currentPos);
            this.writeULong(this.maxpDirOffset + 8, (int)entry.length);
            this.currentPos += (int)entry.length;
            this.realSize += (int)entry.length;
        } else {
            throw new IOException("Can't find maxp table");
        }
    }

    private void createPrep(FontFileReader in) throws IOException {
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get("prep");
        if (entry != null) {
            this.pad4();
            this.seek_tab(in, "prep", 0L);
            System.arraycopy(in.getBytes((int)entry.offset, (int)entry.length), 0, this.output, this.currentPos, (int)entry.length);
            int checksum = this.getCheckSum(this.currentPos, (int)entry.length);
            this.writeULong(this.prepDirOffset, checksum);
            this.writeULong(this.prepDirOffset + 4, this.currentPos);
            this.writeULong(this.prepDirOffset + 8, (int)entry.length);
            this.currentPos += (int)entry.length;
            this.realSize += (int)entry.length;
        } else {
            throw new IOException("Can't find prep table");
        }
    }

    private void createHhea(FontFileReader in, int size) throws IOException {
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get("hhea");
        if (entry != null) {
            this.pad4();
            this.seek_tab(in, "hhea", 0L);
            System.arraycopy(in.getBytes((int)entry.offset, (int)entry.length), 0, this.output, this.currentPos, (int)entry.length);
            this.writeUShort((int)entry.length + this.currentPos - 2, size);
            int checksum = this.getCheckSum(this.currentPos, (int)entry.length);
            this.writeULong(this.hheaDirOffset, checksum);
            this.writeULong(this.hheaDirOffset + 4, this.currentPos);
            this.writeULong(this.hheaDirOffset + 8, (int)entry.length);
            this.currentPos += (int)entry.length;
            this.realSize += (int)entry.length;
        } else {
            throw new IOException("Can't find hhea table");
        }
    }

    private void createHead(FontFileReader in) throws IOException {
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get("head");
        if (entry != null) {
            this.pad4();
            this.seek_tab(in, "head", 0L);
            System.arraycopy(in.getBytes((int)entry.offset, (int)entry.length), 0, this.output, this.currentPos, (int)entry.length);
            this.checkSumAdjustmentOffset = this.currentPos + 8;
            this.output[this.currentPos + 8] = 0;
            this.output[this.currentPos + 9] = 0;
            this.output[this.currentPos + 10] = 0;
            this.output[this.currentPos + 11] = 0;
            this.output[this.currentPos + 50] = 0;
            this.output[this.currentPos + 51] = 1;
            int checksum = this.getCheckSum(this.currentPos, (int)entry.length);
            this.writeULong(this.headDirOffset, checksum);
            this.writeULong(this.headDirOffset + 4, this.currentPos);
            this.writeULong(this.headDirOffset + 8, (int)entry.length);
            this.currentPos += (int)entry.length;
            this.realSize += (int)entry.length;
        } else {
            throw new IOException("Can't find head table");
        }
    }

    private void createGlyf(FontFileReader in, Map glyphs) throws IOException {
        int checksum;
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get("glyf");
        int size = 0;
        int start = 0;
        int endOffset = 0;
        if (entry != null) {
            this.pad4();
            start = this.currentPos;
            int[] origIndexes = new int[glyphs.size()];
            Iterator e = glyphs.keySet().iterator();
            while (e.hasNext()) {
                Integer origIndex = (Integer)e.next();
                Integer subsetIndex = (Integer)glyphs.get(origIndex);
                origIndexes[subsetIndex.intValue()] = origIndex;
            }
            int i = 0;
            while (i < origIndexes.length) {
                int glyphLength = 0;
                int nextOffset = 0;
                int origGlyphIndex = origIndexes[i];
                nextOffset = origGlyphIndex >= this.mtx_tab.length - 1 ? (int)this.lastLoca : (int)this.mtx_tab[origGlyphIndex + 1].offset;
                glyphLength = nextOffset - (int)this.mtx_tab[origGlyphIndex].offset;
                System.arraycopy(in.getBytes((int)entry.offset + (int)this.mtx_tab[origGlyphIndex].offset, glyphLength), 0, this.output, this.currentPos, glyphLength);
                this.writeULong(this.locaOffset + i * 4, this.currentPos - start);
                if (this.currentPos - start + glyphLength > endOffset) {
                    endOffset = this.currentPos - start + glyphLength;
                }
                this.currentPos += glyphLength;
                this.realSize += glyphLength;
                ++i;
            }
            size = this.currentPos - start;
            checksum = this.getCheckSum(start, size);
            this.writeULong(this.glyfDirOffset, checksum);
            this.writeULong(this.glyfDirOffset + 4, start);
            this.writeULong(this.glyfDirOffset + 8, size);
            this.currentPos += 12;
            this.realSize += 12;
        } else {
            throw new IOException("Can't find glyf table");
        }
        this.writeULong(this.locaOffset + glyphs.size() * 4, endOffset);
        checksum = this.getCheckSum(this.locaOffset, glyphs.size() * 4 + 4);
        this.writeULong(this.locaDirOffset, checksum);
    }

    private void createHmtx(FontFileReader in, Map glyphs) throws IOException {
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get("hmtx");
        int longHorMetricSize = glyphs.size() * 2;
        int leftSideBearingSize = glyphs.size() * 2;
        int hmtxSize = longHorMetricSize + leftSideBearingSize;
        if (entry != null) {
            this.pad4();
            int offset = (int)entry.offset;
            Iterator e = glyphs.keySet().iterator();
            while (e.hasNext()) {
                Integer origIndex = (Integer)e.next();
                Integer subsetIndex = (Integer)glyphs.get(origIndex);
                this.writeUShort(this.currentPos + subsetIndex * 4, this.mtx_tab[origIndex.intValue()].wx);
                this.writeUShort(this.currentPos + subsetIndex * 4 + 2, this.mtx_tab[origIndex.intValue()].lsb);
            }
            int checksum = this.getCheckSum(this.currentPos, hmtxSize);
            this.writeULong(this.hmtxDirOffset, checksum);
            this.writeULong(this.hmtxDirOffset + 4, this.currentPos);
            this.writeULong(this.hmtxDirOffset + 8, hmtxSize);
            this.currentPos += hmtxSize;
            this.realSize += hmtxSize;
        } else {
            throw new IOException("Can't find hmtx table");
        }
    }

    private List getIncludedGlyphs(FontFileReader in, int glyphOffset, Integer glyphIdx) throws IOException {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.add(glyphIdx);
        int offset = glyphOffset + (int)this.mtx_tab[glyphIdx.intValue()].offset + 10;
        Integer compositeIdx = null;
        int flags = 0;
        boolean moreComposites = true;
        while (moreComposites) {
            flags = in.readTTFUShort(offset);
            compositeIdx = new Integer(in.readTTFUShort(offset + 2));
            ret.add(compositeIdx);
            offset += 4;
            offset = (flags & 1) > 0 ? (offset += 4) : (offset += 2);
            if ((flags & 8) > 0) {
                offset += 2;
            } else if ((flags & 0x40) > 0) {
                offset += 4;
            } else if ((flags & 0x80) > 0) {
                offset += 8;
            }
            moreComposites = (flags & 0x20) > 0;
        }
        return ret;
    }

    private void remapComposite(FontFileReader in, Map glyphs, int glyphOffset, Integer glyphIdx) throws IOException {
        int offset = glyphOffset + (int)this.mtx_tab[glyphIdx.intValue()].offset + 10;
        Integer compositeIdx = null;
        int flags = 0;
        boolean moreComposites = true;
        while (moreComposites) {
            flags = in.readTTFUShort(offset);
            compositeIdx = new Integer(in.readTTFUShort(offset + 2));
            Integer newIdx = (Integer)glyphs.get(compositeIdx);
            if (newIdx == null) {
                MessageHandler.error("An embedded font contains bad glyph data. Characters might not display correctly.");
                moreComposites = false;
                continue;
            }
            in.writeTTFUShort(offset + 2, newIdx);
            offset += 4;
            offset = (flags & 1) > 0 ? (offset += 4) : (offset += 2);
            if ((flags & 8) > 0) {
                offset += 2;
            } else if ((flags & 0x40) > 0) {
                offset += 4;
            } else if ((flags & 0x80) > 0) {
                offset += 8;
            }
            moreComposites = (flags & 0x20) > 0;
        }
    }

    private void scanGlyphs(FontFileReader in, Map glyphs) throws IOException {
        TTFDirTabEntry entry = (TTFDirTabEntry)this.dirTabs.get("glyf");
        HashMap<Integer, Integer> newComposites = null;
        HashMap allComposites = new HashMap();
        int newIndex = glyphs.size();
        if (entry != null) {
            while (newComposites == null || newComposites.size() > 0) {
                newComposites = new HashMap<Integer, Integer>();
                Iterator e = glyphs.keySet().iterator();
                while (e.hasNext()) {
                    Integer origIndex = (Integer)e.next();
                    if (in.readTTFShort(entry.offset + this.mtx_tab[origIndex.intValue()].offset) >= 0) continue;
                    allComposites.put(origIndex, glyphs.get(origIndex));
                    List composites = this.getIncludedGlyphs(in, (int)entry.offset, origIndex);
                    int i = 0;
                    while (i < composites.size()) {
                        Integer cIdx = (Integer)composites.get(i);
                        if (glyphs.get(cIdx) == null && newComposites.get(cIdx) == null) {
                            newComposites.put(cIdx, new Integer(newIndex));
                            ++newIndex;
                        }
                        ++i;
                    }
                }
                Iterator m = newComposites.keySet().iterator();
                while (m.hasNext()) {
                    Integer im = (Integer)m.next();
                    glyphs.put(im, newComposites.get(im));
                }
            }
            Iterator ce = allComposites.keySet().iterator();
            while (ce.hasNext()) {
                this.remapComposite(in, glyphs, (int)entry.offset, (Integer)ce.next());
            }
        } else {
            throw new IOException("Can't find glyph table");
        }
    }

    public byte[] readFont(FontFileReader in, String name, Map glyphs) throws IOException {
        if (!this.checkTTC(in, name, false)) {
            throw new IOException("Failed to read font");
        }
        this.output = new byte[in.getFileSize()];
        this.readDirTabs(in);
        this.readFontHeader(in);
        this.getNumGlyphs(in);
        this.readHorizontalHeader(in);
        this.readHorizontalMetrics(in);
        this.readIndexToLocation(in);
        this.scanGlyphs(in, glyphs);
        this.createDirectory();
        this.createHead(in);
        this.createHhea(in, glyphs.size());
        this.createHmtx(in, glyphs);
        this.createMaxp(in, glyphs.size());
        try {
            this.createCvt(in);
        }
        catch (IOException ex) {
            MessageHandler.errorln("TrueType warning: " + ex.getMessage());
        }
        try {
            this.createFpgm(in);
        }
        catch (IOException ex) {
            MessageHandler.errorln("TrueType warning: " + ex.getMessage());
        }
        try {
            this.createPrep(in);
        }
        catch (IOException ex) {
            MessageHandler.errorln("TrueType warning: " + ex.getMessage());
        }
        try {
            this.createLoca(glyphs.size());
        }
        catch (IOException ex) {
            MessageHandler.errorln("TrueType warning: " + ex.getMessage());
        }
        try {
            this.createGlyf(in, glyphs);
        }
        catch (IOException ex) {
            MessageHandler.errorln("TrueType warning: " + ex.getMessage());
        }
        this.pad4();
        this.createCheckSumAdjustment();
        byte[] ret = new byte[this.realSize];
        System.arraycopy(this.output, 0, ret, 0, this.realSize);
        return ret;
    }

    private int writeString(String str) {
        int length = 0;
        try {
            byte[] buf = str.getBytes("ISO-8859-1");
            System.arraycopy(buf, 0, this.output, this.currentPos, buf.length);
            length = buf.length;
            this.currentPos += length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return length;
    }

    private void writeByte(byte b) {
        this.output[this.currentPos++] = b;
    }

    private void writeUShort(int s) {
        byte b1 = (byte)(s >> 8 & 0xFF);
        byte b2 = (byte)(s & 0xFF);
        this.writeByte(b1);
        this.writeByte(b2);
    }

    private void writeUShort(int pos, int s) {
        byte b1 = (byte)(s >> 8 & 0xFF);
        byte b2 = (byte)(s & 0xFF);
        this.output[pos] = b1;
        this.output[pos + 1] = b2;
    }

    private void writeULong(int s) {
        byte b1 = (byte)(s >> 24 & 0xFF);
        byte b2 = (byte)(s >> 16 & 0xFF);
        byte b3 = (byte)(s >> 8 & 0xFF);
        byte b4 = (byte)(s & 0xFF);
        this.writeByte(b1);
        this.writeByte(b2);
        this.writeByte(b3);
        this.writeByte(b4);
    }

    private void writeULong(int pos, int s) {
        byte b1 = (byte)(s >> 24 & 0xFF);
        byte b2 = (byte)(s >> 16 & 0xFF);
        byte b3 = (byte)(s >> 8 & 0xFF);
        byte b4 = (byte)(s & 0xFF);
        this.output[pos] = b1;
        this.output[pos + 1] = b2;
        this.output[pos + 2] = b3;
        this.output[pos + 3] = b4;
    }

    private short readShort(int pos) {
        int ret = this.readUShort(pos);
        return (short)ret;
    }

    private int readUShort(int pos) {
        int ret = this.output[pos];
        if (ret < 0) {
            ret += 256;
        }
        ret <<= 8;
        ret = this.output[pos + 1] < 0 ? (ret |= this.output[pos + 1] + 256) : (ret |= this.output[pos + 1]);
        return ret;
    }

    private void pad4() {
        int padSize = this.currentPos % 4;
        int i = 0;
        while (i < padSize) {
            this.output[this.currentPos++] = 0;
            ++this.realSize;
            ++i;
        }
    }

    private int maxPow2(int max) {
        int i = 0;
        while (Math.pow(2.0, i) < (double)max) {
            ++i;
        }
        return i - 1;
    }

    private int log2(int num) {
        return (int)(Math.log(num) / Math.log(2.0));
    }

    private int getCheckSum(int start, int size) {
        return (int)this.getLongCheckSum(start, size);
    }

    private long getLongCheckSum(int start, int size) {
        int remainder = size % 4;
        if (remainder != 0) {
            size += remainder;
        }
        long sum = 0L;
        int i = 0;
        while (i < size) {
            int l = this.output[start + i] << 24;
            l += this.output[start + i + 1] << 16;
            l += this.output[start + i + 2] << 16;
            if ((sum += (long)(l += this.output[start + i + 3] << 16)) > -1L) {
                sum -= -1L;
            }
            i += 4;
        }
        return sum;
    }

    private void createCheckSumAdjustment() {
        long sum = this.getLongCheckSum(0, this.realSize);
        int checksum = (int)(-1313820742L - sum);
        this.writeULong(this.checkSumAdjustmentOffset, checksum);
    }
}

