/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.fonts.type1.PFMFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PFMReader
extends AbstractLogEnabled {
    private static String[] parseArguments(Map options, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    options.put(args[i], args[i + 1]);
                    ++i;
                } else {
                    options.put(args[i], "");
                }
            } else {
                arguments.add(args[i]);
            }
            ++i;
        }
        String[] argStrings = new String[arguments.size()];
        arguments.toArray(argStrings);
        return argStrings;
    }

    private void displayUsage() {
        this.getLogger().info(" java org.apache.fop.fonts.apps.PFMReader [options] metricfile.pfm xmlfile.xml");
        this.getLogger().info(" where options can be:");
        this.getLogger().info(" -fn <fontname>");
        this.getLogger().info("     default is to use the fontname in the .pfm file, but");
        this.getLogger().info("     you can override that name to make sure that the");
        this.getLogger().info("     embedded font is used (if you're embedding fonts)");
        this.getLogger().info("     instead of installed fonts when viewing documents with Acrobat Reader.");
    }

    public static void main(String[] args) {
        String embFile = null;
        String embResource = null;
        String className = null;
        String fontName = null;
        HashMap options = new HashMap();
        String[] arguments = PFMReader.parseArguments(options, args);
        PFMReader app = new PFMReader();
        ConsoleLogger log = options.get("-d") != null ? new ConsoleLogger(0) : new ConsoleLogger(1);
        app.enableLogging((Logger)log);
        log.info("PFM Reader v1.1");
        log.info("");
        if (options.get("-ef") != null) {
            embFile = (String)options.get("-ef");
        }
        if (options.get("-er") != null) {
            embResource = (String)options.get("-er");
        }
        if (options.get("-fn") != null) {
            fontName = (String)options.get("-fn");
        }
        if (options.get("-cn") != null) {
            className = (String)options.get("-cn");
        }
        if (arguments.length != 2 || options.get("-h") != null || options.get("-help") != null || options.get("--help") != null) {
            app.displayUsage();
        } else {
            PFMFile pfm = app.loadPFM(arguments[0]);
            if (pfm != null) {
                app.preview(pfm);
                Document doc = app.constructFontXML(pfm, fontName, className, embResource, embFile);
                app.writeFontXML(doc, arguments[1]);
            }
        }
    }

    public PFMFile loadPFM(String filename) {
        try {
            PFMFile pFMFile;
            this.getLogger().info("Reading " + filename + "...");
            this.getLogger().info("");
            FileInputStream in = new FileInputStream(filename);
            try {
                PFMFile pfm = new PFMFile();
                this.setupLogger((Object)pfm);
                pfm.load(in);
                pFMFile = pfm;
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return pFMFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void preview(PFMFile pfm) {
        this.getLogger().info("Font: " + pfm.getWindowsName());
        this.getLogger().info("Name: " + pfm.getPostscriptName());
        this.getLogger().info("CharSet: " + pfm.getCharSetName());
        this.getLogger().info("CapHeight: " + pfm.getCapHeight());
        this.getLogger().info("XHeight: " + pfm.getXHeight());
        this.getLogger().info("LowerCaseAscent: " + pfm.getLowerCaseAscent());
        this.getLogger().info("LowerCaseDescent: " + pfm.getLowerCaseDescent());
        this.getLogger().info("Having widths for " + (pfm.getLastChar() - pfm.getFirstChar()) + " characters (" + pfm.getFirstChar() + "-" + pfm.getLastChar() + ").");
        this.getLogger().info("for example: Char " + pfm.getFirstChar() + " has a width of " + pfm.getCharWidth(pfm.getFirstChar()));
        this.getLogger().info("");
    }

    public void writeFontXML(Document doc, String target) {
        this.getLogger().info("Writing xml font file " + target + "...");
        this.getLogger().info("");
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(new File(target)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Document constructFontXML(PFMFile pfm, String fontName, String className, String resource, String file) {
        Document doc;
        this.getLogger().info("Creating xml font file...");
        this.getLogger().info("");
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            System.out.println("Can't create DOM implementation " + e.getMessage());
            return null;
        }
        Element root = doc.createElement("font-metrics");
        doc.appendChild(root);
        root.setAttribute("type", "TYPE1");
        Element el = doc.createElement("font-name");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(pfm.getPostscriptName()));
        String s = pfm.getPostscriptName();
        int pos = s.indexOf("-");
        if (pos >= 0) {
            char[] sb = new char[s.length() - 1];
            s.getChars(0, pos, sb, 0);
            s.getChars(pos + 1, s.length(), sb, pos);
            s = new String(sb);
        }
        el = doc.createElement("embed");
        root.appendChild(el);
        if (file != null) {
            el.setAttribute("file", file);
        }
        if (resource != null) {
            el.setAttribute("class", resource);
        }
        el = doc.createElement("encoding");
        root.appendChild(el);
        el.appendChild(doc.createTextNode(String.valueOf(pfm.getCharSetName()) + "Encoding"));
        el = doc.createElement("cap-height");
        root.appendChild(el);
        Integer value = new Integer(pfm.getCapHeight());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("x-height");
        root.appendChild(el);
        value = new Integer(pfm.getXHeight());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("ascender");
        root.appendChild(el);
        value = new Integer(pfm.getLowerCaseAscent());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("descender");
        root.appendChild(el);
        value = new Integer(-pfm.getLowerCaseDescent());
        el.appendChild(doc.createTextNode(value.toString()));
        Element bbox = doc.createElement("bbox");
        root.appendChild(bbox);
        int[] bb = pfm.getFontBBox();
        String[] names = new String[]{"left", "bottom", "right", "top"};
        int i = 0;
        while (i < names.length) {
            el = doc.createElement(names[i]);
            bbox.appendChild(el);
            value = new Integer(bb[i]);
            el.appendChild(doc.createTextNode(value.toString()));
            ++i;
        }
        el = doc.createElement("flags");
        root.appendChild(el);
        value = new Integer(pfm.getFlags());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("stemv");
        root.appendChild(el);
        value = new Integer(pfm.getStemV());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("italicangle");
        root.appendChild(el);
        value = new Integer(pfm.getItalicAngle());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("first-char");
        root.appendChild(el);
        value = new Integer(pfm.getFirstChar());
        el.appendChild(doc.createTextNode(value.toString()));
        el = doc.createElement("last-char");
        root.appendChild(el);
        value = new Integer(pfm.getLastChar());
        el.appendChild(doc.createTextNode(value.toString()));
        Element widths = doc.createElement("widths");
        root.appendChild(widths);
        short i2 = pfm.getFirstChar();
        while (i2 <= pfm.getLastChar()) {
            el = doc.createElement("char");
            widths.appendChild(el);
            el.setAttribute("idx", Integer.toString(i2));
            el.setAttribute("wdt", new Integer(pfm.getCharWidth(i2)).toString());
            i2 = (short)(i2 + 1);
        }
        Iterator iterator = pfm.getKerning().keySet().iterator();
        while (iterator.hasNext()) {
            Integer kpx1 = (Integer)iterator.next();
            el = doc.createElement("kerning");
            el.setAttribute("kpx1", kpx1.toString());
            root.appendChild(el);
            Element el2 = null;
            Map h2 = (Map)pfm.getKerning().get(kpx1);
            Iterator enum2 = h2.keySet().iterator();
            while (enum2.hasNext()) {
                Integer kpx2 = (Integer)enum2.next();
                el2 = doc.createElement("pair");
                el2.setAttribute("kpx2", kpx2.toString());
                Integer val = (Integer)h2.get(kpx2);
                el2.setAttribute("kern", val.toString());
                el.appendChild(el2);
            }
        }
        return doc;
    }

    private String escapeString(String str) {
        StringBuffer esc = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\\') {
                esc.append("\\\\");
            } else {
                esc.append(str.charAt(i));
            }
            ++i;
        }
        return esc.toString();
    }
}

