/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.StreamRenderer;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.Page;

public class AreaTree {
    FontInfo fontInfo;
    ArrayList rootExtensions = null;
    private StreamRenderer streamRenderer;

    public AreaTree(StreamRenderer streamRenderer) {
        this.streamRenderer = streamRenderer;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void addPage(Page page) throws FOPException {
        try {
            page.setExtensions(this.rootExtensions);
            this.rootExtensions = null;
            this.streamRenderer.queuePage(page);
        }
        catch (IOException e) {
            throw new FOPException(e);
        }
    }

    public IDReferences getIDReferences() {
        return this.streamRenderer.getIDReferences();
    }

    public void addExtension(ExtensionObj obj) {
        if (this.rootExtensions == null) {
            this.rootExtensions = new ArrayList();
        }
        this.rootExtensions.add(obj);
    }

    public ArrayList getDocumentMarkers() {
        return this.streamRenderer.getDocumentMarkers();
    }

    public PageSequence getCurrentPageSequence() {
        return this.streamRenderer.getCurrentPageSequence();
    }

    public ArrayList getCurrentPageSequenceMarkers() {
        return this.streamRenderer.getCurrentPageSequenceMarkers();
    }
}

