/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ClipBridge;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGClipPathElementBridge
extends AbstractSVGBridge
implements ClipBridge {
    public String getLocalName() {
        return "clipPath";
    }

    public ClipRable createClip(BridgeContext ctx, Element clipElement, Element clipedElement, GraphicsNode clipedNode) {
        Filter filter;
        String s = clipElement.getAttributeNS(null, "transform");
        AffineTransform Tx = s.length() != 0 ? SVGUtilities.convertTransform(clipElement, "transform", s) : new AffineTransform();
        s = clipElement.getAttributeNS(null, "clipPathUnits");
        short coordSystemType = s.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(clipElement, "clipPathUnits", s);
        if (coordSystemType == 2) {
            Tx = SVGUtilities.toObjectBBox(Tx, clipedNode);
        }
        Area clipPath = new Area();
        GVTBuilder builder = ctx.getGVTBuilder();
        boolean hasChildren = false;
        Node node = clipElement.getFirstChild();
        while (node != null) {
            Element child;
            GraphicsNode clipNode;
            if (node.getNodeType() == 1 && (clipNode = builder.build(ctx, child = (Element)node)) != null) {
                hasChildren = true;
                int wr = CSSUtilities.convertClipRule(child);
                Shape cno = clipNode.getOutline();
                AffineTransform cnt = clipNode.getTransform();
                GeneralPath path = cnt != null ? new GeneralPath(cnt.createTransformedShape(cno)) : new GeneralPath(cno);
                path.setWindingRule(wr);
                Shape outline = Tx.createTransformedShape(path);
                ShapeNode outlineNode = new ShapeNode();
                outlineNode.setShape(outline);
                ClipRable clip = CSSUtilities.convertClipPath(child, outlineNode, ctx);
                if (clip != null) {
                    Area area = new Area(outline);
                    area.subtract(new Area(clip.getClipPath()));
                    outline = area;
                }
                clipPath.add(new Area(outline));
            }
            node = node.getNextSibling();
        }
        if (!hasChildren) {
            return null;
        }
        ShapeNode clipPathNode = new ShapeNode();
        clipPathNode.setShape(clipPath);
        ClipRable clipElementClipPath = CSSUtilities.convertClipPath(clipElement, clipPathNode, ctx);
        if (clipElementClipPath != null) {
            clipPath.subtract(new Area(clipElementClipPath.getClipPath()));
        }
        if ((filter = clipedNode.getFilter()) == null) {
            filter = clipedNode.getGraphicsNodeRable(true);
        }
        return new ClipRable8Bit(filter, clipPath);
    }
}

