/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class PDFWArray {
    private ArrayList entries = new ArrayList();

    public void addEntry(int start, int[] metrics) {
        this.entries.add(new Entry(start, metrics));
    }

    public void addEntry(int first, int last, int width) {
        this.entries.add(new int[]{first, last, width});
    }

    public void addEntry(int first, int last, int width, int posX, int posY) {
        this.entries.add(new int[]{first, last, width, posX, posY});
    }

    public byte[] toPDF() {
        try {
            return this.toPDFString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return this.toPDFString().getBytes();
        }
    }

    public String toPDFString() {
        StringBuffer p = new StringBuffer();
        p.append("[ ");
        int len = this.entries.size();
        int i = 0;
        while (i < len) {
            Object entry = this.entries.get(i);
            if (entry instanceof int[]) {
                int[] line = (int[])entry;
                int j = 0;
                while (j < line.length) {
                    p.append(line[j]);
                    p.append(" ");
                    ++j;
                }
            } else {
                ((Entry)entry).fillInPDF(p);
            }
            ++i;
        }
        p.append("]");
        return p.toString();
    }

    private static class Entry {
        private static final StringBuffer p = new StringBuffer();
        private int start;
        private int[] metrics;

        public Entry(int s, int[] m) {
            this.start = s;
            this.metrics = m;
        }

        public void fillInPDF(StringBuffer p) {
            p.append(this.start);
            p.append(" [");
            int i = 0;
            while (i < this.metrics.length) {
                p.append(this.metrics[i]);
                p.append(" ");
                ++i;
            }
            p.append("] ");
        }
    }
}

