/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.fonts;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.TTFSubSetFile;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.pdf.PDFWArray;
import org.apache.fop.render.pdf.CIDFont;
import org.apache.fop.render.pdf.fonts.BFEntry;

public class MultiByteFont
extends CIDFont
implements FontDescriptor {
    public String fontName = null;
    public String ttcName = null;
    public String encoding = "Identity-H";
    public int capHeight = 0;
    public int xHeight = 0;
    public int ascender = 0;
    public int descender = 0;
    public int[] fontBBox = new int[4];
    public URL embedFileName = null;
    public String embedResourceName = null;
    public PDFTTFStream embeddedFont = null;
    public int flags = 4;
    public int stemV = 0;
    public int italicAngle = 0;
    public int missingWidth = 0;
    public int defaultWidth = 0;
    public byte cidType = 1;
    public Map kerning = new HashMap();
    public boolean useKerning = true;
    private String namePrefix = null;
    private static int uniqueCounter = 1;
    public PDFWArray warray = new PDFWArray();
    public int[] width = null;
    public BFEntry[] bfentries = null;
    private Map usedGlyphs = new HashMap();
    private Map usedGlyphsIndex = new HashMap();
    int usedGlyphsCount = 0;

    public MultiByteFont() {
        this.usedGlyphs.put(new Integer(0), new Integer(0));
        this.usedGlyphsIndex.put(new Integer(0), new Integer(0));
        ++this.usedGlyphsCount;
        this.usedGlyphs.put(new Integer(1), new Integer(1));
        this.usedGlyphsIndex.put(new Integer(1), new Integer(1));
        ++this.usedGlyphsCount;
        this.usedGlyphs.put(new Integer(2), new Integer(2));
        this.usedGlyphsIndex.put(new Integer(2), new Integer(2));
        ++this.usedGlyphsCount;
        int cnt = 0;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            cnt = uniqueCounter++;
        }
        int ctm = (int)(System.currentTimeMillis() & 0xFFFFL);
        this.namePrefix = new String(String.valueOf(cnt) + "E" + Integer.toHexString(ctm));
    }

    public final boolean hasKerningInfo() {
        return this.useKerning & this.kerning.isEmpty();
    }

    public final Map getKerningInfo() {
        if (this.useKerning) {
            return this.kerning;
        }
        return new HashMap();
    }

    public byte getSubType() {
        return 0;
    }

    public String getLang() {
        return null;
    }

    public String getPanose() {
        return null;
    }

    public int getAvgWidth() {
        return -1;
    }

    public int getMinWidth() {
        return -1;
    }

    public int getMaxWidth() {
        return -1;
    }

    public int getleading() {
        return -1;
    }

    public int getStemH() {
        return 0;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public String getRegistry() {
        return "Adobe";
    }

    public String getOrdering() {
        return "UCS";
    }

    public int getSupplement() {
        return 0;
    }

    public byte getCidType() {
        return this.cidType;
    }

    public String getCidBaseFont() {
        return this.isEmbeddable() ? String.valueOf(this.namePrefix) + this.fontName : this.fontName;
    }

    public String getCharEncoding() {
        return "Identity-H";
    }

    public PDFWArray getWidths() {
        if (this.isEmbeddable()) {
            this.warray = new PDFWArray();
            int[] tmpWidth = new int[this.usedGlyphsCount];
            int i = 0;
            while (i < this.usedGlyphsCount) {
                Integer nw = (Integer)this.usedGlyphsIndex.get(new Integer(i));
                int nwx = nw == null ? 0 : nw;
                tmpWidth[i] = this.width[nwx];
                ++i;
            }
            this.warray.addEntry(0, tmpWidth);
        }
        return this.warray;
    }

    public boolean isEmbeddable() {
        return this.embedFileName != null || this.embedResourceName != null;
    }

    public PDFStream getFontFile(int i) {
        try {
            InputStream in = this.embedFileName.openStream();
            FontFileReader reader = new FontFileReader(in);
            in.close();
            TTFSubSetFile subset = new TTFSubSetFile();
            byte[] subsetFont = subset.readFont(reader, this.ttcName, this.usedGlyphs);
            this.embeddedFont = new PDFTTFStream(i, subsetFont.length);
            this.embeddedFont.addFilter("flate");
            this.embeddedFont.addFilter("ascii-85");
            this.embeddedFont.setData(subsetFont, subsetFont.length);
        }
        catch (IOException ioe) {
            MessageHandler.errorln("Failed to embed font [" + i + "] " + this.fontName + ": " + ioe.getMessage());
            return null;
        }
        return this.embeddedFont;
    }

    public String encoding() {
        return this.encoding;
    }

    public String fontName() {
        return this.isEmbeddable() ? String.valueOf(this.namePrefix) + this.fontName : this.fontName;
    }

    public int getAscender() {
        return this.ascender;
    }

    public int getDescender() {
        return this.descender;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public int getAscender(int size) {
        return size * this.ascender;
    }

    public int getCapHeight(int size) {
        return size * this.capHeight;
    }

    public int getDescender(int size) {
        return size * this.descender;
    }

    public int getXHeight(int size) {
        return size * this.xHeight;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getFontBBox() {
        return this.fontBBox;
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    public int getStemV() {
        return this.stemV;
    }

    public int getFirstChar() {
        return 0;
    }

    public int getLastChar() {
        return 255;
    }

    public int width(int i, int size) {
        if (this.isEmbeddable()) {
            Integer idx = (Integer)this.usedGlyphsIndex.get(new Integer(i));
            return size * this.width[idx];
        }
        return size * this.width[i];
    }

    public int[] getWidths(int size) {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length - 1);
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * size;
        }
        return arr;
    }

    public Integer reMap(Integer i) {
        if (this.isEmbeddable()) {
            Integer ret = (Integer)this.usedGlyphsIndex.get(i);
            if (ret == null) {
                ret = i;
            }
            return ret;
        }
        return i;
    }

    public char mapChar(char c) {
        char idx = c;
        int retIdx = 0;
        int i = 0;
        while (i < this.bfentries.length && retIdx == 0) {
            if (this.bfentries[i].unicodeStart <= idx && this.bfentries[i].unicodeEnd >= idx) {
                retIdx = this.bfentries[i].glyphStartIndex + idx - this.bfentries[i].unicodeStart;
            }
            ++i;
        }
        if (this.isEmbeddable()) {
            Integer newIdx = (Integer)this.usedGlyphs.get(new Integer(retIdx));
            if (newIdx == null) {
                this.usedGlyphs.put(new Integer(retIdx), new Integer(this.usedGlyphsCount));
                this.usedGlyphsIndex.put(new Integer(this.usedGlyphsCount), new Integer(retIdx));
                retIdx = this.usedGlyphsCount++;
            } else {
                retIdx = newIdx;
            }
        }
        return (char)retIdx;
    }
}

