/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PageResources;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.text.pdf.StampContent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class PdfStamperImp
extends PdfWriter {
    RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref = new IntHashtable();
    HashMap pagesToContent = new HashMap();
    boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;
    protected int[] namePtr = new int[1];
    protected boolean namedAsNames;
    protected List newBookmarks;
    protected HashSet partialFlattening = new HashSet();

    PdfStamperImp(PdfReader reader, OutputStream os, char pdfVersion) throws DocumentException, IOException {
        super(new PdfDocument(), os);
        if (reader.isTampered()) {
            throw new DocumentException("The original document was reused. Read it again from file.");
        }
        reader.setTampered(true);
        this.reader = reader;
        this.file = reader.getSafeFile();
        if (pdfVersion == '\u0000') {
            super.setPdfVersion(reader.getPdfVersion());
        } else {
            super.setPdfVersion(pdfVersion);
        }
        super.open();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(HashMap moreInfo) throws DocumentException, IOException {
        block18: {
            if (this.closed) {
                return;
            }
            if (this.flat) {
                this.flatFields();
            }
            this.closed = true;
            this.addSharedObjectsToBody();
            this.setOutlines();
            iInfo = null;
            try {
                this.file.reOpen();
                this.alterContents();
                xb = this.reader.xrefObj;
                idx = true;
                iInfo = (PRIndirectReference)this.reader.trailer.get(PdfName.INFO);
                skip = -1;
                if (iInfo != null) {
                    skip = iInfo.getNumber();
                }
                k = 1;
                while (k < xb.length) {
                    if (xb[k] != null && skip != k) {
                        this.addToBody(xb[k], this.getNewObjectNumber(this.reader, k, 0));
                    }
                    ++k;
                }
            }
            catch (Throwable var8_11) {
                var7_13 = null;
                try {
                    this.file.close();
                    throw var8_11;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw var8_11;
            }
            {
                var7_14 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 149->159)] { 
lbl37:
            // 1 sources

            this.file.close();
            break block18;
lbl39:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        encryption = null;
        fileID = null;
        if (this.crypto != null) {
            encryptionObject = this.body.add(this.crypto.getEncryptionDictionary());
            encryption = encryptionObject.getIndirectReference();
            fileID = this.crypto.getFileID();
        }
        iRoot = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        root = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, iRoot.getNumber(), 0));
        info = null;
        oldInfo = (PdfDictionary)PdfReader.getPdfObject(iInfo);
        newInfo = new PdfDictionary();
        if (oldInfo != null) {
            i = oldInfo.getKeys().iterator();
            while (i.hasNext()) {
                key = (PdfName)i.next();
                value = PdfReader.getPdfObject(oldInfo.get((PdfName)key));
                newInfo.put((PdfName)key, value);
            }
        }
        if (moreInfo != null) {
            i = moreInfo.keySet().iterator();
            while (i.hasNext()) {
                key = (String)i.next();
                keyName = new PdfName((String)key);
                value = (String)moreInfo.get(key);
                if (value == null) {
                    newInfo.remove(keyName);
                    continue;
                }
                newInfo.put(keyName, new PdfString(value, "UnicodeBig"));
            }
        }
        if (!newInfo.getKeys().isEmpty()) {
            info = this.addToBody(newInfo).getIndirectReference();
        }
        this.body.writeCrossReferenceTable(this.os);
        trailer = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), root, info, encryption, fileID);
        trailer.toPdf(this, this.os);
        this.os.flush();
        if (this.isCloseStream() == false) return;
        this.os.close();
    }

    void applyRotation(int pageNumber, ByteBuffer out) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle page = this.reader.getPageSizeWithRotation(pageNumber);
        int rotation = page.getRotation();
        switch (rotation) {
            case 90: {
                out.append(PdfContents.ROTATE90);
                out.append(page.top());
                out.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                out.append(PdfContents.ROTATE180);
                out.append(page.right());
                out.append(' ');
                out.append(page.top());
                out.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                out.append(PdfContents.ROTATE270);
                out.append('0').append(' ');
                out.append(page.right());
                out.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    void alterContents() throws IOException {
        Iterator i = this.pagesToContent.keySet().iterator();
        while (i.hasNext()) {
            Integer pageNumber = (Integer)i.next();
            PageStamp ps = (PageStamp)this.pagesToContent.get(pageNumber);
            ByteBuffer out = new ByteBuffer();
            if (ps.under != null) {
                out.append(PdfContents.SAVESTATE);
                this.applyRotation(pageNumber, out);
                out.append(ps.under.getInternalBuffer());
                out.append(PdfContents.RESTORESTATE);
            }
            if (ps.over != null) {
                out.append(PdfContents.SAVESTATE);
            }
            out.append(this.reader.getPageContent(pageNumber, this.file));
            if (ps.over != null) {
                out.append(' ');
                out.append(PdfContents.RESTORESTATE);
                out.append(PdfContents.SAVESTATE);
                this.applyRotation(pageNumber, out);
                out.append(ps.over.getInternalBuffer());
                out.append(PdfContents.RESTORESTATE);
            }
            this.reader.setPageContent(pageNumber, out.toByteArray());
            this.alterResources(ps);
        }
    }

    void alterResources(PageStamp ps) {
        PdfDictionary dic = this.reader.getPageN(ps.pageNumber);
        dic.put(PdfName.RESOURCES, ps.pageResources.getResources());
    }

    protected int getNewObjectNumber(PdfReader reader, int number, int generation) {
        if (this.currentPdfReaderInstance == null) {
            int n = this.myXref.get(number);
            if (n == 0) {
                n = this.getIndirectReferenceNumber();
                this.myXref.put(number, n);
            }
            return n;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(number, generation);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader reader) {
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    PageStamp getPageStamp(int pageNum) {
        Integer page = new Integer(pageNum);
        PageStamp ps = (PageStamp)this.pagesToContent.get(page);
        if (ps == null) {
            ps = new PageStamp(this, this.reader, pageNum);
            this.pagesToContent.put(page, ps);
        }
        return ps;
    }

    PdfContentByte getUnderContent(int pageNum) {
        if (pageNum < 1 || pageNum > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp ps = this.getPageStamp(pageNum);
        if (ps.under == null) {
            ps.under = new StampContent(this, pageNum);
        }
        return ps.under;
    }

    PdfContentByte getOverContent(int pageNum) {
        if (pageNum < 1 || pageNum > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp ps = this.getPageStamp(pageNum);
        if (ps.over == null) {
            ps.over = new StampContent(this, pageNum);
        }
        return ps.over;
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean rotateContents) {
        this.rotateContents = rotateContents;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean flat) {
        this.flat = flat;
    }

    boolean partialFormFlattening(String name) {
        this.getAcroFields();
        if (!this.acroFields.getFields().containsKey(name)) {
            return false;
        }
        this.partialFlattening.add(name);
        return true;
    }

    void flatFields() {
        PdfArray array;
        this.getAcroFields();
        PdfDictionary acroForm = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM));
        ArrayList acroFds = null;
        if (acroForm != null && (array = (PdfArray)PdfReader.getPdfObject(acroForm.get(PdfName.FIELDS))) != null) {
            acroFds = array.getArrayList();
        }
        HashMap fields = this.acroFields.getFields();
        Iterator i = fields.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(name)) continue;
            AcroFields.Item item = (AcroFields.Item)fields.get(name);
            int k = 0;
            while (k < item.merged.size()) {
                PdfDictionary appDic;
                PdfDictionary merged = (PdfDictionary)item.merged.get(k);
                PdfNumber ff = (PdfNumber)PdfReader.getPdfObject(merged.get(PdfName.F));
                int flags = 0;
                if (ff != null) {
                    flags = ff.intValue();
                }
                if ((flags & 4) != 0 && (flags & 2) == 0 && (appDic = (PdfDictionary)PdfReader.getPdfObject(merged.get(PdfName.AP))) != null) {
                    PdfIndirectReference iref;
                    PdfName as;
                    PdfObject obj = appDic.get(PdfName.N);
                    PdfAppearance app = null;
                    PdfObject objReal = PdfReader.getPdfObject(obj);
                    if (obj instanceof PdfIndirectReference && !obj.isIndirect()) {
                        app = new PdfAppearance((PdfIndirectReference)obj);
                    } else if (objReal instanceof PdfStream) {
                        ((PdfDictionary)objReal).put(PdfName.SUBTYPE, PdfName.FORM);
                        app = new PdfAppearance((PdfIndirectReference)obj);
                    } else if (objReal.isDictionary() && (as = (PdfName)PdfReader.getPdfObject(merged.get(PdfName.AS))) != null && (iref = (PdfIndirectReference)((PdfDictionary)objReal).get(as)) != null) {
                        app = new PdfAppearance(iref);
                        if (iref.isIndirect()) {
                            objReal = PdfReader.getPdfObject(iref);
                            ((PdfDictionary)objReal).put(PdfName.SUBTYPE, PdfName.FORM);
                        }
                    }
                    if (app != null) {
                        PdfDictionary pageDic;
                        PdfArray annots;
                        Rectangle box = PdfReader.getNormalizedRectangle((PdfArray)PdfReader.getPdfObject(merged.get(PdfName.RECT)));
                        int page = (Integer)item.page.get(k);
                        PdfContentByte cb = this.getOverContent(page);
                        cb.setLiteral("Q ");
                        cb.addTemplate(app, box.left(), box.bottom());
                        cb.setLiteral("q ");
                        if (!this.partialFlattening.isEmpty() && (annots = (PdfArray)PdfReader.getPdfObject((pageDic = this.reader.getPageN(page)).get(PdfName.ANNOTS))) != null) {
                            ArrayList ar = annots.getArrayList();
                            int idx = 0;
                            while (idx < ar.size()) {
                                PdfObject ran2;
                                PdfObject ran = (PdfObject)ar.get(idx);
                                if (ran.isIndirect() && (ran2 = (PdfObject)item.widget_refs.get(k)).isIndirect() && ((PRIndirectReference)ran).getNumber() == ((PRIndirectReference)ran2).getNumber()) {
                                    ar.remove(idx--);
                                    PRIndirectReference wdref = (PRIndirectReference)ran2;
                                    while (true) {
                                        PdfDictionary wd = (PdfDictionary)PdfReader.getPdfObject(wdref);
                                        PRIndirectReference parentRef = (PRIndirectReference)wd.get(PdfName.PARENT);
                                        PdfReader.killIndirect(wdref);
                                        if (parentRef == null) {
                                            int fr = 0;
                                            while (fr < acroFds.size()) {
                                                PdfObject h = (PdfObject)acroFds.get(fr);
                                                if (h.isIndirect() && ((PRIndirectReference)h).getNumber() == wdref.getNumber()) {
                                                    acroFds.remove(fr);
                                                    --fr;
                                                }
                                                ++fr;
                                            }
                                            break;
                                        }
                                        PdfDictionary parent = (PdfDictionary)PdfReader.getPdfObject(parentRef);
                                        PdfArray kids = (PdfArray)PdfReader.getPdfObject(parent.get(PdfName.KIDS));
                                        ArrayList kar = kids.getArrayList();
                                        int fr = 0;
                                        while (fr < kar.size()) {
                                            PdfObject h = (PdfObject)kar.get(fr);
                                            if (h.isIndirect() && ((PRIndirectReference)h).getNumber() == wdref.getNumber()) {
                                                kar.remove(fr);
                                                --fr;
                                            }
                                            ++fr;
                                        }
                                        if (!kar.isEmpty()) break;
                                        wdref = parentRef;
                                    }
                                }
                                ++idx;
                            }
                            if (ar.size() == 0) {
                                PdfReader.killIndirect(pageDic.get(PdfName.ANNOTS));
                                pageDic.remove(PdfName.ANNOTS);
                            }
                        }
                    }
                }
                ++k;
            }
        }
        if (this.partialFlattening.isEmpty()) {
            int page = 1;
            while (page <= this.reader.getNumberOfPages()) {
                PdfDictionary pageDic = this.reader.getPageN(page);
                PdfArray annots = (PdfArray)PdfReader.getPdfObject(pageDic.get(PdfName.ANNOTS));
                if (annots != null) {
                    ArrayList ar = annots.getArrayList();
                    int idx = 0;
                    while (idx < ar.size()) {
                        PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject((PdfObject)ar.get(idx));
                        if (PdfName.WIDGET.equals(annot.get(PdfName.SUBTYPE))) {
                            ar.remove(idx);
                            --idx;
                        }
                        ++idx;
                    }
                    if (ar.size() == 0) {
                        PdfReader.killIndirect(pageDic.get(PdfName.ANNOTS));
                        pageDic.remove(PdfName.ANNOTS);
                    }
                }
                ++page;
            }
            this.eliminateAcroformObjects();
        } else if (acroFds.isEmpty()) {
            this.reader.getCatalog().remove(PdfName.ACROFORM);
        }
    }

    void eliminateAcroformObjects() {
        PdfObject acro = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (acro == null) {
            return;
        }
        PdfDictionary acrodic = (PdfDictionary)PdfReader.getPdfObject(acro);
        PdfObject iFields = acrodic.get(PdfName.FIELDS);
        if (iFields != null) {
            PdfDictionary kids = new PdfDictionary();
            kids.put(PdfName.KIDS, iFields);
            this.sweepKids(kids);
        }
        PdfReader.killIndirect(acro);
        this.reader.getCatalog().remove(PdfName.ACROFORM);
    }

    void sweepKids(PdfObject obj) {
        PdfObject oo = PdfReader.killIndirect(obj);
        if (!oo.isDictionary()) {
            return;
        }
        PdfDictionary dic = (PdfDictionary)oo;
        PdfArray kids = (PdfArray)PdfReader.killIndirect(dic.get(PdfName.KIDS));
        if (kids == null) {
            return;
        }
        ArrayList ar = kids.getArrayList();
        int k = 0;
        while (k < ar.size()) {
            this.sweepKids((PdfObject)ar.get(k));
            ++k;
        }
    }

    public PdfIndirectReference getPageReference(int page) {
        PRIndirectReference ref = this.reader.getPageOrigRef(page);
        if (ref == null) {
            throw new IllegalArgumentException("Invalid page number " + page);
        }
        return ref;
    }

    public void addAnnotation(PdfAnnotation annot) {
        throw new RuntimeException("Unsupported in this context. Use PdfStamper.addAnnotation()");
    }

    void addAnnotation(PdfAnnotation annot, int page) {
        try {
            if (annot.isForm()) {
                throw new RuntimeException("Form fields not yet supported.");
            }
            PdfRectangle rect = (PdfRectangle)annot.get(PdfName.RECT);
            int rotation = this.reader.getPageRotation(page);
            Rectangle pageSize = this.reader.getPageSizeWithRotation(page);
            switch (rotation) {
                case 90: {
                    annot.put(PdfName.RECT, new PdfRectangle(pageSize.top() - rect.bottom(), rect.left(), pageSize.top() - rect.top(), rect.right()));
                    break;
                }
                case 180: {
                    annot.put(PdfName.RECT, new PdfRectangle(pageSize.right() - rect.left(), pageSize.top() - rect.bottom(), pageSize.right() - rect.right(), pageSize.top() - rect.top()));
                    break;
                }
                case 270: {
                    annot.put(PdfName.RECT, new PdfRectangle(rect.bottom(), pageSize.right() - rect.left(), rect.top(), pageSize.right() - rect.right()));
                }
            }
            PdfDictionary dic = this.reader.getPageN(page);
            PdfArray annots = (PdfArray)PdfReader.getPdfObject(dic.get(PdfName.ANNOTS));
            if (annots == null) {
                annots = new PdfArray();
                dic.put(PdfName.ANNOTS, annots);
            }
            PdfIndirectReference ref = this.addToBody(annot).getIndirectReference();
            annots.add(ref);
            annot.put(PdfName.RECT, rect);
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    private void outlineTravel(PRIndirectReference outline) {
        while (outline != null) {
            PdfDictionary outlineR = (PdfDictionary)PdfReader.getPdfObject(outline);
            PRIndirectReference first = (PRIndirectReference)outlineR.get(PdfName.FIRST);
            if (first != null) {
                this.outlineTravel(first);
            }
            PdfReader.killIndirect(outlineR.get(PdfName.DEST));
            PdfReader.killIndirect(outlineR.get(PdfName.A));
            PdfReader.killIndirect(outline);
            outline = (PRIndirectReference)outlineR.get(PdfName.NEXT);
        }
    }

    void deleteOutlines() {
        PdfDictionary catalog = this.reader.getCatalog();
        PRIndirectReference outlines = (PRIndirectReference)catalog.get(PdfName.OUTLINES);
        if (outlines == null) {
            return;
        }
        this.outlineTravel(outlines);
        PdfReader.killIndirect(outlines);
        catalog.remove(PdfName.OUTLINES);
    }

    void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.size() == 0) {
            return;
        }
        this.namedAsNames = this.reader.getCatalog().get(PdfName.DESTS) != null;
        PdfDictionary top = new PdfDictionary();
        PdfIndirectReference topRef = this.getPdfIndirectReference();
        Object[] kids = SimpleBookmark.iterateOutlines(this, topRef, this.newBookmarks, this.namedAsNames);
        top.put(PdfName.FIRST, (PdfIndirectReference)kids[0]);
        top.put(PdfName.LAST, (PdfIndirectReference)kids[1]);
        top.put(PdfName.COUNT, new PdfNumber((Integer)kids[2]));
        this.addToBody((PdfObject)top, topRef);
        this.reader.getCatalog().put(PdfName.OUTLINES, topRef);
    }

    void setOutlines(List outlines) {
        this.newBookmarks = outlines;
    }

    class PageStamp {
        int pageNumber;
        StampContent under;
        StampContent over;
        PageResources pageResources;

        PageStamp(PdfStamperImp stamper, PdfReader reader, int pageNumber) {
            this.pageNumber = pageNumber;
            this.pageResources = new PageResources();
            PdfDictionary dic = reader.getPageN(pageNumber);
            PdfDictionary resources = (PdfDictionary)PdfReader.getPdfObject(dic.get(PdfName.RESOURCES));
            this.pageResources.setOriginalResources(resources, stamper.namePtr);
        }
    }
}

