/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLParser;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.XUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DOMParser
extends XMLParser
implements XMLDocumentHandler {
    public static final String DEFAULT_DOCUMENT_CLASS_NAME = "org.apache.xerces.dom.DocumentImpl";
    public static final String DEFAULT_DEFERRED_DOCUMENT_CLASS_NAME = "org.apache.xerces.dom.DeferredDocumentImpl";
    private static final boolean DEBUG_ATTLIST_DECL = false;
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/dom/defer-node-expansion", "http://apache.org/xml/features/dom/create-entity-ref-nodes", "http://apache.org/xml/features/dom/include-ignorable-whitespace", "http://apache.org/xml/features/domx/grammar-access"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/dom/document-class-name", "http://apache.org/xml/properties/dom/current-element-node"};
    protected Document fDocument;
    protected DeferredDocumentImpl fDeferredDocumentImpl;
    protected int fDocumentIndex;
    protected int fDocumentTypeIndex;
    protected int fCurrentNodeIndex;
    protected int fCurrentEntityName;
    protected int fCurrentEntityNode;
    protected DocumentImpl fDocumentImpl;
    protected DocumentType fDocumentType;
    protected Node fCurrentElementNode;
    protected boolean fInDTD;
    protected boolean fWithinElement;
    protected boolean fInCDATA;
    private boolean fGrammarAccess;
    private String fDocumentClassName;
    private boolean fDeferNodeExpansion;
    private boolean fCreateEntityReferenceNodes;
    private boolean fIncludeIgnorableWhitespace;
    protected int fAmpIndex;
    protected int fLtIndex;
    protected int fGtIndex;
    protected int fAposIndex;
    protected int fQuotIndex;
    private boolean fSeenRootElement;
    private boolean fStringPoolInUse;
    private XMLAttrList fAttrList;
    private static /* synthetic */ Class class$Lorg$w3c$dom$Document;

    public Document getDocument() {
        return this.fDocument;
    }

    public String[] getFeaturesRecognized() {
        String[] stringArray = super.getFeaturesRecognized();
        String[] stringArray2 = RECOGNIZED_FEATURES;
        int n = stringArray2.length;
        if (n == 0) {
            return stringArray;
        }
        int n2 = stringArray.length;
        if (n2 == 0) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n2 + n];
        System.arraycopy(stringArray, 0, stringArray3, 0, n2);
        System.arraycopy(stringArray2, 0, stringArray3, n2, n);
        return stringArray3;
    }

    public String[] getPropertiesRecognized() {
        String[] stringArray = super.getPropertiesRecognized();
        String[] stringArray2 = RECOGNIZED_PROPERTIES;
        int n = stringArray2.length;
        if (n == 0) {
            return stringArray;
        }
        int n2 = stringArray.length;
        if (n2 == 0) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n2 + n];
        System.arraycopy(stringArray, 0, stringArray3, 0, n2);
        System.arraycopy(stringArray2, 0, stringArray3, n2, n);
        return stringArray3;
    }

    public void reset() throws Exception {
        if (this.fStringPoolInUse) {
            this.fStringPool = new StringPool();
            this.fStringPoolInUse = false;
        }
        super.reset();
        this.init();
    }

    public void resetOrCopy() throws Exception {
        super.resetOrCopy();
        this.init();
    }

    protected void init() {
        this.fDocument = null;
        this.fDeferredDocumentImpl = null;
        this.fDocumentIndex = -1;
        this.fDocumentTypeIndex = -1;
        this.fCurrentNodeIndex = -1;
        this.fCurrentEntityNode = -1;
        this.fCurrentEntityName = -1;
        this.fDocumentImpl = null;
        this.fDocumentType = null;
        this.fCurrentElementNode = null;
        this.fInDTD = false;
        this.fWithinElement = false;
        this.fInCDATA = false;
        this.fAmpIndex = this.fStringPool.addSymbol("amp");
        this.fLtIndex = this.fStringPool.addSymbol("lt");
        this.fGtIndex = this.fStringPool.addSymbol("gt");
        this.fAposIndex = this.fStringPool.addSymbol("apos");
        this.fQuotIndex = this.fStringPool.addSymbol("quot");
        this.fSeenRootElement = false;
        this.fStringPoolInUse = false;
        this.fAttrList = new XMLAttrList(this.fStringPool);
    }

    protected void setDeferNodeExpansion(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fDeferNodeExpansion = bl;
    }

    protected boolean getDeferNodeExpansion() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fDeferNodeExpansion;
    }

    protected void setCreateEntityReferenceNodes(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fCreateEntityReferenceNodes = bl;
    }

    public boolean getCreateEntityReferenceNodes() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fCreateEntityReferenceNodes;
    }

    public void setIncludeIgnorableWhitespace(boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fIncludeIgnorableWhitespace = bl;
    }

    public boolean getIncludeIgnorableWhitespace() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fIncludeIgnorableWhitespace;
    }

    protected void setDocumentClassName(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string == null) {
            string = DEFAULT_DOCUMENT_CLASS_NAME;
        }
        try {
            Class<?> clazz = Class.forName(string);
            if (!(class$Lorg$w3c$dom$Document != null ? class$Lorg$w3c$dom$Document : (class$Lorg$w3c$dom$Document = DOMParser.class$("org.w3c.dom.Document"))).isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("PAR002 Class, \"" + string + "\", is not of type org.w3c.dom.Document." + "\n" + string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("PAR003 Class, \"" + string + "\", not found." + "\n" + string);
        }
        this.fDocumentClassName = string;
        if (!string.equals(DEFAULT_DOCUMENT_CLASS_NAME)) {
            this.setDeferNodeExpansion(false);
        }
    }

    protected String getDocumentClassName() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fDocumentClassName;
    }

    protected Element getCurrentElementNode() throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fCurrentElementNode != null && this.fCurrentElementNode.getNodeType() == 1) {
            return (Element)this.fCurrentElementNode;
        }
        return null;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!string.startsWith("http://xml.org/sax/features/") && string.startsWith("http://apache.org/xml/features/")) {
            String string2 = string.substring("http://apache.org/xml/features/".length());
            if (string2.equals("dom/defer-node-expansion")) {
                if (this.fParseInProgress) {
                    throw new SAXNotSupportedException("PAR004 Cannot setFeature(" + string + "): parse is in progress." + "\n" + string);
                }
                this.setDeferNodeExpansion(bl);
                return;
            }
            if (string2.equals("dom/create-entity-ref-nodes")) {
                this.setCreateEntityReferenceNodes(bl);
                return;
            }
            if (string2.equals("dom/include-ignorable-whitespace")) {
                this.setIncludeIgnorableWhitespace(bl);
                return;
            }
            if (string2.equals("domx/grammar-access")) {
                this.fGrammarAccess = bl;
                return;
            }
        }
        super.setFeature(string, bl);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!string.startsWith("http://xml.org/sax/features/") && string.startsWith("http://apache.org/xml/features/")) {
            String string2 = string.substring("http://apache.org/xml/features/".length());
            if (string2.equals("dom/defer-node-expansion")) {
                return this.getDeferNodeExpansion();
            }
            if (string2.equals("dom/create-entity-ref-nodes")) {
                return this.getCreateEntityReferenceNodes();
            }
            if (string2.equals("dom/include-ignorable-whitespace")) {
                return this.getIncludeIgnorableWhitespace();
            }
            if (string2.equals("domx/grammar-access")) {
                return this.fGrammarAccess;
            }
        }
        return super.getFeature(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            String string2 = string.substring("http://apache.org/xml/properties/".length());
            if (string2.equals("dom/current-element-node")) {
                throw new SAXNotSupportedException("PAR005 Property, \"" + string + "\" is read-only.\n" + string);
            }
            if (string2.equals("dom/document-class-name")) {
                if (object != null && !(object instanceof String)) {
                    throw new SAXNotSupportedException("PAR006 Property value must be of type java.lang.String.");
                }
                this.setDocumentClassName((String)object);
                return;
            }
        }
        super.setProperty(string, object);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            String string2 = string.substring("http://apache.org/xml/properties/".length());
            if (string2.equals("dom/current-element-node")) {
                boolean bl = false;
                try {
                    bl = this.getFeature("http://apache.org/xml/features/dom/defer-node-expansion");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
                if (bl) {
                    throw new SAXNotSupportedException("PAR007 Current element node cannot be queried when node expansion is deferred.");
                }
                return this.getCurrentElementNode();
            }
            if (string2.equals("dom/document-class-name")) {
                return this.getDocumentClassName();
            }
        }
        return super.getProperty(string);
    }

    public void startDocument() {
        block14: {
            String string = null;
            try {
                string = this.getDocumentClassName();
            }
            catch (SAXException sAXException) {
                throw new RuntimeException("PAR008 Fatal error getting document factory.");
            }
            boolean bl = true;
            try {
                bl = this.getDeferNodeExpansion();
            }
            catch (SAXException sAXException) {
                throw new RuntimeException("PAR009 Fatal error reading expansion mode.");
            }
            try {
                boolean bl2 = this.fDocumentClassName.equals(DEFAULT_DOCUMENT_CLASS_NAME);
                boolean bl3 = this.fDocumentClassName.equals(DEFAULT_DEFERRED_DOCUMENT_CLASS_NAME);
                if (bl && (bl2 || bl3)) {
                    boolean bl4 = false;
                    try {
                        bl4 = this.getNamespaces();
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                    this.fDeferredDocumentImpl = new DeferredDocumentImpl(this.fStringPool, bl4, this.fGrammarAccess);
                    this.fStringPoolInUse = true;
                    this.fDocument = this.fDeferredDocumentImpl;
                    this.fCurrentNodeIndex = this.fDocumentIndex = this.fDeferredDocumentImpl.createDocument();
                    break block14;
                }
                if (bl2) {
                    this.fDocumentImpl = new DocumentImpl(this.fGrammarAccess);
                    this.fDocument = this.fDocumentImpl;
                    this.fDocumentImpl.setErrorChecking(false);
                } else {
                    Class<?> clazz = Class.forName(string);
                    try {
                        this.fDocument = (Document)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Failed to create document object of class: " + string);
                    }
                    Class<?> clazz2 = Class.forName(DEFAULT_DOCUMENT_CLASS_NAME);
                    if (clazz2.isAssignableFrom(clazz)) {
                        this.fDocumentImpl = (DocumentImpl)this.fDocument;
                        this.fDocumentImpl.setErrorChecking(false);
                    }
                }
                this.fCurrentElementNode = this.fDocument;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(string);
            }
        }
    }

    public void endDocument() throws Exception {
        if (this.fDocumentImpl != null) {
            this.fDocumentImpl.setErrorChecking(true);
            if (this.fDocumentType != null) {
                ((DocumentTypeImpl)this.fDocumentType).setReadOnly(true, false);
            }
        }
    }

    public void xmlDecl(int n, int n2, int n3) throws Exception {
        block1: {
            boolean bl;
            block0: {
                boolean bl2 = n3 != -1 ? this.fStringPool.toString(n3).equals("yes") : (bl = false);
                if (this.fDocumentImpl == null) break block0;
                this.fDocumentImpl.setVersion(this.fStringPool.toString(n));
                this.fDocumentImpl.setEncoding(this.fStringPool.toString(n2));
                this.fDocumentImpl.setStandalone(bl);
                break block1;
            }
            if (this.fDeferredDocumentImpl == null) break block1;
            this.fDeferredDocumentImpl.setVersion(this.fStringPool.toString(n));
            this.fDeferredDocumentImpl.setEncoding(this.fStringPool.toString(n2));
            this.fDeferredDocumentImpl.setStandalone(bl);
        }
    }

    public void textDecl(int n, int n2) throws Exception {
        block2: {
            EntityImpl entityImpl;
            NamedNodeMap namedNodeMap;
            block1: {
                if (this.fDeferredDocumentImpl == null) break block1;
                String string = this.fStringPool.toString(this.fCurrentEntityName);
                if (this.fDocumentTypeIndex == -1 || string == null) break block2;
                int n3 = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
                while (n3 != -1) {
                    if (this.fDeferredDocumentImpl.getNodeType(n3, false) == 6 && this.fDeferredDocumentImpl.getNodeNameString(n3, false).equals(string)) break;
                    n3 = this.fDeferredDocumentImpl.getPrevSibling(n3, false);
                }
                this.fCurrentEntityNode = n3;
                this.fDeferredDocumentImpl.setEntityInfo(n3, n, n2);
                break block2;
            }
            if (this.fDocumentImpl == null || (namedNodeMap = this.fDocumentType.getEntities()) == null || (entityImpl = (EntityImpl)namedNodeMap.getNamedItem(this.fCurrentElementNode.getNodeName())) == null) break block2;
            entityImpl.setVersion(this.fStringPool.toString(n));
            entityImpl.setEncoding(this.fStringPool.toString(n2));
        }
    }

    public void startNamespaceDeclScope(int n, int n2) throws Exception {
    }

    public void endNamespaceDeclScope(int n) throws Exception {
    }

    public void startElement(QName qName, XMLAttrList xMLAttrList, int n) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            if (!this.fSeenRootElement) {
                this.fSeenRootElement = true;
                if (this.fGrammarAccess && this.fGrammarResolver.size() > 0) {
                    Enumeration enumeration;
                    Document document;
                    if (this.fDocumentTypeIndex == -1) {
                        this.fDocumentTypeIndex = this.fDeferredDocumentImpl.createDocumentType(qName.rawname, -1, -1);
                        this.fDeferredDocumentImpl.appendChild(0, this.fDocumentTypeIndex);
                    }
                    if ((document = this.fGrammarResolver.getGrammar((String)(enumeration = this.fGrammarResolver.nameSpaceKeys()).nextElement()).getGrammarDocument()) != null) {
                        Element element = document.getDocumentElement();
                        this.copyInto(element, this.fDocumentTypeIndex);
                    }
                }
            }
            int n2 = this.fDeferredDocumentImpl.createElement(qName.rawname, qName.uri, xMLAttrList, n);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n2);
            this.fCurrentNodeIndex = n2;
            this.fWithinElement = true;
            int n3 = xMLAttrList.getFirstAttr(n);
            while (n3 != -1) {
                if (xMLAttrList.getAttType(n3) == this.fStringPool.addSymbol("ID")) {
                    int n4 = xMLAttrList.getAttValue(n3);
                    this.fDeferredDocumentImpl.putIdentifier(n4, n2);
                }
                n3 = xMLAttrList.getNextAttr(n3);
            }
        } else {
            String string;
            Object object;
            Object object2;
            boolean bl = false;
            try {
                bl = this.getNamespaces();
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            String string2 = this.fStringPool.toString(qName.rawname);
            if (!this.fSeenRootElement) {
                this.fSeenRootElement = true;
                if (this.fDocumentImpl != null && this.fGrammarAccess && this.fGrammarResolver.size() > 0) {
                    Object object3;
                    if (this.fDocumentType == null) {
                        object2 = string2;
                        object = "";
                        object3 = "";
                        this.fDocumentType = this.fDocumentImpl.createDocumentType((String)object2, (String)object3, (String)object);
                        this.fDocument.appendChild(this.fDocumentType);
                    }
                    if ((object = this.fGrammarResolver.getGrammar((String)(object2 = this.fGrammarResolver.nameSpaceKeys()).nextElement()).getGrammarDocument()) != null) {
                        object3 = object.getDocumentElement();
                        XUtil.copyInto((Node)object3, this.fDocumentType);
                    }
                }
            }
            if (bl) {
                object = this.fStringPool.toString(qName.uri);
                if (((String)object).length() == 0) {
                    object = null;
                }
                object2 = this.fDocument.createElementNS((String)object, string2);
            } else {
                object2 = this.fDocument.createElement(string2);
            }
            int n5 = xMLAttrList.getFirstAttr(n);
            while (n5 != -1) {
                int n6 = xMLAttrList.getAttrName(n5);
                string = this.fStringPool.toString(n6);
                String string3 = this.fStringPool.toString(xMLAttrList.getAttValue(n5));
                if (bl) {
                    int n7 = xMLAttrList.getAttrURI(n5);
                    String string4 = this.fStringPool.toString(n7);
                    int n8 = xMLAttrList.getAttrPrefix(n5);
                    String string5 = this.fStringPool.toString(n8);
                    if (string4.length() == 0) {
                        string4 = null;
                    }
                    if (string4 == null) {
                        if (string5 != null) {
                            if (string5.equals("xmlns")) {
                                string4 = "http://www.w3.org/2000/xmlns/";
                            }
                        } else if (string.equals("xmlns")) {
                            string4 = "http://www.w3.org/2000/xmlns/";
                        }
                    }
                    object2.setAttributeNS(string4, string, string3);
                } else {
                    object2.setAttribute(string, string3);
                }
                if (this.fDocumentImpl != null && !xMLAttrList.isSpecified(n5)) {
                    ((AttrImpl)object2.getAttributeNode(string)).setSpecified(false);
                }
                n5 = xMLAttrList.getNextAttr(n5);
            }
            this.fCurrentElementNode.appendChild((Node)object2);
            this.fCurrentElementNode = object2;
            this.fWithinElement = true;
            if (this.fDocumentImpl != null) {
                int n9 = xMLAttrList.getFirstAttr(n);
                while (n9 != -1) {
                    if (xMLAttrList.getAttType(n9) == this.fStringPool.addSymbol("ID")) {
                        string = this.fStringPool.toString(xMLAttrList.getAttValue(n9));
                        this.fDocumentImpl.putIdentifier(string, (Element)object2);
                    }
                    n9 = xMLAttrList.getNextAttr(n9);
                }
            }
            xMLAttrList.releaseAttrList(n);
        }
    }

    public void endElement(QName qName) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
            this.fWithinElement = false;
        } else {
            this.fCurrentElementNode = this.fCurrentElementNode.getParentNode();
            this.fWithinElement = false;
        }
    }

    public void characters(int n) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n2 = this.fInCDATA ? this.fDeferredDocumentImpl.createCDATASection(n, false) : this.fDeferredDocumentImpl.createTextNode(n, false);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n2);
        } else {
            Text text;
            if (this.fInCDATA) {
                text = this.fDocument.createCDATASection(this.fStringPool.orphanString(n));
            } else {
                Node node;
                if (this.fWithinElement && this.fCurrentElementNode.getNodeType() == 1 && (node = this.fCurrentElementNode.getLastChild()) != null && node.getNodeType() == 3) {
                    ((Text)node).appendData(this.fStringPool.orphanString(n));
                    return;
                }
                text = this.fDocument.createTextNode(this.fStringPool.orphanString(n));
            }
            this.fCurrentElementNode.appendChild(text);
        }
    }

    public void ignorableWhitespace(int n) throws Exception {
        if (!this.fIncludeIgnorableWhitespace) {
            this.fStringPool.orphanString(n);
            return;
        }
        if (this.fDeferredDocumentImpl != null) {
            int n2 = this.fInCDATA ? this.fDeferredDocumentImpl.createCDATASection(n, true) : this.fDeferredDocumentImpl.createTextNode(n, true);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n2);
        } else {
            Text text;
            if (this.fInCDATA) {
                text = this.fDocument.createCDATASection(this.fStringPool.orphanString(n));
            } else {
                Node node;
                if (this.fWithinElement && this.fCurrentElementNode.getNodeType() == 1 && (node = this.fCurrentElementNode.getLastChild()) != null && node.getNodeType() == 3) {
                    ((Text)node).appendData(this.fStringPool.orphanString(n));
                    return;
                }
                text = this.fDocument.createTextNode(this.fStringPool.orphanString(n));
            }
            if (this.fDocumentImpl != null) {
                ((TextImpl)text).setIgnorableWhitespace(true);
            }
            this.fCurrentElementNode.appendChild(text);
        }
    }

    public void processingInstruction(int n, int n2) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n3 = this.fDeferredDocumentImpl.createProcessingInstruction(n, n2);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n3);
        } else {
            String string = this.fStringPool.orphanString(n);
            String string2 = this.fStringPool.orphanString(n2);
            ProcessingInstruction processingInstruction = this.fDocument.createProcessingInstruction(string, string2);
            this.fCurrentElementNode.appendChild(processingInstruction);
        }
    }

    public void comment(int n) throws Exception {
        if (this.fInDTD && !this.fGrammarAccess) {
            this.fStringPool.orphanString(n);
        } else if (this.fDeferredDocumentImpl != null) {
            int n2 = this.fDeferredDocumentImpl.createComment(n);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n2);
        } else {
            Comment comment = this.fDocument.createComment(this.fStringPool.orphanString(n));
            this.fCurrentElementNode.appendChild(comment);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws Exception {
        this.characters(this.fStringPool.addSymbol(new String(cArray, n, n2)));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws Exception {
    }

    public void startCDATA() throws Exception {
        this.fInCDATA = true;
    }

    public void endCDATA() throws Exception {
        this.fInCDATA = false;
    }

    public void startEntityReference(int n, int n2, int n3) throws Exception {
        this.fCurrentEntityName = n;
        if (!this.fCreateEntityReferenceNodes) {
            return;
        }
        if (n == this.fAmpIndex || n == this.fGtIndex || n == this.fLtIndex || n == this.fAposIndex || n == this.fQuotIndex) {
            return;
        }
        if (n3 != 2) {
            return;
        }
        if (this.fDeferredDocumentImpl != null) {
            int n4 = this.fDeferredDocumentImpl.createEntityReference(n);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, n4);
            this.fCurrentNodeIndex = n4;
        } else {
            EntityReference entityReference = this.fDocument.createEntityReference(this.fStringPool.toString(n));
            this.fCurrentElementNode.appendChild(entityReference);
            this.fCurrentElementNode = entityReference;
        }
    }

    public void endEntityReference(int n, int n2, int n3) throws Exception {
        if (!this.fCreateEntityReferenceNodes) {
            return;
        }
        if (n == this.fAmpIndex || n == this.fGtIndex || n == this.fLtIndex || n == this.fAposIndex || n == this.fQuotIndex) {
            return;
        }
        if (n3 != 2) {
            return;
        }
        if (this.fDeferredDocumentImpl != null) {
            String string = this.fStringPool.toString(n);
            int n4 = this.fCurrentNodeIndex;
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(n4, false);
            if (this.fDeferredDocumentImpl.getNodeType(n4, false) != 5) {
                return;
            }
            n4 = this.fDeferredDocumentImpl.getLastChild(n4, false);
            if (this.fDocumentTypeIndex != -1) {
                if (this.fCurrentEntityNode == -1) {
                    int n5 = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
                    while (n5 != -1) {
                        if (this.fDeferredDocumentImpl.getNodeType(n5, false) == 6 && this.fDeferredDocumentImpl.getNodeNameString(n5, false).equals(string)) break;
                        n5 = this.fDeferredDocumentImpl.getPrevSibling(n5, false);
                    }
                    this.fCurrentEntityNode = n5;
                }
                if (this.fCurrentEntityNode != -1 && this.fDeferredDocumentImpl.getLastChild(this.fCurrentEntityNode, false) == -1) {
                    this.fDeferredDocumentImpl.setAsLastChild(this.fCurrentEntityNode, n4);
                }
                this.fCurrentEntityNode = -1;
                this.fCurrentEntityName = -1;
            }
        } else {
            Node node = this.fCurrentElementNode;
            this.fCurrentElementNode = node.getParentNode();
            if (this.fDocumentImpl != null) {
                String string;
                NamedNodeMap namedNodeMap = this.fDocumentType.getEntities();
                Node node2 = namedNodeMap.getNamedItem(string = this.fStringPool.toString(n));
                if (node2 == null || node2.hasChildNodes()) {
                    return;
                }
                EntityImpl entityImpl = (EntityImpl)node2;
                Node node3 = node.getFirstChild();
                while (node3 != null) {
                    Node node4 = node3.cloneNode(true);
                    entityImpl.appendChild(node4);
                    node3 = node3.getNextSibling();
                }
            }
        }
    }

    public void startDTD(QName qName, int n, int n2) throws Exception {
        this.fInDTD = true;
        if (this.fDocumentImpl != null) {
            String string = this.fStringPool.toString(qName.rawname);
            String string2 = this.fStringPool.toString(n);
            String string3 = this.fStringPool.toString(n2);
            this.fDocumentType = this.fDocumentImpl.createDocumentType(string, string2, string3);
            this.fDocumentImpl.appendChild(this.fDocumentType);
            if (this.fGrammarAccess) {
                Element element = this.fDocument.createElement("schema");
                element.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
                ((AttrImpl)element.getAttributeNode("xmlns")).setSpecified(false);
                element.setAttribute("finalDefault", "");
                ((AttrImpl)element.getAttributeNode("finalDefault")).setSpecified(false);
                element.setAttribute("exactDefault", "");
                ((AttrImpl)element.getAttributeNode("exactDefault")).setSpecified(false);
                this.fDocumentType.appendChild(element);
                this.fCurrentElementNode = element;
            }
        } else if (this.fDeferredDocumentImpl != null) {
            this.fDocumentTypeIndex = this.fDeferredDocumentImpl.createDocumentType(qName.rawname, n, n2);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentIndex, this.fDocumentTypeIndex);
            if (this.fGrammarAccess) {
                int n3 = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("xmlns"), this.fStringPool.addString("http://www.w3.org/2001/XMLSchema"), this.fStringPool.addSymbol("CDATA"), false, false);
                this.fAttrList.addAttr(this.fStringPool.addSymbol("finalDefault"), this.fStringPool.addString(""), this.fStringPool.addSymbol("CDATA"), false, false);
                this.fAttrList.addAttr(this.fStringPool.addSymbol("exactDefault"), this.fStringPool.addString(""), this.fStringPool.addSymbol("CDATA"), false, false);
                this.fAttrList.endAttrList();
                int n4 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("schema"), this.fAttrList, n3);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n4);
                this.fCurrentNodeIndex = n4;
            }
        }
    }

    public void internalSubset(int n) {
        if (this.fDocumentImpl != null && this.fDocumentType != null) {
            ((DocumentTypeImpl)this.fDocumentType).setInternalSubset(this.fStringPool.toString(n));
        } else if (this.fDeferredDocumentImpl != null) {
            this.fDeferredDocumentImpl.setInternalSubset(this.fDocumentTypeIndex, n);
        }
    }

    public void endDTD() throws Exception {
        this.fInDTD = false;
        if (this.fGrammarAccess) {
            if (this.fDocumentImpl != null) {
                this.fCurrentElementNode = this.fDocumentImpl;
            } else if (this.fDeferredDocumentImpl != null) {
                this.fCurrentNodeIndex = 0;
            }
        }
    }

    public void elementDecl(QName qName, int n, int n2, XMLContentSpec.Provider provider) throws Exception {
        block24: {
            block25: {
                int n3;
                String string;
                if (!this.fGrammarAccess) break block24;
                if (this.fDeferredDocumentImpl == null) break block25;
                int n4 = this.getLastChildElement(this.fDocumentTypeIndex, "schema");
                int n5 = this.getLastChildElement(n4, "element", "name", string = this.fStringPool.toString(qName.rawname));
                if (n5 == -1) {
                    n3 = this.fAttrList.startAttrList();
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("1"), this.fStringPool.addSymbol("NMTOKEN"), false, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("nillable"), this.fStringPool.addString("false"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("abstract"), this.fStringPool.addString("false"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("final"), this.fStringPool.addString("false"), this.fStringPool.addSymbol("ENUMERATION"), false, false);
                    this.fAttrList.endAttrList();
                    n5 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, n3);
                    this.fDeferredDocumentImpl.appendChild(n4, n5);
                }
                if ((n3 = this.getLastChildElement(n5, "complexType")) == -1 && n != 2) {
                    n3 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("complexType"), null, -1);
                    this.fDeferredDocumentImpl.insertBefore(n5, n3, this.getFirstChildElement(n5));
                }
                switch (n) {
                    case 0: {
                        int n6 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("content"), this.fStringPool.addString("empty"), true);
                        this.fDeferredDocumentImpl.setAttributeNode(n3, n6);
                        break;
                    }
                    case 1: {
                        int n7 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("any"), null, -1);
                        this.fDeferredDocumentImpl.insertBefore(n3, n7, this.getFirstChildElement(n3));
                        break;
                    }
                    case 2: {
                        XMLContentSpec xMLContentSpec = new XMLContentSpec();
                        provider.getContentSpec(n2, xMLContentSpec);
                        n2 = xMLContentSpec.value;
                        if (n2 == -1) {
                            int n8 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("type"), this.fStringPool.addString("string"), true);
                            this.fDeferredDocumentImpl.setAttributeNode(n5, n8);
                            break;
                        }
                        if (n3 == -1) {
                            n3 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("complexType"), null, -1);
                            this.fDeferredDocumentImpl.insertBefore(n5, n3, this.getFirstChildElement(n5));
                        }
                        int n9 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("content"), this.fStringPool.addString("mixed"), true);
                        this.fDeferredDocumentImpl.setAttributeNode(n3, n9);
                        int n10 = this.fAttrList.startAttrList();
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("unbounded"), this.fStringPool.addSymbol("CDATA"), true, false);
                        this.fAttrList.endAttrList();
                        int n11 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("choice"), this.fAttrList, n10);
                        this.fDeferredDocumentImpl.appendChild(n3, n11);
                        while (n2 != -1) {
                            provider.getContentSpec(n2, xMLContentSpec);
                            int n12 = xMLContentSpec.type;
                            int n13 = xMLContentSpec.value;
                            int n14 = xMLContentSpec.otherValue;
                            if (n12 != 0) {
                                provider.getContentSpec(n14, xMLContentSpec);
                                n10 = this.fAttrList.startAttrList();
                                this.fAttrList.addAttr(this.fStringPool.addSymbol("ref"), this.fStringPool.addString(this.fStringPool.toString(xMLContentSpec.value)), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                                this.fAttrList.endAttrList();
                                int n15 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, n10);
                                int n16 = this.getFirstChildElement(n11);
                                this.fDeferredDocumentImpl.insertBefore(n11, n15, n16);
                                n2 = n13;
                                continue;
                            }
                            break block24;
                        }
                        break block24;
                    }
                    case 4: {
                        int n17 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("content"), this.fStringPool.addString("elementOnly"), true);
                        this.fDeferredDocumentImpl.setAttributeNode(n3, n17);
                        int n18 = this.createChildren(provider, n2, new XMLContentSpec(), this.fDeferredDocumentImpl, -1);
                        this.fDeferredDocumentImpl.insertBefore(n3, n18, this.getFirstChildElement(n3));
                        break;
                    }
                }
                break block24;
            }
            if (this.fDocumentImpl != null) {
                Element element;
                String string;
                Element element2 = XUtil.getLastChildElement((Node)this.fDocumentType, "schema");
                Element element3 = XUtil.getLastChildElement(element2, "element", "name", string = this.fStringPool.toString(qName.rawname));
                if (element3 == null) {
                    element3 = this.fDocumentImpl.createElement("element");
                    element3.setAttribute("name", string);
                    element3.setAttribute("minOccurs", "1");
                    ((AttrImpl)element3.getAttributeNode("minOccurs")).setSpecified(false);
                    element3.setAttribute("nillable", "false");
                    ((AttrImpl)element3.getAttributeNode("nillable")).setSpecified(false);
                    element3.setAttribute("abstract", "false");
                    ((AttrImpl)element3.getAttributeNode("abstract")).setSpecified(false);
                    element3.setAttribute("final", "false");
                    ((AttrImpl)element3.getAttributeNode("final")).setSpecified(false);
                    element2.appendChild(element3);
                }
                if ((element = XUtil.getLastChildElement((Node)element3, "complexType")) == null && n != 2) {
                    element = this.fDocumentImpl.createElement("complexType");
                    element3.insertBefore(element, XUtil.getFirstChildElement(element3));
                }
                block6 : switch (n) {
                    case 0: {
                        element.setAttribute("content", "empty");
                        break;
                    }
                    case 1: {
                        Element element4 = this.fDocumentImpl.createElement("any");
                        element.insertBefore(element4, XUtil.getFirstChildElement(element));
                        break;
                    }
                    case 2: {
                        XMLContentSpec xMLContentSpec = new XMLContentSpec();
                        provider.getContentSpec(n2, xMLContentSpec);
                        n2 = xMLContentSpec.value;
                        if (n2 == -1) {
                            element3.setAttribute("type", "string");
                            break;
                        }
                        if (element == null) {
                            element = this.fDocumentImpl.createElement("complexType");
                            element3.insertBefore(element, XUtil.getFirstChildElement(element3));
                        }
                        element.setAttribute("content", "mixed");
                        Element element5 = this.fDocumentImpl.createElement("choice");
                        element5.setAttribute("minOccurs", "0");
                        element5.setAttribute("maxOccurs", "unbounded");
                        element.appendChild(element5);
                        while (n2 != -1) {
                            provider.getContentSpec(n2, xMLContentSpec);
                            int n19 = xMLContentSpec.type;
                            int n20 = xMLContentSpec.value;
                            int n21 = xMLContentSpec.otherValue;
                            if (n19 == 0) break block6;
                            provider.getContentSpec(n21, xMLContentSpec);
                            Element element6 = this.fDocumentImpl.createElement("element");
                            element6.setAttribute("ref", this.fStringPool.toString(xMLContentSpec.value));
                            Element element7 = XUtil.getFirstChildElement(element5);
                            element5.insertBefore(element6, element7);
                            n2 = n20;
                        }
                        break;
                    }
                    case 4: {
                        element.setAttribute("content", "elementOnly");
                        Element element8 = this.createChildren(provider, n2, new XMLContentSpec(), this.fDocumentImpl, null);
                        element.insertBefore(element8, XUtil.getFirstChildElement(element));
                        break;
                    }
                }
            }
        }
    }

    public void attlistDecl(QName qName, QName qName2, int n, boolean bl, String string, int n2, int n3) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n4;
            if (n3 != -1) {
                n4 = this.fDeferredDocumentImpl.lookupElementDefinition(qName.rawname);
                if (n4 == -1) {
                    n4 = this.fDeferredDocumentImpl.createElementDefinition(qName.rawname);
                    this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n4);
                }
                int n5 = this.fDeferredDocumentImpl.createAttribute(qName2.rawname, qName2.uri, n3, false);
                this.fDeferredDocumentImpl.appendChild(n4, n5);
            }
            if (this.fGrammarAccess) {
                String string2;
                int n6;
                int n7;
                String string3;
                n4 = this.getLastChildElement(this.fDocumentTypeIndex, "schema");
                int n8 = this.getLastChildElement(n4, "element", "name", string3 = this.fStringPool.toString(qName.rawname));
                if (n8 == -1) {
                    n7 = this.fAttrList.startAttrList();
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string3), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                    this.fAttrList.endAttrList();
                    n8 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, n7);
                    this.fDeferredDocumentImpl.appendChild(n4, n8);
                }
                if ((n7 = this.getLastChildElement(n8, "complexType")) == -1) {
                    n7 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("complexType"), null, -1);
                    this.fDeferredDocumentImpl.insertBefore(n8, n7, this.getLastChildElement(n8));
                }
                if ((n6 = this.getLastChildElement(n8, "attribute", "name", string2 = this.fStringPool.toString(qName2.rawname))) == -1) {
                    int n9;
                    int n10 = this.fAttrList.startAttrList();
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string2), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("1"), this.fStringPool.addSymbol("CDATA"), false, false);
                    this.fAttrList.endAttrList();
                    n6 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("attribute"), this.fAttrList, n10);
                    this.fDeferredDocumentImpl.appendChild(n7, n6);
                    if (n == 2) {
                        n10 = this.fAttrList.startAttrList();
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("base"), this.fStringPool.addString("NMTOKEN"), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                        this.fAttrList.endAttrList();
                        n9 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("simpleType"), this.fAttrList, n10);
                        this.fDeferredDocumentImpl.appendChild(n6, n9);
                        String string4 = string.substring(1, string.length() - 1);
                        StringTokenizer stringTokenizer = new StringTokenizer(string4, "|");
                        while (stringTokenizer.hasMoreTokens()) {
                            n10 = this.fAttrList.startAttrList();
                            this.fAttrList.addAttr(this.fStringPool.addSymbol("value"), this.fStringPool.addString(stringTokenizer.nextToken()), this.fStringPool.addSymbol("CDATA"), true, false);
                            this.fAttrList.endAttrList();
                            int n11 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("enumeration"), this.fAttrList, n10);
                            this.fDeferredDocumentImpl.appendChild(n9, n11);
                        }
                    } else {
                        n9 = -1;
                        switch (n) {
                            case 1: {
                                n9 = this.fStringPool.addString(bl ? "ENTITIES" : "ENTITY");
                                break;
                            }
                            case 3: {
                                n9 = this.fStringPool.addString("ID");
                                break;
                            }
                            case 4: {
                                n9 = this.fStringPool.addString(bl ? "IDREFS" : "IDREF");
                                break;
                            }
                            case 5: {
                                n9 = this.fStringPool.addString(bl ? "NMTOKENS" : "NMTOKEN");
                                break;
                            }
                            case 6: {
                                n9 = this.fStringPool.addString("NOTATION");
                                break;
                            }
                            default: {
                                n9 = this.fStringPool.addString("string");
                                break;
                            }
                        }
                        int n12 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("type"), n9, true);
                        this.fDeferredDocumentImpl.setAttributeNode(n6, n12);
                    }
                    n9 = 0;
                    switch (n2) {
                        case 2: {
                            int n13 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("use"), this.fStringPool.addString("required"), true);
                            this.fDeferredDocumentImpl.setAttributeNode(n6, n13);
                            break;
                        }
                        case 16: {
                            n9 = 1;
                            int n14 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("use"), this.fStringPool.addString("fixed"), true);
                            this.fDeferredDocumentImpl.setAttributeNode(n6, n14);
                            break;
                        }
                    }
                    if (n3 != -1) {
                        if (n9 == 0) {
                            int n15 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("use"), this.fStringPool.addString("default"), true);
                            this.fDeferredDocumentImpl.setAttributeNode(n6, n15);
                        }
                        int n16 = this.fDeferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("value"), n3, true);
                        this.fDeferredDocumentImpl.setAttributeNode(n6, n16);
                    }
                }
            }
        } else if (this.fDocumentImpl != null) {
            Object object;
            Object object2;
            String string5;
            String string6;
            Object object3;
            Node node;
            Object object4;
            Object object5;
            if (n3 != -1) {
                object5 = this.fStringPool.toString(qName.rawname);
                object4 = ((DocumentTypeImpl)this.fDocumentType).getElements();
                node = (ElementDefinitionImpl)object4.getNamedItem((String)object5);
                if (node == null) {
                    node = this.fDocumentImpl.createElementDefinition((String)object5);
                    ((DocumentTypeImpl)this.fDocumentType).getElements().setNamedItem(node);
                }
                object3 = this.fStringPool.toString(qName2.rawname);
                string6 = this.fStringPool.toString(n3);
                boolean bl2 = false;
                try {
                    bl2 = this.getNamespaces();
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
                if (bl2) {
                    string5 = this.fStringPool.toString(qName2.uri);
                    object2 = this.fStringPool.toString(qName2.prefix);
                    if (string5.length() == 0) {
                        string5 = null;
                    }
                    if (string5 == null) {
                        if (object2 != null) {
                            if (((String)object2).equals("xmlns")) {
                                string5 = "http://www.w3.org/2000/xmlns/";
                            }
                        } else if (((String)object3).equals("xmlns")) {
                            string5 = "http://www.w3.org/2000/xmlns/";
                        }
                    }
                    object = (AttrImpl)this.fDocumentImpl.createAttributeNS(string5, (String)object3);
                } else {
                    object = (AttrImpl)this.fDocumentImpl.createAttribute((String)object3);
                }
                ((AttrImpl)object).setValue(string6);
                ((AttrImpl)object).setSpecified(false);
                if (bl2) {
                    ((ElementDefinitionImpl)node).getAttributes().setNamedItemNS((Node)object);
                } else {
                    ((ElementDefinitionImpl)node).getAttributes().setNamedItem((Node)object);
                }
            }
            try {
                if (this.fGrammarAccess) {
                    Element element;
                    object5 = XUtil.getLastChildElement((Node)this.fDocumentType, "schema");
                    node = XUtil.getLastChildElement((Node)object5, "element", "name", (String)(object4 = this.fStringPool.toString(qName.rawname)));
                    if (node == null) {
                        node = this.fDocumentImpl.createElement("element");
                        node.setAttribute("name", (String)object4);
                        object5.appendChild(node);
                    }
                    if ((object3 = XUtil.getLastChildElement(node, "complexType")) == null) {
                        object3 = this.fDocumentImpl.createElement("complexType");
                        node.insertBefore((Node)object3, XUtil.getLastChildElement(node));
                    }
                    if ((element = XUtil.getLastChildElement(node, "attribute", "name", string6 = this.fStringPool.toString(qName2.rawname))) == null) {
                        element = this.fDocumentImpl.createElement("attribute");
                        element.setAttribute("name", string6);
                        element.setAttribute("maxOccurs", "1");
                        ((AttrImpl)element.getAttributeNode("maxOccurs")).setSpecified(false);
                        object3.appendChild(element);
                        if (n == 2) {
                            object = this.fDocumentImpl.createElement("simpleType");
                            object.setAttribute("base", "NMTOKEN");
                            element.appendChild((Node)object);
                            string5 = string.substring(1, string.length() - 1);
                            object2 = new StringTokenizer(string5, "|");
                            while (((StringTokenizer)object2).hasMoreTokens()) {
                                Element element2 = this.fDocumentImpl.createElement("enumeration");
                                element2.setAttribute("value", ((StringTokenizer)object2).nextToken());
                                object.appendChild(element2);
                            }
                        } else {
                            object = null;
                            switch (n) {
                                case 1: {
                                    object = bl ? "ENTITIES" : "ENTITY";
                                    break;
                                }
                                case 3: {
                                    object = "ID";
                                    break;
                                }
                                case 4: {
                                    object = bl ? "IDREFS" : "IDREF";
                                    break;
                                }
                                case 5: {
                                    object = bl ? "NMTOKENS" : "NMTOKEN";
                                    break;
                                }
                                case 6: {
                                    object = "NOTATION";
                                    break;
                                }
                                default: {
                                    object = "string";
                                    break;
                                }
                            }
                            element.setAttribute("type", (String)object);
                        }
                        boolean bl3 = false;
                        switch (n2) {
                            case 2: {
                                element.setAttribute("use", "required");
                                break;
                            }
                            case 16: {
                                element.setAttribute("use", "fixed");
                                bl3 = true;
                                break;
                            }
                        }
                        if (n3 != -1) {
                            if (!bl3) {
                                element.setAttribute("use", "default");
                            }
                            element.setAttribute("value", this.fStringPool.toString(n3));
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public void internalPEDecl(int n, int n2) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            if (this.fGrammarAccess) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<!ENTITY % ");
                stringBuffer.append(this.fStringPool.toString(n));
                stringBuffer.append(" \"");
                stringBuffer.append(this.fStringPool.toString(n2));
                stringBuffer.append("\">");
                int n3 = this.fStringPool.addString(stringBuffer.toString());
                int n4 = this.fDeferredDocumentImpl.createComment(n3);
                int n5 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                this.fDeferredDocumentImpl.appendChild(n5, n4);
            }
        } else if (this.fDocumentImpl != null) {
            if (this.fGrammarAccess) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<!ENTITY % ");
                stringBuffer.append(this.fStringPool.toString(n));
                stringBuffer.append(" \"");
                stringBuffer.append(this.fStringPool.toString(n2));
                stringBuffer.append("\">");
                Comment comment = this.fDocumentImpl.createComment(stringBuffer.toString());
                Element element = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
                element.appendChild(comment);
            }
        } else {
            this.fStringPool.orphanString(n2);
        }
    }

    public void externalPEDecl(int n, int n2, int n3) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            if (this.fGrammarAccess) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<!ENTITY ");
                stringBuffer.append(this.fStringPool.toString(n));
                stringBuffer.append(' ');
                if (n2 != -1) {
                    stringBuffer.append("PUBLIC \"");
                    stringBuffer.append(this.fStringPool.toString(n2));
                    stringBuffer.append('\"');
                    if (n3 != -1) {
                        stringBuffer.append(" \"");
                        stringBuffer.append(this.fStringPool.toString(n3));
                        stringBuffer.append('\"');
                    }
                } else if (n3 != -1) {
                    stringBuffer.append("SYSTEM \"");
                    stringBuffer.append(this.fStringPool.toString(n3));
                    stringBuffer.append('\"');
                }
                stringBuffer.append('>');
                int n4 = this.fStringPool.addString(stringBuffer.toString());
                int n5 = this.fDeferredDocumentImpl.createComment(n4);
                int n6 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                this.fDeferredDocumentImpl.appendChild(n6, n5);
            }
        } else if (this.fDocumentImpl != null && this.fGrammarAccess) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<!ENTITY ");
            stringBuffer.append(this.fStringPool.toString(n));
            stringBuffer.append(' ');
            if (n2 != -1) {
                stringBuffer.append("PUBLIC \"");
                stringBuffer.append(this.fStringPool.toString(n2));
                stringBuffer.append('\"');
                if (n3 != -1) {
                    stringBuffer.append(" \"");
                    stringBuffer.append(this.fStringPool.toString(n3));
                    stringBuffer.append('\"');
                }
            } else if (n3 != -1) {
                stringBuffer.append("SYSTEM \"");
                stringBuffer.append(this.fStringPool.toString(n3));
                stringBuffer.append('\"');
            }
            stringBuffer.append('>');
            Comment comment = this.fDocumentImpl.createComment(stringBuffer.toString());
            Element element = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
            element.appendChild(comment);
        }
    }

    public void internalEntityDecl(int n, int n2) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            if (this.fDocumentTypeIndex == -1) {
                return;
            }
            int n3 = this.fDeferredDocumentImpl.createEntity(n, -1, -1, -1);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n3);
            if (this.fGrammarAccess) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<!ENTITY ");
                stringBuffer.append(this.fStringPool.toString(n));
                stringBuffer.append(" \"");
                stringBuffer.append(this.fStringPool.toString(n2));
                stringBuffer.append("\">");
                int n4 = this.fStringPool.addString(stringBuffer.toString());
                int n5 = this.fDeferredDocumentImpl.createComment(n4);
                int n6 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                this.fDeferredDocumentImpl.appendChild(n6, n5);
            }
        } else if (this.fDocumentImpl != null) {
            if (this.fDocumentType == null) {
                return;
            }
            String string = this.fStringPool.toString(n);
            Entity entity = this.fDocumentImpl.createEntity(string);
            this.fDocumentType.getEntities().setNamedItem(entity);
            if (this.fGrammarAccess) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<!ENTITY ");
                stringBuffer.append(this.fStringPool.toString(n));
                stringBuffer.append(" \"");
                stringBuffer.append(this.fStringPool.toString(n2));
                stringBuffer.append("\">");
                Comment comment = this.fDocumentImpl.createComment(stringBuffer.toString());
                Element element = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
                element.appendChild(comment);
            }
        }
    }

    public void externalEntityDecl(int n, int n2, int n3) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n4 = this.fDeferredDocumentImpl.createEntity(n, n2, n3, -1);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n4);
            if (this.fGrammarAccess) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<!ENTITY ");
                stringBuffer.append(this.fStringPool.toString(n));
                stringBuffer.append(' ');
                if (n2 != -1) {
                    stringBuffer.append("PUBLIC \"");
                    stringBuffer.append(this.fStringPool.toString(n2));
                    stringBuffer.append('\"');
                    if (n3 != -1) {
                        stringBuffer.append(" \"");
                        stringBuffer.append(this.fStringPool.toString(n3));
                        stringBuffer.append('\"');
                    }
                } else if (n3 != -1) {
                    stringBuffer.append("SYSTEM \"");
                    stringBuffer.append(this.fStringPool.toString(n3));
                    stringBuffer.append('\"');
                }
                stringBuffer.append('>');
                int n5 = this.fStringPool.addString(stringBuffer.toString());
                int n6 = this.fDeferredDocumentImpl.createComment(n5);
                int n7 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                this.fDeferredDocumentImpl.appendChild(n7, n6);
            }
        } else if (this.fDocumentImpl != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            EntityImpl entityImpl = (EntityImpl)this.fDocumentImpl.createEntity(string);
            if (n2 != -1) {
                entityImpl.setPublicId(string2);
            }
            entityImpl.setSystemId(string3);
            this.fDocumentType.getEntities().setNamedItem(entityImpl);
            if (this.fGrammarAccess) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<!ENTITY ");
                stringBuffer.append(this.fStringPool.toString(n));
                stringBuffer.append(' ');
                if (n2 != -1) {
                    stringBuffer.append("PUBLIC \"");
                    stringBuffer.append(this.fStringPool.toString(n2));
                    stringBuffer.append('\"');
                    if (n3 != -1) {
                        stringBuffer.append(" \"");
                        stringBuffer.append(this.fStringPool.toString(n3));
                        stringBuffer.append('\"');
                    }
                } else if (n3 != -1) {
                    stringBuffer.append("SYSTEM \"");
                    stringBuffer.append(this.fStringPool.toString(n3));
                    stringBuffer.append('\"');
                }
                stringBuffer.append('>');
                Comment comment = this.fDocumentImpl.createComment(stringBuffer.toString());
                Element element = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
                element.appendChild(comment);
            }
        }
    }

    public void unparsedEntityDecl(int n, int n2, int n3, int n4) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            int n5 = this.fDeferredDocumentImpl.createEntity(n, n2, n3, n4);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n5);
            if (this.fGrammarAccess) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<!ENTITY ");
                stringBuffer.append(this.fStringPool.toString(n));
                stringBuffer.append(' ');
                if (n2 != -1) {
                    stringBuffer.append("PUBLIC \"");
                    stringBuffer.append(this.fStringPool.toString(n2));
                    stringBuffer.append('\"');
                    if (n3 != -1) {
                        stringBuffer.append(" \"");
                        stringBuffer.append(this.fStringPool.toString(n3));
                        stringBuffer.append('\"');
                    }
                } else if (n3 != -1) {
                    stringBuffer.append("SYSTEM \"");
                    stringBuffer.append(this.fStringPool.toString(n3));
                    stringBuffer.append('\"');
                }
                stringBuffer.append(" NDATA ");
                stringBuffer.append(this.fStringPool.toString(n4));
                stringBuffer.append('>');
                int n6 = this.fStringPool.addString(stringBuffer.toString());
                int n7 = this.fDeferredDocumentImpl.createComment(n6);
                int n8 = this.getFirstChildElement(this.fDocumentTypeIndex, "schema");
                this.fDeferredDocumentImpl.appendChild(n8, n7);
            }
        } else if (this.fDocumentImpl != null) {
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            String string4 = this.fStringPool.toString(n4);
            EntityImpl entityImpl = (EntityImpl)this.fDocumentImpl.createEntity(string);
            if (n2 != -1) {
                entityImpl.setPublicId(string2);
            }
            entityImpl.setSystemId(string3);
            entityImpl.setNotationName(string4);
            this.fDocumentType.getEntities().setNamedItem(entityImpl);
            if (this.fGrammarAccess) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<!ENTITY ");
                stringBuffer.append(this.fStringPool.toString(n));
                stringBuffer.append(' ');
                if (n2 != -1) {
                    stringBuffer.append("PUBLIC \"");
                    stringBuffer.append(this.fStringPool.toString(n2));
                    stringBuffer.append('\"');
                    if (n3 != -1) {
                        stringBuffer.append(" \"");
                        stringBuffer.append(this.fStringPool.toString(n3));
                        stringBuffer.append('\"');
                    }
                } else if (n3 != -1) {
                    stringBuffer.append("SYSTEM \"");
                    stringBuffer.append(this.fStringPool.toString(n3));
                    stringBuffer.append('\"');
                }
                stringBuffer.append(" NDATA ");
                stringBuffer.append(this.fStringPool.toString(n4));
                stringBuffer.append('>');
                Comment comment = this.fDocumentImpl.createComment(stringBuffer.toString());
                Element element = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema");
                element.appendChild(comment);
            }
        }
    }

    public void notationDecl(int n, int n2, int n3) throws Exception {
        if (this.fDeferredDocumentImpl != null) {
            String string;
            int n4;
            int n5;
            int n6 = this.fDeferredDocumentImpl.createNotation(n, n2, n3);
            this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, n6);
            if (this.fGrammarAccess && (n5 = this.getLastChildElement(n4 = this.getLastChildElement(this.fDocumentTypeIndex, "schema"), "notation", "name", string = this.fStringPool.toString(n))) == -1) {
                int n7 = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("name"), this.fStringPool.addString(string), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                if (n2 != -1) {
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("public"), n2, this.fStringPool.addSymbol("CDATA"), true, false);
                }
                if (n3 != -1) {
                    this.fAttrList.addAttr(this.fStringPool.addSymbol("system"), n3, this.fStringPool.addSymbol("CDATA"), true, false);
                }
                this.fAttrList.endAttrList();
                n5 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol("notation"), this.fAttrList, n7);
                this.fDeferredDocumentImpl.appendChild(n4, n5);
            }
        } else if (this.fDocumentImpl != null) {
            Element element;
            Element element2;
            String string = this.fStringPool.toString(n);
            String string2 = this.fStringPool.toString(n2);
            String string3 = this.fStringPool.toString(n3);
            NotationImpl notationImpl = (NotationImpl)this.fDocumentImpl.createNotation(string);
            notationImpl.setPublicId(string2);
            if (n3 != -1) {
                notationImpl.setSystemId(string3);
            }
            this.fDocumentType.getNotations().setNamedItem(notationImpl);
            if (this.fGrammarAccess && (element2 = XUtil.getFirstChildElement(element = XUtil.getFirstChildElement((Node)this.fDocumentType, "schema"), "notation", "name", string)) == null) {
                element2 = this.fDocument.createElement("notation");
                element2.setAttribute("name", string);
                if (string2 != null) {
                    element2.setAttribute("public", string2);
                }
                if (n3 != -1) {
                    element2.setAttribute("system", string3);
                }
                element.appendChild(element2);
            }
        }
    }

    private final int getFirstChildElement(int n) {
        int n2 = this.getLastChildElement(n);
        while (n2 != -1) {
            int n3 = this.getPrevSiblingElement(n2);
            if (n3 == -1) break;
            n2 = n3;
        }
        return n2;
    }

    private final int getFirstChildElement(int n, String string) {
        int n2 = this.getLastChildElement(n);
        if (n2 != -1) {
            int n3 = this.fStringPool.addSymbol(string);
            while (n2 != -1) {
                int n4;
                if (this.fDeferredDocumentImpl.getNodeName(n2, false) == n3) break;
                n2 = n4 = this.getPrevSiblingElement(n2);
            }
        }
        return n2;
    }

    private final int getLastChildElement(int n) {
        int n2 = this.fDeferredDocumentImpl.getLastChild(n, false);
        while (n2 != -1) {
            if (this.fDeferredDocumentImpl.getNodeType(n2, false) == 1) {
                return n2;
            }
            n2 = this.fDeferredDocumentImpl.getPrevSibling(n2, false);
        }
        return -1;
    }

    private final int getPrevSiblingElement(int n) {
        int n2 = this.fDeferredDocumentImpl.getPrevSibling(n, false);
        while (n2 != -1) {
            if (this.fDeferredDocumentImpl.getNodeType(n2, false) == 1) {
                return n2;
            }
            n2 = this.fDeferredDocumentImpl.getPrevSibling(n2, false);
        }
        return -1;
    }

    private final int getLastChildElement(int n, String string) {
        int n2 = this.getLastChildElement(n);
        if (n2 != -1) {
            while (n2 != -1) {
                String string2 = this.fDeferredDocumentImpl.getNodeNameString(n2, false);
                if (string2.equals(string)) {
                    return n2;
                }
                n2 = this.getPrevSiblingElement(n2);
            }
        }
        return -1;
    }

    private final int getPrevSiblingElement(int n, String string) {
        int n2 = this.getPrevSiblingElement(n);
        if (n2 != -1) {
            while (n2 != -1) {
                String string2 = this.fDeferredDocumentImpl.getNodeNameString(n2, false);
                if (string2.equals(string)) {
                    return n2;
                }
                n2 = this.getPrevSiblingElement(n2);
            }
        }
        return -1;
    }

    private final int getLastChildElement(int n, String string, String string2, String string3) {
        int n2 = this.getLastChildElement(n, string);
        if (n2 != -1) {
            while (n2 != -1) {
                int n3 = this.fDeferredDocumentImpl.getNodeValue(n2, false);
                while (n3 != -1) {
                    int n4;
                    String string4;
                    String string5 = this.fDeferredDocumentImpl.getNodeNameString(n3, false);
                    if (string5.equals(string2) && (string4 = this.fDeferredDocumentImpl.getNodeValueString(n4 = this.fDeferredDocumentImpl.getLastChild(n3, false), false)).equals(string3)) {
                        return n2;
                    }
                    n3 = this.fDeferredDocumentImpl.getPrevSibling(n3, false);
                }
                n2 = this.getPrevSiblingElement(n2, string);
            }
        }
        return -1;
    }

    private final int getPrevSiblingElement(int n, String string, String string2, String string3) {
        int n2 = this.getPrevSiblingElement(n, string);
        if (n2 != -1) {
            int n3 = this.fStringPool.addSymbol(string2);
            while (n2 != -1) {
                int n4 = this.fDeferredDocumentImpl.getNodeValue(n2, false);
                while (n4 != -1) {
                    int n5 = this.fDeferredDocumentImpl.getNodeValue(n4, false);
                    if (string3.equals(this.fStringPool.toString(n5))) {
                        return n2;
                    }
                    n4 = this.fDeferredDocumentImpl.getPrevSibling(n4, false);
                }
                n2 = this.getPrevSiblingElement(n2, string);
            }
        }
        return -1;
    }

    private final void copyInto(Node node, int n) throws Exception {
        boolean bl = node != null && node instanceof DocumentImpl;
        Node node2 = node;
        Node node3 = node;
        Node node4 = node;
        while (node4 != null) {
            int n2 = -1;
            short s = node4.getNodeType();
            switch (s) {
                case 4: {
                    boolean bl2 = bl && ((TextImpl)node4).isIgnorableWhitespace();
                    n2 = this.fDeferredDocumentImpl.createCDATASection(this.fStringPool.addString(node4.getNodeValue()), bl2);
                    break;
                }
                case 8: {
                    n2 = this.fDeferredDocumentImpl.createComment(this.fStringPool.addString(node4.getNodeValue()));
                    break;
                }
                case 1: {
                    int n3;
                    XMLAttrList xMLAttrList = null;
                    int n4 = -1;
                    NamedNodeMap namedNodeMap = node4.getAttributes();
                    if (namedNodeMap != null && (n3 = namedNodeMap.getLength()) > 0) {
                        n4 = this.fAttrList.startAttrList();
                        int n5 = 0;
                        while (n5 < n3) {
                            Attr attr = (Attr)namedNodeMap.item(n5);
                            String string = attr.getNodeName();
                            String string2 = attr.getNodeValue();
                            this.fAttrList.addAttr(this.fStringPool.addSymbol(string), this.fStringPool.addString(string2), this.fStringPool.addSymbol("CDATA"), attr.getSpecified(), false);
                            ++n5;
                        }
                        this.fAttrList.endAttrList();
                        xMLAttrList = this.fAttrList;
                    }
                    n2 = this.fDeferredDocumentImpl.createElement(this.fStringPool.addSymbol(node4.getNodeName()), xMLAttrList, n4);
                    break;
                }
                case 5: {
                    n2 = this.fDeferredDocumentImpl.createEntityReference(this.fStringPool.addSymbol(node4.getNodeName()));
                    break;
                }
                case 7: {
                    n2 = this.fDeferredDocumentImpl.createProcessingInstruction(this.fStringPool.addSymbol(node4.getNodeName()), this.fStringPool.addString(node4.getNodeValue()));
                    break;
                }
                case 3: {
                    boolean bl2 = bl && ((TextImpl)node4).isIgnorableWhitespace();
                    n2 = this.fDeferredDocumentImpl.createTextNode(this.fStringPool.addString(node4.getNodeValue()), bl2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("PAR010 Can't copy node type, " + s + " (" + node4.getNodeName() + ")" + "\n" + s + "\t" + node4.getNodeName());
                }
            }
            this.fDeferredDocumentImpl.appendChild(n, n2);
            if (node4.hasChildNodes()) {
                node3 = node4;
                node4 = node4.getFirstChild();
                n = n2;
                continue;
            }
            node4 = node4.getNextSibling();
            while (node4 == null && node3 != node2) {
                node4 = node3.getNextSibling();
                node3 = node3.getParentNode();
                n = this.fDeferredDocumentImpl.getParentNode(n, false);
            }
        }
    }

    private final void setOccurrenceCount(Element element, int n, int n2) {
        element.setAttribute("minOccurs", Integer.toString(n));
        if (n == 1) {
            ((AttrImpl)element.getAttributeNode("minOccurs")).setSpecified(false);
        }
        if (n2 == -1) {
            element.setAttribute("maxOccurs", "*");
        } else if (n2 != 1) {
            element.setAttribute("maxOccurs", Integer.toString(n2));
        }
    }

    private final Element createChildren(XMLContentSpec.Provider provider, int n, XMLContentSpec xMLContentSpec, DocumentImpl documentImpl, Element element) throws Exception {
        provider.getContentSpec(n, xMLContentSpec);
        int n2 = -1;
        switch (xMLContentSpec.type) {
            case 3: {
                n2 = 43;
                provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                break;
            }
            case 2: {
                n2 = 42;
                provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                break;
            }
            case 1: {
                n2 = 63;
                provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                break;
            }
        }
        int n3 = xMLContentSpec.type;
        switch (n3) {
            case 4: 
            case 5: {
                int n4 = xMLContentSpec.value;
                int n5 = xMLContentSpec.otherValue;
                Element element2 = this.createChildren(provider, n4, xMLContentSpec, documentImpl, element);
                Element element3 = this.createChildren(provider, n5, xMLContentSpec, documentImpl, null);
                boolean bl = n3 == 4;
                String string = bl ? "choice" : "sequence";
                Element element4 = element2;
                if (!element2.getNodeName().equals(string)) {
                    boolean bl2;
                    String string2 = element2.getAttribute("minOccurs");
                    String string3 = element2.getAttribute("maxOccurs");
                    boolean bl3 = string2.length() == 0 || string2.equals("1");
                    boolean bl4 = bl2 = string3.length() == 0 || string3.equals("1");
                    if (element == null || bl3 && bl2) {
                        element4 = documentImpl.createElement(string);
                        element4.appendChild(element2);
                    } else {
                        element4 = element;
                    }
                }
                switch (n2) {
                    case 43: {
                        element4.setAttribute("maxOccurs", "unbounded");
                        break;
                    }
                    case 42: {
                        element4.setAttribute("minOccurs", "0");
                        element4.setAttribute("maxOccurs", "unbounded");
                        break;
                    }
                    case 63: {
                        element4.setAttribute("minOccurs", "0");
                        break;
                    }
                }
                element4.appendChild(element3);
                return element4;
            }
            case 0: {
                Element element5 = documentImpl.createElement("element");
                element5.setAttribute("ref", this.fStringPool.toString(xMLContentSpec.value));
                switch (n2) {
                    case 43: {
                        element5.setAttribute("maxOccurs", "unbounded");
                        break;
                    }
                    case 42: {
                        element5.setAttribute("minOccurs", "0");
                        element5.setAttribute("maxOccurs", "unbounded");
                        break;
                    }
                    case 63: {
                        element5.setAttribute("minOccurs", "0");
                        break;
                    }
                }
                return element5;
            }
        }
        return null;
    }

    private final int createChildren(XMLContentSpec.Provider provider, int n, XMLContentSpec xMLContentSpec, DeferredDocumentImpl deferredDocumentImpl, int n2) throws Exception {
        provider.getContentSpec(n, xMLContentSpec);
        int n3 = -1;
        switch (xMLContentSpec.type) {
            case 3: {
                n3 = 43;
                provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                break;
            }
            case 2: {
                n3 = 42;
                provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                break;
            }
            case 1: {
                n3 = 63;
                provider.getContentSpec(xMLContentSpec.value, xMLContentSpec);
                break;
            }
        }
        int n4 = xMLContentSpec.type;
        switch (n4) {
            case 4: 
            case 5: {
                int n5;
                int n6;
                int n7 = xMLContentSpec.value;
                int n8 = xMLContentSpec.otherValue;
                int n9 = this.createChildren(provider, n7, xMLContentSpec, deferredDocumentImpl, n2);
                int n10 = this.createChildren(provider, n8, xMLContentSpec, deferredDocumentImpl, -1);
                boolean bl = n4 == 4;
                int n11 = this.fStringPool.addSymbol(bl ? "choice" : "sequence");
                int n12 = n9;
                if (deferredDocumentImpl.getNodeName(n9, false) != n11) {
                    boolean bl2;
                    n6 = deferredDocumentImpl.getAttribute(n9, this.fStringPool.addSymbol("minOccurs"));
                    n5 = deferredDocumentImpl.getAttribute(n9, this.fStringPool.addSymbol("maxOccurs"));
                    boolean bl3 = n6 == -1 || this.fStringPool.toString(n6).equals("1");
                    boolean bl4 = bl2 = n5 == -1 || this.fStringPool.toString(n5).equals("1");
                    if (n2 == -1 || bl3 && bl2) {
                        n12 = deferredDocumentImpl.createElement(n11, null, -1);
                        deferredDocumentImpl.appendChild(n12, n9);
                    } else {
                        n12 = n2;
                    }
                }
                switch (n3) {
                    case 43: {
                        n6 = deferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("unbounded"), true);
                        deferredDocumentImpl.setAttributeNode(n12, n6);
                        break;
                    }
                    case 42: {
                        n6 = deferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), true);
                        deferredDocumentImpl.setAttributeNode(n12, n6);
                        n5 = deferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("unbounded"), true);
                        deferredDocumentImpl.setAttributeNode(n12, n5);
                        break;
                    }
                    case 63: {
                        n6 = deferredDocumentImpl.createAttribute(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), true);
                        deferredDocumentImpl.setAttributeNode(n12, n6);
                        break;
                    }
                }
                deferredDocumentImpl.appendChild(n12, n10);
                return n12;
            }
            case 0: {
                int n13 = this.fAttrList.startAttrList();
                this.fAttrList.addAttr(this.fStringPool.addSymbol("ref"), this.fStringPool.addString(this.fStringPool.toString(xMLContentSpec.value)), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                switch (n3) {
                    case 43: {
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("unbounded"), this.fStringPool.addSymbol("CDATA"), true, false);
                        break;
                    }
                    case 42: {
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("maxOccurs"), this.fStringPool.addString("unbounded"), this.fStringPool.addSymbol("CDATA"), true, false);
                        break;
                    }
                    case 63: {
                        this.fAttrList.addAttr(this.fStringPool.addSymbol("minOccurs"), this.fStringPool.addString("0"), this.fStringPool.addSymbol("NMTOKEN"), true, false);
                        break;
                    }
                }
                this.fAttrList.endAttrList();
                int n14 = deferredDocumentImpl.createElement(this.fStringPool.addSymbol("element"), this.fAttrList, n13);
                return n14;
            }
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DOMParser() {
        this.initHandlers(false, this, this);
        this.init();
        try {
            this.setDocumentClassName(DEFAULT_DOCUMENT_CLASS_NAME);
            this.setCreateEntityReferenceNodes(true);
            this.setDeferNodeExpansion(true);
            this.setIncludeIgnorableWhitespace(true);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("PAR001 Fatal error constructing DOMParser.");
        }
    }
}

