/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.FieldActivator;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.XPath;
import org.apache.xerces.validators.schema.identity.XPathException;
import org.apache.xerces.validators.schema.identity.XPathMatcher;

public class Selector {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;

    public org.apache.xerces.validators.schema.identity.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(FieldActivator fieldActivator) {
        return new Matcher(this.fXPath, fieldActivator);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    public Selector(XPath xPath, IdentityConstraint identityConstraint) {
        this.fXPath = xPath;
        this.fIdentityConstraint = identityConstraint;
    }

    public static class XPath
    extends org.apache.xerces.validators.schema.identity.XPath {
        public XPath(String string, StringPool stringPool, NamespacesScope namespacesScope) throws XPathException {
            super(string.trim().startsWith("/") || string.trim().startsWith(".") ? string : "./" + string, stringPool, namespacesScope);
            int n = 0;
            while (n < this.fLocationPaths.length) {
                XPath.Axis axis = this.fLocationPaths[n].steps[this.fLocationPaths[n].steps.length - 1].axis;
                if (axis.type == XPath.Axis.ATTRIBUTE) {
                    throw new XPathException("selectors cannot select attributes");
                }
                ++n;
            }
        }
    }

    protected class Matcher
    extends XPathMatcher {
        protected FieldActivator fFieldActivator;
        protected int fElementDepth;
        protected int fMatchedDepth;

        public void startDocumentFragment(StringPool stringPool) throws Exception {
            super.startDocumentFragment(stringPool);
            this.fElementDepth = 0;
            this.fMatchedDepth = -1;
        }

        public void startElement(QName qName, XMLAttrList xMLAttrList, int n, int n2, SchemaGrammar schemaGrammar) throws Exception {
            super.startElement(qName, xMLAttrList, n, n2, schemaGrammar);
            ++this.fElementDepth;
            if (this.fMatchedDepth == -1 && this.isMatched()) {
                this.fMatchedDepth = this.fElementDepth;
                this.fFieldActivator.startValueScopeFor(Selector.this.fIdentityConstraint);
                int n3 = Selector.this.fIdentityConstraint.getFieldCount();
                int n4 = 0;
                while (n4 < n3) {
                    Field field = Selector.this.fIdentityConstraint.getFieldAt(n4);
                    XPathMatcher xPathMatcher = this.fFieldActivator.activateField(field);
                    xPathMatcher.startElement(qName, xMLAttrList, n, n2, schemaGrammar);
                    ++n4;
                }
            }
        }

        public void endElement(QName qName, int n, SchemaGrammar schemaGrammar) throws Exception {
            super.endElement(qName, n, schemaGrammar);
            if (this.fElementDepth-- == this.fMatchedDepth) {
                this.fMatchedDepth = -1;
                this.fFieldActivator.endValueScopeFor(Selector.this.fIdentityConstraint);
            }
        }

        public Matcher(XPath xPath, FieldActivator fieldActivator) {
            super(xPath, false, Selector.this.fIdentityConstraint);
            this.fFieldActivator = fieldActivator;
        }
    }
}

