/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.source;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import net.sf.sqs_xml.editor.base.source.Source;
import net.sf.sqs_xml.editor.base.source.SourceException;
import net.sf.sqs_xml.editor.base.source.SourceFactory;

public abstract class SourceManager {
    LinkedList sourceList = new LinkedList();
    SourceFactory factory = this.createSourceFactory();

    public String toString() {
        return this.sourceList.toString();
    }

    public abstract SourceFactory createSourceFactory();

    public Source createSource(File file) throws SourceException {
        Source source = this.factory.createSource(file);
        this.sourceList.add(source);
        return source;
    }

    public Source createSource(URL url, boolean readonly, String title) throws SourceException {
        Source source = this.factory.createSource(url, readonly, title);
        this.sourceList.add(source);
        return source;
    }

    public Source createSource() throws SourceException {
        Source source = this.factory.createSource();
        this.sourceList.add(source);
        return source;
    }

    public void close(int index) {
        this.sourceList.remove(index);
    }

    public Source get(int index) {
        if (index != -1 && index < this.sourceList.size()) {
            return (Source)this.sourceList.get(index);
        }
        return null;
    }

    public int getIndexOfFile(File saveAsFile) {
        int i = 0;
        Iterator it = this.sourceList.iterator();
        while (it.hasNext()) {
            Source source = (Source)it.next();
            if (source.getFile() != null && source.getFile().getAbsoluteFile().equals(saveAsFile.getAbsoluteFile())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int size() {
        return this.sourceList.size();
    }

    public int countDirtySources() {
        int count = 0;
        int i = 0;
        while (i < this.sourceList.size()) {
            Source source = (Source)this.sourceList.get(i);
            if (source.isDirty()) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

