/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.sqs_xml.reader.logic.CellValue;
import net.sf.sqs_xml.reader.logic.CellValueOption;
import net.sf.sqs_xml.translator.logic.PDFtoSQMTranslator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;
import net.sf.sqs_xml.util.DOMUtil;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QuestionnaireSchema {
    Document document;
    LinkedList columnNames = null;
    HashMap pageToIDListMap = new LinkedHashMap();
    HashMap qidToIDListMap = new LinkedHashMap();
    HashMap idToPageMap = new HashMap();
    HashMap idToElementMap = new HashMap();
    HashMap idToIDIndexMap = new HashMap();
    static final int TYPE_MAP_VALUE_IS_FORM = 0;
    static final int TYPE_MAP_VALUE_IS_RECT = 1;

    public QuestionnaireSchema(File pdffile, String baseURI) throws TranslatorException {
        try {
            this.document = this.createDocument(pdffile, baseURI);
            this.initIDMap();
            this.initQIDMap();
            this.columnNames = this.createColumnNames();
        }
        catch (IOException ex) {
            throw new TranslatorException(ex);
        }
        catch (TranslatorException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    public int getIDIndex(String id) {
        return (Integer)this.idToIDIndexMap.get(id);
    }

    private Document createDocument(File pdffile, String baseURI) throws TranslatorException, FileNotFoundException, FactoryConfigurationError, SAXException, IOException, ParserConfigurationException {
        PDFtoSQMTranslator translator = new PDFtoSQMTranslator();
        String[] xsltFileNames = PDFtoSQMTranslator.BOOKMARK2SQM.split(" ");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        translator.translate(new BufferedInputStream(new FileInputStream(pdffile)), new TranslatorResource((Logger)new ConsoleLogger(), xsltFileNames), outputStream, baseURI);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(inputStream);
    }

    private void initQIDMap() {
        Iterator it = this.pageToIDListMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Integer page = (Integer)entry.getKey();
            List idList = (List)entry.getValue();
            int i = 0;
            while (i < idList.size()) {
                String id = (String)idList.get(i);
                int p = id.lastIndexOf("/v");
                if (p > 0) {
                    String qid = id.substring(0, p);
                    LinkedList<String> qidList = (LinkedList<String>)this.qidToIDListMap.get(qid);
                    if (qidList == null) {
                        qidList = new LinkedList<String>();
                        this.qidToIDListMap.put(qid, qidList);
                    }
                    qidList.add(id);
                    this.idToPageMap.put(qid, page);
                } else {
                    this.qidToIDListMap.put(id, null);
                }
                ++i;
            }
        }
    }

    private void initIDMap() throws TransformerException {
        int num = this.getNumberOfPages();
        NodeList gList = DOMUtil.getElementList(this.document.getDocumentElement(), "http://www.w3.org/2000/svg", "g");
        int i = 0;
        int pageNumber = 1;
        while (pageNumber <= num) {
            LinkedList<String> idList = new LinkedList<String>();
            this.pageToIDListMap.put(new Integer(pageNumber), idList);
            int j = 0;
            while (i < gList.getLength()) {
                Element gElem = (Element)gList.item(i);
                Element e2 = DOMUtil.getElement(gElem, "http://www.w3.org/2000/svg", "metadata");
                Element e3 = DOMUtil.getElement(e2, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "page");
                if (Integer.parseInt(e3.getAttribute("number")) != pageNumber) break;
                String id = gElem.getAttribute("id");
                idList.add(id);
                this.idToElementMap.put(id, gElem);
                this.idToIDIndexMap.put(id, new Integer(j));
                this.idToPageMap.put(id, new Integer(pageNumber));
                ++j;
                ++i;
            }
            ++pageNumber;
        }
    }

    LinkedHashMap getFormElements(int pageNumber) {
        return this.getArea(pageNumber, 0);
    }

    LinkedHashMap getRectangle(int pageNumber) {
        return this.getArea(pageNumber, 1);
    }

    private LinkedHashMap getArea(int pageNumber, int type) {
        try {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            Object list = null;
            List idList = (List)this.pageToIDListMap.get(new Integer(pageNumber));
            int i = 0;
            while (i < idList.size()) {
                Element gElem;
                String id = (String)idList.get(i);
                if (type == 0) {
                    gElem = (Element)this.idToElementMap.get(id);
                    Element mElem = DOMUtil.getElement(DOMUtil.getElement(gElem, "http://www.w3.org/2000/svg", "rect"), "http://www.w3.org/2000/svg", "metadata");
                    ret.put(id, mElem.getFirstChild());
                } else {
                    gElem = (Element)this.idToElementMap.get(id);
                    Element rElem = DOMUtil.getElement(gElem, "http://www.w3.org/2000/svg", "rect");
                    Rectangle rect = QuestionnaireSchema.createRectangle(rElem);
                    ret.put(id, rect);
                }
                ++i;
            }
            return ret;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    Point[] getMasterPoints() {
        try {
            Element e1 = DOMUtil.getElement(this.document.getDocumentElement(), "http://www.w3.org/2000/svg", "metadata");
            Element elem = DOMUtil.getElement(e1, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "page");
            Point[] ret = new Point[4];
            int i = 0;
            while (i < 4) {
                ret[i] = this.createPoint(elem, i + 1);
                ++i;
            }
            return ret;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Point createPoint(Element elem, int n) {
        return new Point(Integer.parseInt(elem.getAttribute("x" + n)), Integer.parseInt(elem.getAttribute("y" + n)));
    }

    private static Rectangle createRectangle(Element rElem) {
        int x = Integer.parseInt(rElem.getAttribute("x"));
        int y = Integer.parseInt(rElem.getAttribute("y"));
        int width = Integer.parseInt(rElem.getAttribute("width"));
        int height = Integer.parseInt(rElem.getAttribute("height"));
        return new Rectangle(x, y, width, height);
    }

    int getNumberOfPages() {
        try {
            Element e1 = DOMUtil.getElement(this.document.getDocumentElement(), "http://www.w3.org/2000/svg", "metadata");
            Element elem = DOMUtil.getElement(e1, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "page");
            String value = elem.getAttribute("total");
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return -1;
    }

    Set getQIDSet() {
        return this.qidToIDListMap.keySet();
    }

    List getIDList(String qid) {
        return (List)this.qidToIDListMap.get(qid);
    }

    Element getElement(String id) {
        return (Element)this.idToElementMap.get(id);
    }

    int getPage(String id) throws TransformerException {
        return (Integer)this.idToPageMap.get(id);
    }

    Element getFormElement(Element elem) throws TransformerException {
        Element e1 = DOMUtil.getElement(elem, "http://www.w3.org/2000/svg", "rect");
        Element e2 = DOMUtil.getElement(e1, "http://www.w3.org/2000/svg", "metadata");
        return (Element)e2.getFirstChild();
    }

    private LinkedList createColumnNames() throws TransformerException {
        LinkedList<String> columnNames = new LinkedList<String>();
        Iterator it = this.getQIDSet().iterator();
        while (it.hasNext()) {
            String qid = (String)it.next();
            CellValue cellValue = null;
            List list = this.getIDList(qid);
            if (list != null) {
                int itemIndex = 0;
                while (itemIndex < list.size()) {
                    String id = (String)list.get(itemIndex);
                    cellValue = this.createCellOptionValue(qid, id, itemIndex);
                    ++itemIndex;
                }
                this.addColumnNames(columnNames, qid, cellValue, list);
                continue;
            }
            columnNames.add(qid);
        }
        return columnNames;
    }

    private void addColumnNames(LinkedList columnNames, String qid, CellValue cellValue, List list) {
        if (cellValue.type.equals("select1")) {
            columnNames.add(qid);
        } else if (cellValue.type.equals("select")) {
            int itemIndex = 0;
            while (itemIndex < list.size()) {
                columnNames.add(list.get(itemIndex));
                ++itemIndex;
            }
        }
    }

    int getNumberOfColumns() {
        return this.columnNames.size();
    }

    CellValue createCellOptionValue(String qid, String id, int index) throws TransformerException {
        Element elem = this.getElement(id);
        int page = this.getPage(id);
        Element formElem = this.getFormElement(elem);
        String type = formElem.getLocalName();
        String value = id.substring(qid.length() + 2);
        return new CellValueOption(page, qid, type, id, index, value);
    }
}

