/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.rngom.dt.builtin;

import java.util.HashSet;
import java.util.Set;
import org.kohsuke.rngom.dt.builtin.BuiltinDatatypeBuilder;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;

public class BuiltinDatatypeLibrary
implements DatatypeLibrary {
    private final DatatypeLibraryFactory factory;
    private DatatypeLibrary xsdDatatypeLibrary = null;
    public static final String[] XSD_DATATYPE_NAMES = new String[]{"string", "boolean", "float", "double", "decimal", "dateTime", "duration", "hexBinary", "base64Binary", "anyURI", "ID", "IDREF", "ENTITY", "NOTATION", "normalizedString", "token", "language", "IDREFS", "ENTITIES", "NMTOKEN", "NMTOKENS", "Name", "QName", "NCName", "integer", "nonNegativeInteger", "positiveInteger", "nonPositiveInteger", "negativeInteger", "byte", "int", "long", "short", "unsignedByte", "unsignedInt", "unsignedLong", "unsignedShort", "date", "time", "gYearMonth", "gYear", "gMonthDay", "gDay", "gMonth"};
    private static Set xsdDatatypeSet = new HashSet();

    static {
        int i = 0;
        while (i < XSD_DATATYPE_NAMES.length) {
            xsdDatatypeSet.add(XSD_DATATYPE_NAMES[i]);
            ++i;
        }
    }

    public static boolean isXsdDatatype(String type) {
        return xsdDatatypeSet.contains(type);
    }

    BuiltinDatatypeLibrary(DatatypeLibraryFactory factory) {
        this.factory = factory;
    }

    public DatatypeBuilder createDatatypeBuilder(String type) throws DatatypeException {
        this.xsdDatatypeLibrary = this.factory.createDatatypeLibrary("http://www.w3.org/2001/XMLSchema-datatypes");
        if (this.xsdDatatypeLibrary == null) {
            throw new DatatypeException();
        }
        if (BuiltinDatatypeLibrary.isXsdDatatype(type)) {
            return new BuiltinDatatypeBuilder(this.xsdDatatypeLibrary.createDatatype(type));
        }
        throw new DatatypeException();
    }

    public Datatype createDatatype(String type) throws DatatypeException {
        return this.createDatatypeBuilder(type).createDatatype();
    }
}

