/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

import org.w3c.css.sac.LexicalUnit;

public abstract class CSSLexicalUnit
implements LexicalUnit {
    protected short lexicalUnitType;
    protected LexicalUnit nextLexicalUnit;
    protected LexicalUnit previousLexicalUnit;

    protected CSSLexicalUnit(short t, LexicalUnit prev) {
        this.lexicalUnitType = t;
        this.previousLexicalUnit = prev;
        if (prev != null) {
            ((CSSLexicalUnit)prev).nextLexicalUnit = this;
        }
    }

    public short getLexicalUnitType() {
        return this.lexicalUnitType;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    public void setNextLexicalUnit(LexicalUnit lu) {
        this.nextLexicalUnit = lu;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    public void setPreviousLexicalUnit(LexicalUnit lu) {
        this.previousLexicalUnit = lu;
    }

    public int getIntegerValue() {
        throw new IllegalStateException();
    }

    public float getFloatValue() {
        throw new IllegalStateException();
    }

    public String getDimensionUnitText() {
        throw new IllegalStateException();
    }

    public String getFunctionName() {
        throw new IllegalStateException();
    }

    public LexicalUnit getParameters() {
        throw new IllegalStateException();
    }

    public String getStringValue() {
        throw new IllegalStateException();
    }

    public LexicalUnit getSubValues() {
        throw new IllegalStateException();
    }

    public static CSSLexicalUnit createSimple(short t, LexicalUnit prev) {
        return new SimpleLexicalUnit(t, prev);
    }

    public static CSSLexicalUnit createInteger(int val, LexicalUnit prev) {
        return new IntegerLexicalUnit(val, prev);
    }

    public static CSSLexicalUnit createFloat(short t, float val, LexicalUnit prev) {
        return new FloatLexicalUnit(t, val, prev);
    }

    public static CSSLexicalUnit createDimension(float val, String dim, LexicalUnit prev) {
        return new DimensionLexicalUnit(val, dim, prev);
    }

    public static CSSLexicalUnit createFunction(String f, LexicalUnit params, LexicalUnit prev) {
        return new FunctionLexicalUnit(f, params, prev);
    }

    public static CSSLexicalUnit createPredefinedFunction(short t, LexicalUnit params, LexicalUnit prev) {
        return new PredefinedFunctionLexicalUnit(t, params, prev);
    }

    public static CSSLexicalUnit createString(short t, String val, LexicalUnit prev) {
        return new StringLexicalUnit(t, val, prev);
    }

    protected static class StringLexicalUnit
    extends CSSLexicalUnit {
        protected String value;

        public StringLexicalUnit(short t, String val, LexicalUnit prev) {
            super(t, prev);
            this.value = val;
        }

        public String getStringValue() {
            return this.value;
        }
    }

    protected static class PredefinedFunctionLexicalUnit
    extends CSSLexicalUnit {
        protected LexicalUnit parameters;

        public PredefinedFunctionLexicalUnit(short t, LexicalUnit params, LexicalUnit prev) {
            super(t, prev);
            this.parameters = params;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }
    }

    protected static class FunctionLexicalUnit
    extends CSSLexicalUnit {
        protected String name;
        protected LexicalUnit parameters;

        public FunctionLexicalUnit(String f, LexicalUnit params, LexicalUnit prev) {
            super((short)41, prev);
            this.name = f;
            this.parameters = params;
        }

        public String getFunctionName() {
            return this.name;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }
    }

    protected static class DimensionLexicalUnit
    extends CSSLexicalUnit {
        protected float value;
        protected String dimension;

        public DimensionLexicalUnit(float val, String dim, LexicalUnit prev) {
            super((short)42, prev);
            this.value = val;
            this.dimension = dim;
        }

        public float getFloatValue() {
            return this.value;
        }

        public String getDimensionUnitText() {
            return this.dimension;
        }
    }

    protected static class FloatLexicalUnit
    extends CSSLexicalUnit {
        protected float value;

        public FloatLexicalUnit(short t, float val, LexicalUnit prev) {
            super(t, prev);
            this.value = val;
        }

        public float getFloatValue() {
            return this.value;
        }
    }

    protected static class IntegerLexicalUnit
    extends CSSLexicalUnit {
        protected int value;

        public IntegerLexicalUnit(int val, LexicalUnit prev) {
            super((short)13, prev);
            this.value = val;
        }

        public int getIntegerValue() {
            return this.value;
        }
    }

    protected static class SimpleLexicalUnit
    extends CSSLexicalUnit {
        public SimpleLexicalUnit(short t, LexicalUnit prev) {
            super(t, prev);
        }
    }
}

