/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterFactory;
import org.w3c.dom.Document;

public class InterpreterPool {
    private static final String RHINO = "org.apache.batik.script.rhino.RhinoInterpreterFactory";
    private static final String JPYTHON = "org.apache.batik.script.jpython.JPythonInterpreterFactory";
    private static final String JACL = "org.apache.batik.script.jacl.JaclInterpreterFactory";
    public static final String BIND_NAME_DOCUMENT = "document";
    protected static Map defaultFactories;
    protected Map factories = new HashMap(7);

    public InterpreterPool() {
        this.factories.putAll(defaultFactories);
    }

    public Interpreter createInterpreter(Document document, String language) {
        InterpreterFactory factory = (InterpreterFactory)this.factories.get(language);
        Interpreter interpreter = null;
        if (factory != null) {
            try {
                interpreter = factory.createInterpreter(((SVGOMDocument)document).getURLObject());
                if (document != null) {
                    interpreter.bindObject(BIND_NAME_DOCUMENT, document);
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        }
        return interpreter;
    }

    public void putInterpreterFactory(String language, InterpreterFactory factory) {
        this.factories.put(language, factory);
    }

    public void removeInterpreterFactory(String language) {
        this.factories.remove(language);
    }

    static {
        RHINO = RHINO;
        JPYTHON = JPYTHON;
        JACL = JACL;
        BIND_NAME_DOCUMENT = BIND_NAME_DOCUMENT;
        defaultFactories = new HashMap(7);
        InterpreterFactory factory = null;
        try {
            factory = (InterpreterFactory)Class.forName(RHINO).newInstance();
            defaultFactories.put("text/ecmascript", factory);
        }
        catch (Throwable t1) {
            // empty catch block
        }
        try {
            factory = (InterpreterFactory)Class.forName(JPYTHON).newInstance();
            defaultFactories.put("text/python", factory);
        }
        catch (Throwable t2) {
            // empty catch block
        }
        try {
            factory = (InterpreterFactory)Class.forName(JACL).newInstance();
            defaultFactories.put("text/tcl", factory);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

