/*
 * 

 RasterFactory.java

 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sf.sqs_xml.image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

import org.apache.batik.ext.awt.image.codec.FileCacheSeekableStream;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImageDecoder;

public class RasterFactory {
	public static final String TIF = ".tif";
	public static final String TIFF = ".tiff";
	public static final String PNG = ".png";
	public static final String PBM = ".pbm";
	public static final String PPM = ".ppm";
	public static final String GIF = ".gif";
	public static final String ERROR_NOT_PNM = "data format may not be PNM";
	
	public static final int[] BLACK = new int[]{0x00, 0x00, 0x00};
	public static final int[] WHITE = new int[]{0xff, 0xff, 0xff};

	public static boolean isSupported(String filename){
		return isTiff(filename) || isPNG(filename) || isGIF(filename);
	}

	public static boolean isTiff(String filename){
		return filename.toLowerCase().endsWith(TIF) || filename.toLowerCase().endsWith(TIFF);
	}

	public static boolean isPNG(String filename){
		return filename.toLowerCase().endsWith(PNG);
	}

	public static boolean isPBM(String filename){
		return filename.toLowerCase().endsWith(PBM);
	}

	public static boolean isPPM(String filename){
		return filename.toLowerCase().endsWith(PPM);
	}
	
	public static boolean isGIF(String filename){
		return filename.toLowerCase().endsWith(GIF);
	}

	public static Raster create(String filename) throws IOException {
		return create(new java.io.File(filename));
	}

	public static BufferedImage createImage(File file) throws IOException {
		if (isTiff(file.getName())) {
			FileCacheSeekableStream stream = new FileCacheSeekableStream(new FileInputStream(file));
			TIFFImageDecoder decoder =
				new TIFFImageDecoder(
					stream,
					new TIFFDecodeParam());
			RenderedImage renderedImage = decoder.decodeAsRenderedImage();
			BufferedImage image = new BufferedImage(renderedImage.getColorModel(), renderedImage.getData().createCompatibleWritableRaster(), true, new java.util.Hashtable());
			image.setData(renderedImage.getData());
			stream.close();
			return image;
		}else if (isPBM(file.getName())) {
			FileInputStream stream = new FileInputStream(file);
			BufferedImage image = createByPBM(stream);
			stream.close();
			return image;
		} else {
			return ImageIO.read(file);
		}
	}
		
	public static Raster create(File file) throws IOException {
		if (isTiff(file.getName())) {
			FileCacheSeekableStream stream = new FileCacheSeekableStream(new FileInputStream(file));
			TIFFImageDecoder decoder =
				new TIFFImageDecoder(
					stream,
					new TIFFDecodeParam());
			Raster raster = decoder.decodeAsRaster();
			stream.close();
			return raster;
		}else if (isPBM(file.getName())) {
			FileInputStream stream = new FileInputStream(file);
			Raster raster = createByPBM(stream).getData();
			stream.close();
			return raster;
		} else {
			Raster raster = ImageIO.read(file).getData();
			return raster;
		}
	}
	
	public static BufferedImage createByPBM(InputStream in) throws IOException, IllegalArgumentException {
	    return new PBMRasterFactory(in).createByPBM();
	}
}
